/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgPaymentIndex;
import com.gridnine.xtrip.common.pg.uniteller.UnitellerSettings;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.uniteller.CheckOrder;
import com.gridnine.xtrip.server.pg.uniteller.MerchantSettings;
import com.gridnine.xtrip.server.pg.uniteller.RefundBillingPayment;
import com.gridnine.xtrip.server.pg.uniteller.TransactionRecord;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerHelper;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefundPayment {
    private static final transient Logger log = LoggerFactory.getLogger(RefundPayment.class);
    private final EntityContainer<BookingFile> bfCtr;
    private final List<BaseProduct> products;
    private final List<Product> feeProducts;
    private final MerchantSettings settings;
    private final ContractType contractType;
    private final UnitellerSettings config;

    public RefundPayment(EntityContainer<BookingFile> bfCtr, List<BaseProduct> products, List<Product> feeProducts, MerchantSettings settings, ContractType contractType, UnitellerSettings config) {
        this.bfCtr = bfCtr;
        this.products = products;
        this.feeProducts = feeProducts;
        this.settings = settings;
        this.contractType = contractType;
        this.config = config;
    }

    public boolean process() {
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)this.bfCtr.getEntity()));
        BigDecimal sumToRefund = PaymentHelper.calculateSumToRefund(this.products);
        log.trace(String.format("Booking file [%s], product sums to refund [%.2f]", bookingNumber, sumToRefund));
        if (!this.feeProducts.isEmpty()) {
            BigDecimal totalFee = PaymentHelper.getProductsFeeSum(this.feeProducts, (ContractType)this.contractType);
            if (log.isTraceEnabled()) {
                log.trace(String.format("Booking file [%s], fee to refund [%.2f]", bookingNumber, totalFee));
            }
            sumToRefund = sumToRefund.add(totalFee);
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Booking file [%s], Total sum to refund [%.2f]", bookingNumber, sumToRefund));
        }
        if (sumToRefund.compareTo(BigDecimal.ZERO) > 0) {
            CheckOrder handler = new CheckOrder(bookingNumber, this.settings, this.config, BigDecimal.TEN);
            if (handler.getTransactions().isEmpty()) {
                log.error("Cannot get payment details");
                return false;
            }
            Payment p = new Payment();
            List indexes = PaymentHelper.searchPayments((EntityReference)this.bfCtr.toReference());
            if (indexes.size() != 0) {
                p = (Payment)EntityStorage.get().resolve(((PgPaymentIndex)indexes.get(0)).getSource()).getEntity();
            }
            boolean useGdsScheme = UnitellerHelper.canUseSplitScheme(p, this.bfCtr);
            String billNumber = null;
            String billStatus = null;
            if (useGdsScheme) {
                Optional<TransactionRecord> commission = handler.getTransactions().getTransactions().stream().filter(TransactionRecord::isGdsCommission).findFirst();
                if (commission.isPresent()) {
                    billNumber = commission.get().getBillNumber();
                    billStatus = commission.get().getStatus();
                }
            } else {
                billNumber = handler.getTransactions().getTransactions().get(0).getBillNumber();
                billStatus = handler.getTransactions().getTransactions().get(0).getStatus();
            }
            if (TextUtil.isBlank((String)billNumber) || TextUtil.isBlank((String)billStatus)) {
                log.error("Cannot get commision bill number");
                return false;
            }
            if ("canceled".equalsIgnoreCase(billStatus)) {
                log.error(String.format("BillNumber [%s] is already cancelled", billNumber));
                return false;
            }
            return new RefundBillingPayment(this.settings, this.config, sumToRefund, billNumber, bookingNumber).execute();
        }
        log.error(String.format("SumToRefund [%.2f] is less or equal to zero", sumToRefund));
        return false;
    }
}

