/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.server.pg.uniteller.TransactionRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFieldsList {
    public static final String S_FIELDS_CardHolder = "CardHolder";
    public static final String S_FIELDS_CardType = "CardType";
    public static final String S_FIELDS_ApprovalCode = "ApprovalCode";
    public static final String S_FIELDS_CardNumber = "CardNumber";
    public static final String S_FIELDS_BillNumber = "BillNumber";
    public static final String S_FIELDS_NEED_CONFIRM = "need_confirm";
    public static final String S_FIELDS_GDS_PAYMENT_PURPOSE = "gds_payment_purpose_id";
    public static final String S_FIELDS_GDS_PAYMENT_GDS_COMMISION = "10";
    public static final String S_FIELDS_GDS_PAYMENT_GDS_TICKETS = "20";
    protected static final Logger log = LoggerFactory.getLogger(SFieldsList.class);
    private final List<String> slistParams = new ArrayList<String>();

    public SFieldsList() {
        this.slistParams.addAll(this.buildFieldsParam());
    }

    public String getRequestSFieldsValue() {
        StringBuilder result = new StringBuilder();
        for (String param : this.slistParams) {
            if (result.length() > 0) {
                result.append(";");
            }
            result.append(param);
        }
        return result.toString();
    }

    public List<TransactionRecord> parsePaymentInformation(String serverResponse) {
        LinkedList<TransactionRecord> result = new LinkedList<TransactionRecord>();
        try {
            String[] lines = serverResponse.split("\\n");
            Arrays.stream(lines).forEach(line -> {
                Map<String, String> recordValues = this.parseLine((String)line);
                result.add(new TransactionRecord(recordValues));
            });
        }
        catch (Exception e) {
            log.error("parse error", (Throwable)e);
        }
        return result;
    }

    private Map<String, String> parseLine(String line) {
        HashMap<String, String> recordValues = new HashMap<String, String>();
        String[] values = line.split(";");
        int paramN = 0;
        for (String paramName : this.slistParams) {
            if (paramN >= values.length) {
                recordValues.put(paramName, "");
            } else {
                recordValues.put(paramName, values[paramN]);
            }
            ++paramN;
        }
        return recordValues;
    }

    private List<String> buildFieldsParam() {
        ArrayList<String> fieldsParams = new ArrayList<String>();
        fieldsParams.add("Status");
        fieldsParams.add("Total");
        fieldsParams.add(S_FIELDS_ApprovalCode);
        fieldsParams.add(S_FIELDS_BillNumber);
        fieldsParams.add(S_FIELDS_CardHolder);
        fieldsParams.add(S_FIELDS_CardType);
        fieldsParams.add(S_FIELDS_CardNumber);
        fieldsParams.add(S_FIELDS_NEED_CONFIRM);
        fieldsParams.add(S_FIELDS_GDS_PAYMENT_PURPOSE);
        return fieldsParams;
    }
}

