/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.model.system.CardVendor;
import java.math.BigDecimal;
import java.util.Map;

public class TransactionRecord {
    private final Map<String, String> recordValues;

    public TransactionRecord(Map<String, String> values) {
        this.recordValues = values;
    }

    public String getStatus() {
        return this.recordValues.get("Status");
    }

    public BigDecimal getSum() {
        return new BigDecimal(this.recordValues.get("Total"));
    }

    public String getPaymentPurpose() {
        String purpose = this.recordValues.get("gds_payment_purpose_id");
        if (purpose == null) {
            purpose = "";
        }
        return purpose;
    }

    public String getApprovalCode() {
        return this.recordValues.get("ApprovalCode");
    }

    public String getBillNumber() {
        return this.recordValues.get("BillNumber");
    }

    public String getParamValue(String paramName) {
        return this.recordValues.get(paramName);
    }

    public String getCardVendorParamValue() {
        return this.getParamValue("CardType");
    }

    public CardVendor getCardVendor() {
        String cardType = this.getCardVendorParamValue();
        if ("visa".equalsIgnoreCase(cardType)) {
            return CardVendor.VISA;
        }
        if ("mastercard".equalsIgnoreCase(cardType)) {
            return CardVendor.MASTERCARD;
        }
        if ("dinnersclub".equalsIgnoreCase(cardType)) {
            return CardVendor.DINERS_CLUB;
        }
        if ("jcb".equalsIgnoreCase(cardType)) {
            return CardVendor.JCB;
        }
        return null;
    }

    public boolean isCancelled() {
        return "canceled".equalsIgnoreCase(this.getStatus());
    }

    public boolean isGdsTransaction() {
        return "20".equals(this.getPaymentPurpose());
    }

    public String getCardHolder() {
        return this.recordValues.get("CardHolder");
    }

    public String getCardNumber() {
        return this.recordValues.get("CardNumber");
    }

    public CardTransactionDetails toCardDetails() {
        CardTransactionDetails details = new CardTransactionDetails();
        details.setTransactionCode(this.getBillNumber());
        details.setNameOnCard(this.getCardHolder());
        details.setNumber(this.getCardNumber());
        details.setSecurityCode(this.getApprovalCode());
        details.setVendor(this.getCardVendor());
        return details;
    }

    public boolean isGdsCommission() {
        return "10".equals(this.getPaymentPurpose());
    }

    public boolean isNeedConfirm() {
        return "1".equals(this.recordValues.get("need_confirm"));
    }
}

