/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.model.dict.ContractType;
import java.math.BigDecimal;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class UnitellerConfiguration {
    protected static final Logger log = LoggerFactory.getLogger(UnitellerConfiguration.class);
    private final boolean testMode;
    private final String redirectUrl;
    private final String checkUrl;
    private final String refundUrl;
    private final String confirmUrl;
    private final Long queuePeriod;
    private final BigDecimal testAmmount;
    private final ContractType contractType;
    private final boolean useServletServiceDelay;
    private final boolean checkAllIssued;

    public UnitellerConfiguration(Properties data) {
        this.testMode = UnitellerConfiguration.isTrue(data.getProperty("test.enabled"));
        this.queuePeriod = data.contains("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
        this.redirectUrl = data.getProperty("redirect.url");
        this.checkUrl = data.getProperty("check.url");
        this.confirmUrl = data.getProperty("confirm.url");
        this.refundUrl = data.getProperty("refund.url");
        this.testAmmount = data.getProperty("test.ammount") != null ? this.getTestAmount(data.getProperty("test.ammount")) : BigDecimal.ZERO;
        this.checkAllIssued = UnitellerConfiguration.isTrue(data.getProperty("check.all.tickets.issued"));
        this.contractType = data.containsKey("contract.type") ? ContractType.valueOf((String)data.getProperty("contract.type")) : ContractType.CLIENT;
        this.useServletServiceDelay = UnitellerConfiguration.isTrue(data.getProperty("use.servlet.service.delay"));
    }

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }

    public boolean isUseServletServiceDelay() {
        return this.useServletServiceDelay;
    }

    boolean isCheckAllIssued() {
        return this.checkAllIssued;
    }

    private BigDecimal getTestAmount(String value) {
        try {
            double parseDouble = Double.parseDouble(value);
            return new BigDecimal(parseDouble);
        }
        catch (NumberFormatException e) {
            log.warn("parse exception", (Throwable)e);
            return BigDecimal.ZERO;
        }
    }

    BigDecimal getTestAmount() {
        return this.testAmmount;
    }

    boolean isValid() {
        return true;
    }

    boolean isTestMode() {
        return this.testMode;
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getCheckUrl() {
        return this.checkUrl;
    }

    public String getRefundUrl() {
        return this.refundUrl;
    }

    public String getConfirmUrl() {
        return this.confirmUrl;
    }

    public ContractType getContractType() {
        return this.contractType;
    }
}

