/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.PaymentHttpHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class UnitellerHelper {
    static final CodeTranslator codeTranslator = new CodeTranslator(new String[]{CodeSystem.IATA.name(), CodeSystem.CRT.name()});
    private static final Logger log = Logger.getLogger(UnitellerHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeHttpConnection(HttpsURLConnection connection, Map<String, String> requestParameters) throws Exception {
        StringBuilder serverResponse = new StringBuilder("");
        try {
            StringBuilder params = UnitellerHelper.createParamsString(requestParameters);
            connection.setSSLSocketFactory(PaymentHttpHelper.getFactoryTlsV12());
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("charset", "utf-8");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Length", Integer.toString(params.toString().getBytes().length));
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
                writer.write(params.toString());
                writer.flush();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                String readLine = in.readLine();
                while (readLine != null) {
                    if (serverResponse.length() > 0) {
                        serverResponse.append("\n");
                    }
                    serverResponse.append(readLine);
                    readLine = in.readLine();
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
            log.trace((Object)String.format("executeHttpConnection response code = %d, text: %s", connection.getResponseCode(), serverResponse));
            return serverResponse.toString();
        }
        catch (Exception e) {
            log.error((Object)"Http connection error", (Throwable)e);
            throw e;
        }
    }

    static boolean canUseSplitScheme(Payment payment, EntityContainer<BookingFile> bfCtr) {
        if (!PaymentType.CREDIT_CARD_SPLIT_UNITELLER.equals((Object)payment.getPaymentType())) {
            return false;
        }
        return PaymentHelper.canUseSplitScheme((BookingFile)((BookingFile)bfCtr.getEntity()));
    }

    public static StringBuilder createParamsString(Map<String, String> paramMap) throws UnsupportedEncodingException {
        StringBuilder params = new StringBuilder();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (params.length() > 0) {
                params.append("&");
            }
            params.append(key + "=" + URLEncoder.encode(value, "UTF-8"));
        }
        log.debug((Object)("Encode params to [" + params + "]"));
        return params;
    }
}

