/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.pg.SplitPaymentSupport;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.uniteller.UnitellerSettings;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorInfoBuilder;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.PaymentQueueManager;
import com.gridnine.xtrip.server.pg.uniteller.CheckOrder;
import com.gridnine.xtrip.server.pg.uniteller.DBUnitellerSettingsProvider;
import com.gridnine.xtrip.server.pg.uniteller.DefaultOrderTotalPriceProvider;
import com.gridnine.xtrip.server.pg.uniteller.InitiatePayment;
import com.gridnine.xtrip.server.pg.uniteller.MerchantSettings;
import com.gridnine.xtrip.server.pg.uniteller.RefundBillingPayment;
import com.gridnine.xtrip.server.pg.uniteller.RefundPayment;
import com.gridnine.xtrip.server.pg.uniteller.TransactionRecord;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerSettingsProvider;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class UnitellerPGConnector
extends PGConnector
implements SplitPaymentSupport {
    private boolean enabled;
    private UnitellerSettingsProvider settingsProvider = new DBUnitellerSettingsProvider();
    private Tracer tracer;
    private boolean disposed;

    public UnitellerPGConnector(PgName pgName) {
        super(pgName);
    }

    public UnitellerPGConnector() {
    }

    public UnitellerSettingsProvider getSettingsProvider() {
        return this.settingsProvider;
    }

    public void setSettingsProvider(UnitellerSettingsProvider settingsProvider) {
        this.settingsProvider = settingsProvider;
    }

    public void removeFromQueue(String paymentId) throws Exception {
        super.removeFromQueue(paymentId);
        if (!paymentId.contains("/split")) {
            super.removeFromQueue(paymentId + "/split");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refund(EntityContainer<BookingFile> bookingFile, List<BaseProduct> products, List<Product> feeProducts) {
        this.checkDisposedState();
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFile.getEntity()));
        this.log.info(String.format("Start Uniteller refund for booking file [%s]", bookingNumber));
        PGInvocationContext.get().begin(InvocationName.INITIATE_PAYMENT.toString());
        PGInvocationContext.get().setPaymentId(bookingNumber);
        try {
            SalesContext salesContext = PaymentHelper.restoreSalesContext(bookingFile);
            MerchantSettings settings = new MerchantSettings(PGRulesHelper.getPGParameters((SalesContext)salesContext, (PgName)this.getId(), (Payment)new Payment()));
            boolean bl = new RefundPayment(bookingFile, products, feeProducts, settings, this.getContractType(bookingFile), this.settingsProvider.get()).process();
            return bl;
        }
        catch (Exception ex) {
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            boolean bl = false;
            return bl;
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, null);
        }
    }

    public PgName getId() {
        return PgName.UNITELLER;
    }

    public void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.enabled = true;
        this.tracer = PGHelper.createTracer((PgName)this.getId());
        this.settingsProvider.get();
        this.setQueueManager(new PaymentQueueManager(this.getQueuePeriod(), this.getId()));
        this.log.debug("configured");
    }

    public PGConnectorInfo getConnectorInfo() {
        return PGConnectorInfoBuilder.buildInfo((PgName)this.getId(), (boolean)this.isEnabled(), (PaymentType[])new PaymentType[]{PaymentType.CREDIT_CARD_UNITELLER, PaymentType.CREDIT_CARD_SPLIT_UNITELLER, PaymentType.DENGI_MAIL_RU_UNITELLER, PaymentType.EASY_PAY_UNITELLER, PaymentType.EUROSET_UNITELLER, PaymentType.MOBILE_PAYMENT_BEELINE_UNITELLER, PaymentType.MOBILE_PAYMENT_MEGAFON_UNITELLER, PaymentType.MOBILE_PAYMENT_MTS_UNITELLER, PaymentType.MONEY_MAIL_UNITELLER, PaymentType.MONEYBOOKERS_UNITELLER, PaymentType.PAYPAL_UNITELLER, PaymentType.PLAT_FON_UNITELLER, PaymentType.PLATEZH_RU_UNITELLER, PaymentType.QIWI_WALLET_UNITELLER, PaymentType.RBK_MONEY_UNITELLER, PaymentType.VKONTAKTE_UNITELLER, PaymentType.WEB_MONEY_WMR_UNITELLER, PaymentType.YANDEX_MONEY_UNITELLER, PaymentType.YOTA_MONEY_UNITELLER});
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        this.checkDisposedState();
        Payment payment = parameters.getPayment();
        PGInvocationContext.get().begin(InvocationName.INITIATE_PAYMENT.toString());
        Date startDate = new Date();
        PGInvocationContext.get().setPaymentId(payment.getPaymentId());
        PaymentInitiationResult result = new PaymentInitiationResult();
        result.setPayment(payment);
        try {
            if (!parameters.isDontDoReprice()) {
                this.doPaymentReprice(payment);
            }
            MerchantSettings merchantSettings = this.getMerchantSettings(parameters);
            this.processInitiate(parameters, result, merchantSettings);
            this.paymentInitiated(result.getPayment(), result.getMessages());
            result.setSuccess(true);
            result.getMessages().add(MessageHelper.createMessage((String)"\u041f\u043b\u0430\u0442\u0435\u0436 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d", (String)result.getPayment().getPaymentId(), (Object[])new Object[]{PgName.UNITELLER}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, null);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (PGException ex) {
            this.log.error(String.format("payment [%s] initiation failed", this.getPaymentEntityCaption(parameters.getPayment())), (Throwable)ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, (Throwable)ex);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (Throwable t) {
            this.log.error(String.format("payment [%s] initiation failed", this.getPaymentEntityCaption(parameters.getPayment())), t);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)t));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)"\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", (String)payment.getPaymentId(), (Object[])new Object[]{PgName.UNITELLER}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, t);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, result.getPgLog());
        }
    }

    public void processInitiate(PaymentInitiationParameters params, PaymentInitiationResult result, MerchantSettings settings) {
        UnitellerSettings unitellerSettings = this.settingsProvider.get();
        BigDecimal totalPrice = new DefaultOrderTotalPriceProvider().get((EntityReference<BookingFile>)params.getPayment().getEntity(), params.getPayment().getPaymentType(), unitellerSettings);
        new InitiatePayment(result, params, settings, unitellerSettings, totalPrice).process();
    }

    public MerchantSettings getMerchantSettings(PaymentInitiationParameters parameters) throws Exception {
        return this.getMerchantSettings(parameters.getSalesContext(), parameters.getPg(), parameters.getPayment());
    }

    public MerchantSettings getMerchantSettings(SalesContext salesContext, PgName pgName, Payment payment) throws Exception {
        return new MerchantSettings(PGRulesHelper.getPGParameters((SalesContext)salesContext, (PgName)pgName, (Payment)payment));
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        throw new UnsupportedOperationException();
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.enabled;
    }

    public PaymentType getSplitSupplierPaymentType() {
        return PaymentType.CREDIT_CARD_SUPPLIER_UNITELLER;
    }

    public PaymentType getSplitAgencyPaymentType() {
        return PaymentType.CREDIT_CARD_AGENCY_UNITELLER;
    }

    public PaymentType getSplitMainPaymentType() {
        return PaymentType.CREDIT_CARD_SPLIT_UNITELLER;
    }

    public boolean canUseSplitScheme(EntityContainer<BookingFile> bfCtr) throws Exception {
        boolean canUseSplitScheme = PaymentHelper.canUseSplitScheme((BookingFile)((BookingFile)bfCtr.getEntity()));
        if (!canUseSplitScheme) {
            return false;
        }
        PgName pgName = this.getId();
        SalesContext sct = PaymentHelper.restoreSalesContext(bfCtr);
        if (pgName != null) {
            String[] vals;
            PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)sct, (PgName)pgName, (Payment)new Payment());
            if (!pgParameters.getApplicablePG().contains(pgName)) {
                return false;
            }
            String paramstring = pgParameters.getPgAccount();
            if (paramstring == null) {
                throw new Exception(String.format("\u0414\u043b\u044f \u041f\u0428 %s \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430", pgName));
            }
            if (paramstring.contains(";") && (vals = paramstring.split(";")).length >= 4) {
                return true;
            }
        }
        return false;
    }

    void doFullRefund(EntityContainer<BookingFile> bfCtr) {
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bfCtr.getEntity()));
        this.log.info(String.format("Start Uniteller FULL refund for booking file [%s]", bookingNumber));
        try {
            MerchantSettings settings = this.getMerchantSettings(PaymentHelper.restoreSalesContext(bfCtr), this.getId(), new Payment());
            CheckOrder checkHandler = new CheckOrder(bookingNumber, settings, this.settingsProvider.get(), BigDecimal.TEN);
            if (checkHandler.getTransactions().isEmpty()) {
                this.log.error("Cannot get payment details");
                return;
            }
            for (TransactionRecord transaction : checkHandler.getTransactions().getTransactions()) {
                if (transaction.isCancelled()) {
                    this.log.warn(String.format("BillNumber [%s] is already cancelled", transaction.getBillNumber()));
                    continue;
                }
                new RefundBillingPayment(settings, this.settingsProvider.get(), transaction.getSum(), transaction.getBillNumber(), bookingNumber).execute();
            }
        }
        catch (Exception ex) {
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
        }
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    private void checkDisposedState() {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
    }

    private String getPaymentEntityCaption(Payment payment) {
        String result = "unknown";
        try {
            result = payment.getEntity().getCaption();
        }
        catch (Exception e) {
            this.log.error("getPaymentEntityCaption", (Throwable)e);
        }
        return result;
    }
}

