/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGLogItem;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.uniteller.UnitellerSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.pg.LongRecordBuilder;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.uniteller.CheckOrder;
import com.gridnine.xtrip.server.pg.uniteller.ConfirmPayment;
import com.gridnine.xtrip.server.pg.uniteller.DefaultOrderTotalPriceProvider;
import com.gridnine.xtrip.server.pg.uniteller.MerchantSettings;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerPGConnector;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitellerPGServlet
extends PGServlet {
    private static final long serialVersionUID = 9083032265046450896L;
    private static final Logger log = LoggerFactory.getLogger(UnitellerPGServlet.class);

    protected PgName getId() {
        return PgName.UNITELLER;
    }

    /*
     * Exception decompiling
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void cleanUpQueue(String ... paymentIds) throws Exception {
        HashSet<String> values = new HashSet<String>(Arrays.asList(paymentIds));
        for (String value : values) {
            this.getConnector().removeFromQueue(value);
        }
    }

    private void processUnderLock(List<Message> messages, Payment payment, MerchantSettings merchantSettings, EntityContainer<BookingFile> bookingFile, String bookingNumber) throws Exception {
        LockUtil.lock((EntityReference)bookingFile.toReference(), () -> {
            UnitellerSettings settings = this.getUnitellerPgConnector().getSettingsProvider().get();
            if (payment.getStatus() == PaymentStatus.SUCCEEDED) {
                this.processPaidStatus(messages, merchantSettings, this.reloadBookingFile(bookingFile), bookingNumber, payment, settings);
            } else if (payment.getStatus() == PaymentStatus.INITIATED) {
                this.processAuthorizedStatus(messages, merchantSettings, this.reloadBookingFile(bookingFile), bookingNumber, payment, settings);
            } else if (payment.getStatus() == PaymentStatus.FAILED) {
                this.paymentFailed(payment, messages);
            } else {
                throw new Exception("couldn't determine payment status");
            }
        });
    }

    private EntityContainer<BookingFile> reloadBookingFile(EntityContainer<BookingFile> bookingFile) {
        EntityStorage storage = EntityStorage.get();
        EntityContainer reloadedBf = storage.resolve(bookingFile.toReference());
        if (null == reloadedBf) {
            return null;
        }
        return reloadedBf;
    }

    private String getPaymentId(Map<String, String> requestParameters) throws Exception {
        String paymentId = requestParameters.get("Order_ID");
        if (TextUtil.isBlank((String)paymentId)) {
            throw new Exception("missing parameter 'Order_ID'");
        }
        return paymentId;
    }

    private void handlerException(Date startDate, Map<String, String> requestParameters, PGServletResponse pgResponse, Throwable t) {
        log.error("service failed", t);
        pgResponse.setResponseCode(500);
        pgResponse.setResponseText(t.getMessage());
        PGInvocationContext.get().addTraceData(0, startDate, InvocationName.SERVLET_SERVICE.toString(), requestParameters, (Object)pgResponse, t);
    }

    private void finishService(Date startDate, Map<String, String> requestParameters, PGServletResponse pgResponse, List<Message> messages, List<PGLogItem> pgLog, Payment payment) {
        PGInvocationContext.get().addTraceData(0, startDate, InvocationName.SERVLET_SERVICE.toString(), requestParameters, (Object)pgResponse, null);
        PGInvocationContext.get().end(this.getConnector(), pgLog);
        if (payment != null) {
            PGInvocationContext.get().saveDocs(pgLog, messages, payment.getPayee());
        }
        pgResponse.send();
        LogicalStorage.reset();
    }

    private String getQueuePaymentId(Map<String, String> requestParameters, String paymentId) {
        String queuePaymentId = paymentId;
        String operationType = requestParameters.get("Operation_Type");
        if (this.isSplitOperationType(operationType)) {
            queuePaymentId = queuePaymentId + "/split";
        }
        return queuePaymentId;
    }

    private boolean isSplitOperationType(String operationType) {
        return "gds_ticket".equals(operationType) || "gds_commission".equals(operationType);
    }

    private void handlePaymentNotFound(String queuePaymentId) throws Exception {
        Payment initiatedSplitPayment = this.getFromQueue(queuePaymentId + "/split");
        if (initiatedSplitPayment != null) {
            this.handleSplitPaymentPayedByCommon(queuePaymentId, initiatedSplitPayment);
        }
        log.warn(String.format("Payment processed [%s]", queuePaymentId));
    }

    private void handleSplitPaymentPayedByCommon(String queuePaymentId, Payment initiatedSplitPayment) throws Exception {
        SysLogHelper.audit((EntityReference)initiatedSplitPayment.getEntity(), (String)"payment error", (Message[])new Message[]{MessageHelper.createErrorMessage((String)"\u043e\u043f\u043b\u0430\u0442\u0430 \u043a\u0430\u0440\u0442\u043e\u0439 Maestro/Visa Electron", (String)"\u0420\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0431\u044b\u043b \u043e\u043f\u043b\u0430\u0447\u0435\u043d \u043a\u0430\u0440\u0442\u043e\u0439 Maestro/Visa Electron, \u0447\u0442\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e (VIP-14964)", (Object[])new Object[0])});
        log.error("Split order " + queuePaymentId + " paid by common scheme");
        this.cleanUpQueue(queuePaymentId, initiatedSplitPayment.getPaymentId());
    }

    private UnitellerPGConnector getUnitellerPgConnector() {
        return (UnitellerPGConnector)this.getConnector();
    }

    private void handleInvalidBookingFileStatus(String bookingNumber) {
        log.trace(String.format("The booking file is already payed - stop processing the request [bookingNumber=%s]", bookingNumber));
    }

    private boolean isValidBookingFileStatus(EntityContainer<BookingFile> bookingFile) {
        return ((BookingFile)bookingFile.getEntity()).getWorkflowStatus() != WorkflowStatus.PAYED;
    }

    private void processPaidStatus(List<Message> messages, MerchantSettings merchantSettings, EntityContainer<BookingFile> bookingFile, String bookingNumber, Payment payment, UnitellerSettings settings) throws Exception {
        BigDecimal totalPrice = new DefaultOrderTotalPriceProvider().get((EntityReference<BookingFile>)payment.getEntity(), payment.getPaymentType(), settings);
        CheckOrder checkHandler = this.doCheckOrder(bookingNumber, totalPrice, merchantSettings, settings);
        if (checkHandler.isFullyPayed()) {
            checkHandler.updateModels(payment, bookingFile);
            this.paymentSucceeded(payment, messages);
        }
    }

    private void processAuthorizedStatus(List<Message> messages, MerchantSettings merchantSettings, EntityContainer<BookingFile> bookingFile, String bookingNumber, Payment payment, UnitellerSettings settings) throws Exception {
        if (!this.isCreditCardUsed(payment)) {
            this.paymentInitiated(payment, messages);
            return;
        }
        BigDecimal totalPrice = new DefaultOrderTotalPriceProvider().get((EntityReference<BookingFile>)payment.getEntity(), payment.getPaymentType(), settings);
        CheckOrder checkHandler = this.doCheckOrder(bookingNumber, totalPrice, merchantSettings, settings);
        if (checkHandler.isFullyPayed()) {
            checkHandler.updateModels(payment, bookingFile);
            this.paymentSucceeded(payment, messages);
            this.postSuccessProcess(merchantSettings, bookingFile, bookingNumber, payment, checkHandler, settings);
        }
    }

    private boolean isCreditCardUsed(Payment payment) {
        return payment.getPaymentType() == PaymentType.CREDIT_CARD_UNITELLER || payment.getPaymentType() == PaymentType.CREDIT_CARD_SPLIT_UNITELLER;
    }

    private void postSuccessProcess(MerchantSettings merchantSettings, EntityContainer<BookingFile> bookingFile, String bookingNumber, Payment lockPayment, CheckOrder checkOrder, UnitellerSettings settings) throws Exception {
        boolean sendConfirmation = true;
        if (settings.isCheckAllIssued()) {
            EntityContainer<BookingFile> reloadBookingFile = this.resolveEntity(lockPayment);
            boolean allIssued = PaymentHelper.isAllIssued((BookingFile)((BookingFile)reloadBookingFile.getEntity()));
            boolean hasSoldProducts = PaymentHelper.hasSoldProducts((BookingFile)((BookingFile)reloadBookingFile.getEntity()));
            log.warn(String.format("Checking issue status, allIssued = %b, hasSoldProducts = %b, bookingFile [%s]", allIssued, hasSoldProducts, bookingNumber));
            sendConfirmation = allIssued;
            if (!allIssued) {
                this.refundPayedWhenNotIssued(bookingFile, bookingNumber, hasSoldProducts);
                return;
            }
        }
        if (checkOrder.isNeedToConfirm() && sendConfirmation) {
            this.confirmBillingItems(merchantSettings, settings, bookingFile, lockPayment, checkOrder);
        }
    }

    private EntityContainer<BookingFile> resolveEntity(Payment lockPayment) {
        return EntityStorage.get().resolve(lockPayment.getEntity());
    }

    private void refundPayedWhenNotIssued(EntityContainer<BookingFile> bookingFile, String bookingNumber, boolean hasSoldProducts) throws Exception {
        if (hasSoldProducts) {
            log.error(String.format("Not all tickeds are issued, bookingFile [%s]", bookingNumber));
            throw new Exception("issuing failed");
        }
        log.warn(String.format("Make a full refund because of issue errors, bookingFile [%s]", bookingNumber));
        this.getUnitellerPgConnector().doFullRefund(bookingFile);
    }

    private void confirmBillingItems(MerchantSettings merchantSettings, UnitellerSettings config, EntityContainer<BookingFile> bookingFile, Payment payment, CheckOrder checkOrder) {
        String iData = this.calculateIDataLongRecord((BookingFile)bookingFile.getEntity(), payment);
        checkOrder.getTransactions().getBillingNumbersToConfirm().forEach(billingNumber -> this.createConfirmHandler(merchantSettings, config, (String)billingNumber, iData).execute());
    }

    protected ConfirmPayment createConfirmHandler(MerchantSettings merchantSettings, UnitellerSettings config, String billingNumber, String iData) {
        return new ConfirmPayment(billingNumber, iData, config, merchantSettings, this.getConnector());
    }

    protected void authorizeStorage() throws Exception {
        LogicalStorage.get().authorizeAsSystem();
    }

    private Map<String, String> getRequestParams(HttpServletRequest request) {
        LinkedHashMap<String, String> requestParameters;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            requestParameters = new LinkedHashMap();
            try {
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                List items = upload.parseRequest(request);
                items.stream().filter(FileItem::isFormField).forEachOrdered(fileItem -> requestParameters.put(fileItem.getFieldName(), fileItem.getString()));
            }
            catch (FileUploadException e) {
                log.error("Error getting request parameters", (Throwable)e);
            }
        } else {
            requestParameters = PGHelper.convertRequestParametersMap((Map)request.getParameterMap());
        }
        return requestParameters;
    }

    private String calculateIDataLongRecord(BookingFile bookingFile, Payment payment) {
        boolean isAirBooking;
        String iData = "";
        boolean bl = isAirBooking = BookingHelper.getBaseProductReservation((BookingFile)bookingFile, (boolean)false) != null;
        if (isAirBooking) {
            try {
                iData = new LongRecordBuilder().build(payment);
            }
            catch (Exception e) {
                log.warn("getIData error", (Throwable)e);
            }
        }
        return iData;
    }

    private CheckOrder doCheckOrder(String bookingNumber, BigDecimal totalPrice, MerchantSettings merchantSettings, UnitellerSettings settings) throws Exception {
        this.emulateDelay(settings);
        CheckOrder handler = this.createCheckOrderHandler(bookingNumber, merchantSettings, settings, totalPrice);
        handler.check();
        log.info(String.format("if payment is full [%b], [bookingNumber=%s]", handler.isFullyPayed(), bookingNumber));
        return handler;
    }

    private void emulateDelay(UnitellerSettings config) {
        if (config.isUseServletServiceDelay()) {
            log.warn("emulate delay 60s");
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                log.warn("interrupted exception", (Throwable)e);
            }
        }
    }

    protected CheckOrder createCheckOrderHandler(String bookingNumber, MerchantSettings merchantSettings, UnitellerSettings settings, BigDecimal totalPrice) {
        return new CheckOrder(bookingNumber, merchantSettings, settings, totalPrice);
    }
}

