/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.wayforpay;

import java.util.Properties;

class Configuration {
    private final boolean traceEnabled;
    private final boolean testMode;
    private final boolean correctSignature;
    private final String redirectUrl;
    private final Long queuePeriod;
    private final String twoStageConfirmUrl;
    private final String twoStageRefundUrl;

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }

    Configuration(Properties data) {
        this.traceEnabled = Configuration.isTrue(data.getProperty("trace.enabled"));
        this.testMode = Configuration.isTrue(data.getProperty("test.enabled"));
        this.queuePeriod = data.contains("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
        this.correctSignature = Configuration.isTrue(data.getProperty("correct.signature"));
        this.redirectUrl = data.getProperty("redirect.url");
        this.twoStageConfirmUrl = data.getProperty("two.stage.confirm.url");
        this.twoStageRefundUrl = data.getProperty("two.stage.refund.url");
    }

    boolean isCorrectSignature() {
        return this.correctSignature;
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    boolean isValid() {
        return true;
    }

    boolean isTest() {
        return this.testMode;
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getTwoStageConfirmUrl() {
        return this.twoStageConfirmUrl;
    }

    public String getTwoStageRefundUrl() {
        return this.twoStageRefundUrl;
    }
}

