/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.wayforpay;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.wayforpay.Configuration;
import com.gridnine.xtrip.server.pg.wayforpay.WayForPayHelper;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandlerInitiatePayment {
    protected static final transient Logger log = LoggerFactory.getLogger(HandlerInitiatePayment.class);

    HandlerInitiatePayment() {
    }

    public static void process(PaymentInitiationResult result, PaymentInitiationParameters parameters, PGParameters pgParameters, Configuration configuration) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        EntityContainer bfCtr;
        String pnr = "";
        String orderddate = "";
        if (result.getPayment().getEntity() != null && BookingFile.class.equals((Object)result.getPayment().getEntity().getType())) {
            try {
                bfCtr = EntityStorage.get().resolve(result.getPayment().getEntity());
                pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)((Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0)));
                orderddate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0)).getResDate());
            }
            catch (Throwable t) {
                log.warn("failed to get pnr", t);
            }
        }
        result.getRedirectForm().setUrl(configuration.getRedirectUrl());
        result.getRedirectForm().setMethod("POST");
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("ORDER_PRICE[]", WayForPayHelper.getPaymentAmountString(parameters.getPayment(), configuration.isTest())));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("ORDER_PCODE[]", parameters.getPayment().getPaymentId()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("PRICES_CURRENCY", WayForPayHelper.getCurrency()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("ORDER_DATE", orderddate));
        bfCtr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(parameters.getPayment().getEntity());
        bfCtr.getVersionInfo().setDataSource("auto-ticketing");
        BookingFile bf = (BookingFile)bfCtr.getEntity();
        Reservation res = (Reservation)bf.getReservations().get(0);
        StringBuilder pinfo = new StringBuilder();
        for (BaseProduct prod : res.getProducts()) {
            if (!(prod instanceof Product)) continue;
            Product product = (Product)prod;
            CodeTranslator translator = new CodeTranslator(new String[]{"IATA", "ISO", "CRT"});
            pinfo.append("departuredate:" + new SimpleDateFormat("yyyyMMdd").format(((Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0)).getStartDate()));
            pinfo.append(",locationnumber:2");
            pinfo.append(",locationcode1:" + translator.getNativeCode(((Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0)).getDepartureLocation()));
            pinfo.append(",locationcode2:" + translator.getNativeCode(((Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0)).getArriveLocation()));
            pinfo.append(",passengername:" + product.getTraveller().getPassport().getFirstName() + " " + product.getTraveller().getPassport().getLastName());
            pinfo.append(",reservationcode:" + pnr + "");
            break;
        }
        pnr = TextUtil.translit((String)pnr, (boolean)true);
        String pinfoStr = TextUtil.translit((String)pinfo.toString(), (boolean)true);
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("ORDER_PNAME[]", pnr));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("ORDER_PINFO[]", pinfoStr));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("ORDER_QTY[]", "1"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("ORDER_VAT[]", "0"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("ORDER_SHIPPING", "0"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("MERCHANT", WayForPayHelper.getMerchantId(pgParameters.getPgAccount())));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("BACK_REF", parameters.getReturnUrl()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("PAY_METHOD", HandlerInitiatePayment.getPaymentType(parameters.getPayment().getPaymentType())));
        boolean twoStageMode = WayForPayHelper.isTwoStageMode(pgParameters.getPgAccount(), parameters.getPayment().getPaymentType());
        if (twoStageMode) {
            result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("PAY_TYPE", "AUTH"));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Wayforpay initiate, [twoStageMode=%b]", twoStageMode));
        }
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("LANGUAGE", HandlerInitiatePayment.getLanguage(parameters)));
        HandlerInitiatePayment.setSignature(result, parameters, pgParameters, orderddate, pnr, WayForPayHelper.getPaymentAmountString(parameters.getPayment(), configuration.isTest()), WayForPayHelper.getCurrency(), HandlerInitiatePayment.getPaymentType(parameters.getPayment().getPaymentType()), HandlerInitiatePayment.getLanguage(parameters), pinfoStr, configuration);
    }

    private static String getLanguage(PaymentInitiationParameters parameters) {
        return parameters.getPayment().getCustomerInfo().getPreferredLocale() != null && "EN".equalsIgnoreCase(parameters.getPayment().getCustomerInfo().getPreferredLocale().getLanguage()) ? "EN" : "RU";
    }

    private static void setSignature(PaymentInitiationResult result, PaymentInitiationParameters parameters, PGParameters pgParameters, String orderddate, String pnr, String amount, String currency, String paymethod, String language, String pinfo, Configuration configuration) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        String sig = Integer.toString(WayForPayHelper.getMerchantId(pgParameters.getPgAccount()).length()) + WayForPayHelper.getMerchantId(pgParameters.getPgAccount()) + (orderddate.equalsIgnoreCase("") ? "" : Integer.toString(orderddate.length()) + orderddate) + (pnr.equalsIgnoreCase("") ? "" : Integer.toString(pnr.length()) + pnr) + Integer.toString(parameters.getPayment().getPaymentId().length()) + parameters.getPayment().getPaymentId() + Integer.toString(pinfo.length()) + pinfo + Integer.toString(amount.length()) + amount + "111010" + Integer.toString(currency.length()) + currency + (paymethod.equalsIgnoreCase("") ? "0" : Integer.toString(paymethod.length()) + paymethod);
        PGInvocationContext.get().addTraceData(new Date(), "sig unhashed", (Object)sig, null, null);
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("ORDER_HASH", WayForPayHelper.getHMAC(sig, pgParameters.getPgPassword())));
    }

    private static String getPaymentType(PaymentType paymentType) {
        switch (paymentType) {
            case LIQPAY_TERMINAL_WAYFORPAY: {
                return "LIQPAY_TERMINAL";
            }
            case PRIVAT24_WAYFORPAY: {
                return "PRIVAT24";
            }
            case CREDIT_CARD_WAYFORPAY: {
                return "CCVISAMC";
            }
        }
        return "";
    }

    private static NamedValue namedValue(String name, String value) {
        NamedValue nv = new NamedValue();
        nv.setName(name);
        nv.setValue(value);
        return nv;
    }
}

