/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.wayforpay;

import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.pg.wayforpay.WayForPayPGConnector;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class WayForPayHelper {
    private static final DecimalFormat priceFormatter;

    private static double getPaymentAmount(Payment payment, boolean isTest) {
        if (isTest) {
            return 2.0;
        }
        return payment.getAmount().doubleValue();
    }

    public static String getMerchantId(String pgAccount) {
        String[] vals;
        if (pgAccount.contains(";") && (vals = pgAccount.split(";")).length > 0) {
            return vals[0];
        }
        return pgAccount;
    }

    public static boolean isTwoStageMode(String pgAccount, PaymentType paymentType) {
        String[] vals;
        Set<PaymentType> paymentTypesSupportedPreAuth = WayForPayPGConnector.getPaymentTypesSupportedPreAuth();
        if (!paymentTypesSupportedPreAuth.contains(paymentType)) {
            return false;
        }
        if (pgAccount.contains(";") && (vals = pgAccount.split(";")).length > 1) {
            return vals[1].equalsIgnoreCase("1");
        }
        return false;
    }

    public static String getPaymentAmountString(Payment payment, boolean isTest) {
        return priceFormatter.format(WayForPayHelper.getPaymentAmount(payment, isTest));
    }

    public static String getCurrency() {
        return DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
    }

    public static String getHMAC(String sig, String key) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacMD5");
        Mac mac = Mac.getInstance("HmacMD5");
        mac.init(keySpec);
        byte[] bytes = mac.doFinal(sig.getBytes(StandardCharsets.UTF_8));
        StringBuilder hash = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(0xFF & aByte);
            if (hex.length() == 1) {
                hash.append('0');
            }
            hash.append(hex);
        }
        return hash.toString();
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        priceFormatter = new DecimalFormat("0.00", dfs);
    }
}

