/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.util.ObjectFactory;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageConfigurator;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationStartedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.ModelLogicalStorageConfigurator;
import com.gridnine.xtrip.server.railway.index.ExpressExchangeDocumentIndexHandler;
import com.gridnine.xtrip.server.railway.index.RailwayCommonProductFopIndexHandler;
import com.gridnine.xtrip.server.railway.index.RailwayCommonProductIndexHandler;
import com.gridnine.xtrip.server.railway.index.RailwayProductIndexHandler;
import com.gridnine.xtrip.server.railway.index.SPGDArchiveExchangeDocumentIndexHandler;
import com.gridnine.xtrip.server.railway.index.SPGDExchangeDocumentIndexHandler;
import com.gridnine.xtrip.server.railway.index.UFSExchangeDocumentIndexHandler;
import com.gridnine.xtrip.server.railway.interceptors.RailwayMcoProductInterceptor;
import com.gridnine.xtrip.server.railway.interceptors.RailwayProductInterceptor;
import com.gridnine.xtrip.server.railway.interceptors.RailwayReferenceMCOInterceptor;
import com.gridnine.xtrip.server.railway.interceptors.RailwayRulesInterceptor;
import com.gridnine.xtrip.server.railway.interceptors.RailwayStationInterceptor;
import org.slf4j.LoggerFactory;

public class RailwayLogicalStorageConfigurator
implements LogicalStorageConfigurator {
    public void configure(LogicalStorageRegistry registry) {
        registry.registerEntityInterceptor((EntityInterceptor)new RailwayProductInterceptor());
        registry.registerEntityInterceptor((EntityInterceptor)new RailwayMcoProductInterceptor());
        registry.registerEntityInterceptor((EntityInterceptor)new RailwayRulesInterceptor());
        registry.registerEntityInterceptor((EntityInterceptor)new RailwayReferenceMCOInterceptor());
        registry.registerDictionaryOperationStartedInterceptor((DictionaryStorageOperationStartedInterceptor)new RailwayStationInterceptor());
        registry.registerIndexHandler(RailwayLogicalStorageConfigurator.createHandler("railway-railway-product-index-handler.className", new ObjectFactory<IndexHandler<BookingFile, RailwayProductIndex>>(){

            public IndexHandler<BookingFile, RailwayProductIndex> createObject() {
                return new RailwayProductIndexHandler();
            }
        }));
        registry.registerIndexHandler(RailwayLogicalStorageConfigurator.createHandler("railway-common-product-index-handler.className", new ObjectFactory<IndexHandler<BookingFile, CommonProductIndex>>(){

            public IndexHandler<BookingFile, CommonProductIndex> createObject() {
                return new RailwayCommonProductIndexHandler();
            }
        }));
        registry.registerIndexHandler((IndexHandler)new RailwayCommonProductFopIndexHandler());
        registry.registerIndexHandler((IndexHandler)new SPGDExchangeDocumentIndexHandler());
        registry.registerIndexHandler((IndexHandler)new ExpressExchangeDocumentIndexHandler());
        registry.registerIndexHandler((IndexHandler)new SPGDArchiveExchangeDocumentIndexHandler());
        registry.registerIndexHandler((IndexHandler)new UFSExchangeDocumentIndexHandler());
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>, H extends IndexHandler<E, I>> H createHandler(String key, ObjectFactory<H> objectFactory) {
        String clsName = System.getProperty(key);
        if (clsName == null) {
            return (H)((IndexHandler)objectFactory.createObject());
        }
        try {
            return (H)((IndexHandler)ModelLogicalStorageConfigurator.class.getClassLoader().loadClass(clsName).newInstance());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ModelLogicalStorageConfigurator.class).error("unable to load class " + clsName, (Throwable)e);
            return (H)((IndexHandler)objectFactory.createObject());
        }
    }
}

