/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.dict;

import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCard;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCardType;
import com.gridnine.xtrip.common.util.CaseInsensitive;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.java.plugin.util.ExtendedProperties;

public class RailwayStationHelper {
    private static final String RAILWAY_STATION_CARD_TYPES = "railway.stationCardTypes";
    private static final Map<RailwayStationVendorCardType, Integer> RAILWAY_STATION_CARD_PRIORITIES = RailwayStationHelper.createPriorityMap();
    private static final Comparator<RailwayStationVendorCard> RAILWAY_STATION_CARD_COMPARATOR = Comparator.comparingInt(card -> card != null && card.getType() != null ? RAILWAY_STATION_CARD_PRIORITIES.get(card.getType()) : RailwayStationVendorCardType.values().length);

    private static Map<RailwayStationVendorCardType, Integer> createPriorityMap() {
        EnumMap<RailwayStationVendorCardType, Integer> result = new EnumMap<RailwayStationVendorCardType, Integer>(RailwayStationVendorCardType.class);
        result.put(RailwayStationVendorCardType.SYSTEM, 0);
        ExtendedProperties serverProperties = ServerConfiguration.get().getConfiguration();
        String propertyValue = serverProperties.getProperty(RAILWAY_STATION_CARD_TYPES);
        if (TextUtil.nonBlank((String)propertyValue)) {
            for (String string : propertyValue.split(",")) {
                RailwayStationVendorCardType cardType;
                if (TextUtil.isBlank((String)string)) continue;
                try {
                    cardType = (RailwayStationVendorCardType)EnumUtil.fromName(RailwayStationVendorCardType.class, (String)string.trim(), (CaseInsensitive)CaseInsensitive.YES);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("card from name " + string + " not found", e);
                }
                if (result.containsKey(cardType)) {
                    throw new IllegalArgumentException(cardType + " card already registered");
                }
                result.put(cardType, result.size());
            }
        }
        for (RailwayStationVendorCardType railwayStationVendorCardType : RailwayStationVendorCardType.values()) {
            result.putIfAbsent(railwayStationVendorCardType, result.size());
        }
        return result;
    }

    public static void updateFromCards(RailwayStation station) {
        RailwayStationHelper.clear(station);
        for (RailwayStationVendorCard vendorCard : RailwayStationHelper.getSortedVendorCards(station)) {
            RailwayStationHelper.updateFromCard(station, vendorCard);
        }
        RailwayStationHelper.removeRepeatedSpellVariants(station);
    }

    private static List<RailwayStationVendorCard> getSortedVendorCards(RailwayStation station) {
        return station.getVendorCards().stream().filter(Objects::nonNull).sorted(RAILWAY_STATION_CARD_COMPARATOR.reversed()).collect(Collectors.toList());
    }

    private static void updateFromCard(RailwayStation station, RailwayStationVendorCard card) {
        if (card == null) {
            return;
        }
        if (card.getCountry() != null) {
            station.setCountry(card.getCountry());
        }
        if (card.getRoute() != null) {
            station.setRoute(card.getRoute());
        }
        for (Map.Entry translation : card.getTranslations().getValues().entrySet()) {
            if (translation.getKey() == null || TextUtil.isBlank((String)((String)translation.getValue()))) continue;
            if (station.getTranslations().containsKey(translation.getKey())) {
                station.getSpellVariants().add(station.getTranslations().get(translation.getKey()));
            }
            station.getTranslations().put(translation.getKey(), translation.getValue());
        }
        for (Map.Entry shortName : card.getShortNames().getValues().entrySet()) {
            if (shortName.getKey() == null || TextUtil.isBlank((String)((String)shortName.getValue()))) continue;
            if (station.getShortNames().containsKey(shortName.getKey())) {
                station.getSpellVariants().add(station.getShortNames().get(shortName.getKey()));
            }
            station.getShortNames().put(shortName.getKey(), shortName.getValue());
        }
        station.getSpellVariants().addAll(card.getSpellVariants());
    }

    private static void clear(RailwayStation station) {
        station.setCountry(null);
        station.setRoute(null);
        station.getTranslations().clear();
        station.getShortNames().clear();
        station.getSpellVariants().clear();
    }

    private static void removeRepeatedSpellVariants(RailwayStation station) {
        ArrayList spellVariants = new ArrayList(station.getSpellVariants());
        station.getSpellVariants().clear();
        for (String spellVariant : spellVariants) {
            if (CollectionUtil.contains(station.getTranslations().values(), (Object)spellVariant, (s1, s2) -> TextUtil.isSame((String)s1, (String)s2, (boolean)true)) || CollectionUtil.contains((Collection)station.getSpellVariants(), (Object)spellVariant, (s1, s2) -> TextUtil.isSame((String)s1, (String)s2, (boolean)true))) continue;
            station.getSpellVariants().add(spellVariant);
        }
    }
}

