/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class RailwayBillingTransactionHandler
implements ProductBillingTransactionsHandler<RailwayProduct> {
    public ProductType getProductType(RailwayProduct product) {
        return HandlersRegistry.get().findProductHandler(RailwayProduct.class).getProductType((BaseProduct)product);
    }

    public Class<RailwayProduct> getProductClass() {
        return RailwayProduct.class;
    }

    public TicketType getTicketType(RailwayProduct product) {
        return product.getTicketType();
    }

    public ProductStatus getStatus(RailwayProduct product) {
        return product.getStatus();
    }

    public BillingTransactionStatus getBillingTransactionStatus(RailwayProduct product) {
        return BillingTransactionStatus.ACTIVE;
    }

    public List<ProductBillingTransactionsHandler.FopData> getClientFops(RailwayProduct product) {
        RailwayProductContractRelationData contractRelation = RailwayProductHelper.getClientContractRelation((RailwayProduct)product);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(RailwayProduct product) {
        RailwayProductContractRelationData contractRelation = RailwayProductHelper.getSubagentContractRelation((RailwayProduct)product, (boolean)false);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(RailwayProduct product) {
        RailwayProductContractRelationData contractRelation = RailwayProductHelper.getVendorContractRelation((RailwayProduct)product);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    public String getShortName(RailwayProduct product) {
        return HandlersRegistry.get().findProductHandler(RailwayProduct.class).generateShortProductName((BaseProduct)product);
    }

    public EntityReference<Organization> getSupplier(RailwayProduct product) {
        return RailwayProductHelper.getSupplier((BaseProduct)product);
    }

    public EntityReference<Organization> getAgency(RailwayProduct product) {
        return RailwayProductHelper.getAgency((RailwayProduct)product);
    }

    public EntityReference<Organization> getSubagency(RailwayProduct product) {
        return RailwayProductHelper.getSubagency((RailwayProduct)product);
    }

    public EntityReference<SalesPoint> getSalesPoint(RailwayProduct product) {
        return product.getSalesPoint();
    }

    public boolean isCreateForRetail() {
        return false;
    }

    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }

    private List<ProductBillingTransactionsHandler.FopData> createFops(List<RailwayProductFop> fops, final DictionaryReference<CurrencyInfo> currency) {
        ArrayList<ProductBillingTransactionsHandler.FopData> result = new ArrayList<ProductBillingTransactionsHandler.FopData>();
        for (RailwayProductFop fopi : fops) {
            try {
                final RailwayProductFop fop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fopi);
                result.add(new ProductBillingTransactionsHandler.FopData(){
                    private final Money amount;
                    {
                        this.amount = fop.getAmount() != null && fop.getAmount().getValue() != null ? SystemHelper.getMoney((double)fop.getAmount().getValue().doubleValue(), (String)(currency != null ? currency.getCode() : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"))) : null;
                    }

                    public String getUid() {
                        return fop.getUid();
                    }

                    public PaymentType getPaymentType() {
                        return fop.getType();
                    }

                    public Date getOperationDate() {
                        return fop.getOperationDate();
                    }

                    public Money getAmount() {
                        return this.amount;
                    }

                    public EntityReference<Person> getAgent() {
                        return fop.getAgent();
                    }

                    public List<ProductBillingTransactionsHandler.CommissionData> getCommissions() {
                        return BillingTransactionHandlersHelper.getCommissions((List)fop.getCommissions(), (DictionaryReference)currency);
                    }

                    public Card getCard() {
                        return fop.getCard();
                    }

                    public boolean isRefused() {
                        return fop.isRefused();
                    }
                });
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

