/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.handlers.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayCrimeaMcoHelper;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class RailwayCrimeaMcoBillingTransactionHandler
implements ProductBillingTransactionsHandler<RailwayCrimeaMco> {
    public ProductType getProductType(RailwayCrimeaMco product) {
        return HandlersRegistry.get().findProductHandler(RailwayCrimeaMco.class).getProductType((BaseProduct)product);
    }

    public Class<RailwayCrimeaMco> getProductClass() {
        return RailwayCrimeaMco.class;
    }

    public TicketType getTicketType(RailwayCrimeaMco product) {
        return product.getTicketType();
    }

    public ProductStatus getStatus(RailwayCrimeaMco product) {
        return product.getStatus();
    }

    public BillingTransactionStatus getBillingTransactionStatus(RailwayCrimeaMco product) {
        return BillingTransactionStatus.ACTIVE;
    }

    public List<ProductBillingTransactionsHandler.FopData> getClientFops(RailwayCrimeaMco product) {
        RailwayProductContractRelationData contractRelation = RailwayCrimeaMcoHelper.getClientContractRelation((RailwayCrimeaMco)product);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(RailwayCrimeaMco product) {
        RailwayProductContractRelationData contractRelation = RailwayCrimeaMcoHelper.getSubagentContractRelation((RailwayCrimeaMco)product, (boolean)false);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(RailwayCrimeaMco product) {
        RailwayProductContractRelationData contractRelation = RailwayCrimeaMcoHelper.getVendorContractRelation((RailwayCrimeaMco)product);
        return contractRelation != null ? this.createFops(contractRelation.getFops(), (DictionaryReference<CurrencyInfo>)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    public String getShortName(RailwayCrimeaMco product) {
        return HandlersRegistry.get().findProductHandler(RailwayCrimeaMco.class).generateShortProductName((BaseProduct)product);
    }

    public EntityReference<Organization> getSupplier(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getSupplier((RailwayCrimeaMco)product);
    }

    public EntityReference<Organization> getAgency(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getAgency((RailwayCrimeaMco)product);
    }

    public EntityReference<Organization> getSubagency(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getSubagency((RailwayCrimeaMco)product);
    }

    public EntityReference<SalesPoint> getSalesPoint(RailwayCrimeaMco product) {
        return product.getSalesPoint();
    }

    public boolean isCreateForRetail() {
        return false;
    }

    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }

    private List<ProductBillingTransactionsHandler.FopData> createFops(List<RailwayProductFop> fops, final DictionaryReference<CurrencyInfo> currency) {
        ArrayList<ProductBillingTransactionsHandler.FopData> result = new ArrayList<ProductBillingTransactionsHandler.FopData>();
        for (RailwayProductFop fopi : fops) {
            try {
                final RailwayProductFop fop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fopi);
                result.add(new ProductBillingTransactionsHandler.FopData(){
                    private final Money amount;
                    {
                        this.amount = fop.getAmount() != null && fop.getAmount().getValue() != null ? SystemHelper.getMoney((double)fop.getAmount().getValue().doubleValue(), (String)(currency != null ? currency.getCode() : DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"))) : null;
                    }

                    public String getUid() {
                        return fop.getUid();
                    }

                    public PaymentType getPaymentType() {
                        return fop.getType();
                    }

                    public Date getOperationDate() {
                        return fop.getOperationDate();
                    }

                    public Money getAmount() {
                        return this.amount;
                    }

                    public EntityReference<Person> getAgent() {
                        return fop.getAgent();
                    }

                    public List<ProductBillingTransactionsHandler.CommissionData> getCommissions() {
                        return BillingTransactionHandlersHelper.getCommissions((List)fop.getCommissions(), (DictionaryReference)currency);
                    }

                    public Card getCard() {
                        return fop.getCard();
                    }

                    public boolean isRefused() {
                        return fop.isRefused();
                    }
                });
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

