/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.handlers.rules;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayMcoProductHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProductPropertiesProvider;
import com.gridnine.xtrip.common.railway.model.rules.standart.Targets;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayMcoProductCommissionActionSet;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayMcoProductPropertySet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailwayMcoRulesHandler
implements RulesHandler {
    public static final String ID = MiscUtil.getSimpleClassName(RailwayMcoRulesHandler.class);

    public void applyRules(EntityContainer<BookingFile> bookingFileContainer, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, DebugInfo debugInfo, boolean calcAppliedRulesToBooking) throws Exception {
        RailwayMcoRulesProductHandler rulesHandler = (RailwayMcoRulesProductHandler)((Object)ReflectionUtil.createBySystemPropertyName((String)"com.gridnine.xtrip.server.railway.handlers.rules.RailwayRulesHandler.RailwayMcoRulesProductHandler.className", (Logger)LoggerFactory.getLogger(this.getClass()), () -> new RailwayMcoRulesProductHandler()));
        rulesHandler.setAfterRulesAppliedConsumer(this.afterRulesAppliedConsumer());
        GeneralProductRulesHelper.applyContracts(bookingFileContainer, (boolean)forced, (boolean)simulate, (RulesProductHandler)rulesHandler, messages, params, (boolean)calcAppliedRulesToBooking);
    }

    public String getId() {
        return ID;
    }

    protected Consumer<RailwayMcoProduct> afterRulesAppliedConsumer() {
        return railwayProduct -> {};
    }

    public static class RailwayMcoRulesProductHandler
    extends RulesProductHandler<RailwayMcoProduct, RailwayMcoProductPropertySet, RailwayMcoProductCommissionActionSet> {
        private final ProductHandler<RailwayMcoProduct> productHandler = this.getProductHandler();
        private final Map<RailwayMcoProduct, List<GeneralProductContractRelationData>> relationsMap = new HashMap<RailwayMcoProduct, List<GeneralProductContractRelationData>>();
        private Consumer<RailwayMcoProduct> afterRulesAppliedConsumer;

        public void setAfterRulesAppliedConsumer(Consumer<RailwayMcoProduct> afterRulesAppliedConsumer) {
            this.afterRulesAppliedConsumer = afterRulesAppliedConsumer;
        }

        public void clearActionSet(RuleProxy<RailwayMcoProductPropertySet, RailwayMcoProductCommissionActionSet> proxy, RailwayMcoProduct item) {
            proxy.getAppliedRuleCategories().clear();
            proxy.getAppliedRules().clear();
            proxy.getTracer().clear();
            proxy.setActionSet((Object)new RailwayMcoProductCommissionActionSet(proxy, (RailwayProductPropertiesProvider)proxy.getPropertySet(), item));
        }

        public RuleProxy<RailwayMcoProductPropertySet, RailwayMcoProductCommissionActionSet> createProxy(RailwayMcoProduct item, boolean enabledTracer) throws Exception {
            RuleProxy proxy = new RuleProxy();
            RailwayMcoProductPropertySet props = new RailwayMcoProductPropertySet(proxy);
            proxy.getTracer().setDisabled(!enabledTracer);
            proxy.setPropertySet((Object)props);
            proxy.setProxyDate(item.getIssueDate());
            proxy.setProxyType(Targets.RAILWAY_PRODUCT_COMMISSION.getId());
            ((RailwayMcoProductPropertySet)proxy.getPropertySet()).init(item);
            return proxy;
        }

        public EntityReference<Organization> getBlankOwner(RailwayMcoProduct item) {
            return item.getBlankOwnerRef();
        }

        public Date getIssueDate(RailwayMcoProduct item) {
            return item.getIssueDate();
        }

        public boolean hasRefundCommissions(RuleProxy<RailwayMcoProductPropertySet, RailwayMcoProductCommissionActionSet> proxy) {
            return ((RailwayMcoProductCommissionActionSet)((Object)proxy.getActionSet())).hasRefundCommissions();
        }

        public Class<RailwayMcoProduct> getProductClass() {
            return RailwayMcoProduct.class;
        }

        public ProductStatus getStatus(RailwayMcoProduct item) {
            return item.getStatus();
        }

        public TicketType getTicketType(RailwayMcoProduct item) {
            return item.getTicketType();
        }

        public List<ValidationMessage> getValidationMessages(RailwayMcoProduct item) {
            return item.getValidationMessages();
        }

        public boolean isChecked(RailwayMcoProduct item) {
            return item.isChecked();
        }

        public boolean isContractRulesApplied(RailwayMcoProduct item) {
            return item.isContractRulesApplied();
        }

        public void setContractRulesApplied(RailwayMcoProduct item, boolean value) {
            item.setContractRulesApplied(value);
        }

        public void updateContractRelationsBySalesChain(RailwayMcoProduct item) {
        }

        public List<GeneralProductContractRelationData> getContractRelations(RailwayMcoProduct item) {
            List<GeneralProductContractRelationData> relations = this.getUnmodifiableContractRelations(item);
            this.relationsMap.put(item, relations);
            return relations;
        }

        public List<GeneralProductContractRelationData> getPreviousProductContractRelations(RailwayMcoProduct item) {
            return item.getPreviousProduct() == null ? null : this.getUnmodifiableContractRelations(item.getPreviousProduct());
        }

        public List<GeneralProductCommission> createCommissions(RuleProxy<RailwayMcoProductPropertySet, RailwayMcoProductCommissionActionSet> proxy, RailwayMcoProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
            return ((RailwayMcoProductCommissionActionSet)((Object)proxy.getActionSet())).createCommissions(relation, allRelations, previousProductContractRelations, separateSupplierFees, rateData, new ArrayList());
        }

        public List<GeneralProductCommission> createCommissions(RuleProxy<RailwayMcoProductPropertySet, RailwayMcoProductCommissionActionSet> proxy, RailwayMcoProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
            return ((RailwayMcoProductCommissionActionSet)((Object)proxy.getActionSet())).createCommissions(relation, allRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData, new ArrayList());
        }

        public void afterCommissionCalculated(RailwayMcoProduct item) {
            for (GeneralProductContractRelationData relation : this.relationsMap.get(item)) {
                GeneralProductContractRelationData rel = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)RailwayMcoProductHelper.getContractRelations((RailwayMcoProduct)item), (EntityReference)relation.getDescription());
                rel.getCommissions().clear();
                rel.getCommissions().addAll(relation.getCommissions());
                try {
                    XCloneModelHelper.copy((BaseEntity)relation.getGeneralData(), (BaseEntity)rel.getGeneralData(), (boolean)true);
                    XCloneModelHelper.copy((BaseEntity)relation.getServiceData(), (BaseEntity)rel.getServiceData(), (boolean)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GeneralProductRulesHelper.updateFromGeneralFops((GeneralProductContractRelationData)relation, (List)rel.getFops());
            }
            this.afterRulesAppliedConsumer.accept(item);
        }

        public Set<PaymentType> getAllowedPaymentTypes(RailwayMcoProductCommissionActionSet actionSet) {
            return actionSet.getAllowedPaymentTypes();
        }

        protected List<GeneralProductContractRelationData> getUnmodifiableContractRelations(RailwayMcoProduct item) {
            return this.productHandler.getUnmodifiableContractRelations((BaseProduct)item);
        }

        protected ProductHandler<RailwayMcoProduct> getProductHandler() {
            return HandlersRegistry.get().findProductHandler(RailwayMcoProduct.class);
        }
    }
}

