/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.handlers.rules;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.Parameter;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProductPropertiesProvider;
import com.gridnine.xtrip.common.railway.model.rules.standart.Targets;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.server.model.handlers.RulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayProductCommissionActionSet;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayProductPropertySet;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayRulesHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailwayRulesHandler
implements RulesHandler {
    public static final String ID = MiscUtil.getSimpleClassName(RailwayRulesHandler.class);

    public void applyRules(EntityContainer<BookingFile> bookingFileContainer, boolean forced, boolean simulate, List<Message> messages, Map<Parameter, Object> params, DebugInfo debugInfo, boolean calcAppliedRulesToBooking) throws Exception {
        RailwayRulesProductHandler rulesHandler = (RailwayRulesProductHandler)((Object)ReflectionUtil.createBySystemPropertyName((String)"com.gridnine.xtrip.server.railway.handlers.rules.RailwayRulesHandler.RailwayRulesProductHandler.className", (Logger)LoggerFactory.getLogger(this.getClass()), () -> new RailwayRulesProductHandler()));
        rulesHandler.setAfterRulesAppliedConsumer(this.afterRulesAppliedConsumer());
        GeneralProductRulesHelper.applyContracts(bookingFileContainer, (boolean)forced, (boolean)simulate, (RulesProductHandler)rulesHandler, messages, params, (boolean)calcAppliedRulesToBooking);
    }

    public String getId() {
        return ID;
    }

    protected Consumer<RailwayProduct> afterRulesAppliedConsumer() {
        return railwayProduct -> {};
    }

    public static class RailwayRulesProductHandler
    extends RulesProductHandler<RailwayProduct, RailwayProductPropertySet, RailwayProductCommissionActionSet> {
        private final ProductHandler<RailwayProduct> productHandler = this.getProductHandler();
        private final Map<RailwayProduct, List<GeneralProductContractRelationData>> relationsMap = new HashMap<RailwayProduct, List<GeneralProductContractRelationData>>();
        private Consumer<RailwayProduct> afterRulesAppliedConsumer;

        public void setAfterRulesAppliedConsumer(Consumer<RailwayProduct> afterRulesAppliedConsumer) {
            this.afterRulesAppliedConsumer = afterRulesAppliedConsumer;
        }

        public void clearActionSet(RuleProxy<RailwayProductPropertySet, RailwayProductCommissionActionSet> proxy, RailwayProduct item) {
            proxy.getAppliedRuleCategories().clear();
            proxy.getAppliedRules().clear();
            proxy.getTracer().clear();
            proxy.setActionSet((Object)new RailwayProductCommissionActionSet(proxy, (RailwayProductPropertiesProvider)proxy.getPropertySet(), item));
        }

        public RuleProxy<RailwayProductPropertySet, RailwayProductCommissionActionSet> createProxy(RailwayProduct item, boolean enabledTracer) throws Exception {
            RuleProxy proxy = new RuleProxy();
            RailwayProductPropertySet props = new RailwayProductPropertySet(proxy);
            proxy.getTracer().setDisabled(!enabledTracer);
            proxy.setPropertySet((Object)props);
            proxy.setProxyDate(item.getIssueDate());
            proxy.setProxyType(Targets.RAILWAY_PRODUCT_COMMISSION.getId());
            ((RailwayProductPropertySet)proxy.getPropertySet()).init(item);
            return proxy;
        }

        public EntityReference<Organization> getBlankOwner(RailwayProduct item) {
            return item.getBlankOwnerRef();
        }

        public Date getIssueDate(RailwayProduct item) {
            return item.getIssueDate();
        }

        public boolean hasRefundCommissions(RuleProxy<RailwayProductPropertySet, RailwayProductCommissionActionSet> proxy) {
            return ((RailwayProductCommissionActionSet)((Object)proxy.getActionSet())).hasRefundCommissions();
        }

        public Class<RailwayProduct> getProductClass() {
            return RailwayProduct.class;
        }

        public ProductStatus getStatus(RailwayProduct item) {
            return item.getStatus();
        }

        public TicketType getTicketType(RailwayProduct item) {
            return item.getTicketType();
        }

        public List<ValidationMessage> getValidationMessages(RailwayProduct item) {
            return item.getValidationMessages();
        }

        public boolean isChecked(RailwayProduct item) {
            return item.isChecked();
        }

        public boolean isContractRulesApplied(RailwayProduct item) {
            return item.isContractRulesApplied();
        }

        public void setContractRulesApplied(RailwayProduct item, boolean value) {
            item.setContractRulesApplied(value);
        }

        public void updateContractRelationsBySalesChain(RailwayProduct item) {
        }

        public List<GeneralProductContractRelationData> getContractRelations(RailwayProduct item) {
            List<GeneralProductContractRelationData> relations = this.getUnmodifiableContractRelations(item);
            this.relationsMap.put(item, relations);
            return relations;
        }

        public List<GeneralProductContractRelationData> getPreviousProductContractRelations(RailwayProduct item) {
            return item.getPreviousProduct() == null ? null : this.getUnmodifiableContractRelations(item.getPreviousProduct());
        }

        public List<GeneralProductCommission> createCommissions(RuleProxy<RailwayProductPropertySet, RailwayProductCommissionActionSet> proxy, RailwayProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
            return ((RailwayProductCommissionActionSet)((Object)proxy.getActionSet())).createCommissions(relation, allRelations, previousProductContractRelations, separateSupplierFees, rateData, new ArrayList());
        }

        public List<GeneralProductCommission> createCommissions(RuleProxy<RailwayProductPropertySet, RailwayProductCommissionActionSet> proxy, RailwayProduct item, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> allRelations, List<GeneralProductContractRelationData> previousProductContractRelations, boolean translateSupplierFees, boolean separateSupplierFees, ExchangeRateData rateData) throws Exception {
            return ((RailwayProductCommissionActionSet)((Object)proxy.getActionSet())).createCommissions(relation, allRelations, previousProductContractRelations, translateSupplierFees, separateSupplierFees, rateData, new ArrayList());
        }

        public void afterCommissionCalculated(RailwayProduct item) {
            for (GeneralProductContractRelationData relation : this.relationsMap.get(item)) {
                RailwayProductContractRelationData rel = RailwayProductHelper.findContractRelation((List)RailwayProductHelper.getContractRelations((RailwayProduct)item), (EntityReference)relation.getDescription());
                rel.getCommissions().clear();
                rel.getCommissions().addAll(relation.getCommissions());
                try {
                    XCloneModelHelper.copy((BaseEntity)relation.getGeneralData(), (BaseEntity)rel.getGeneralData(), (boolean)true);
                    XCloneModelHelper.copy((BaseEntity)relation.getServiceData(), (BaseEntity)rel.getServiceData(), (boolean)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RailwayRulesHelper.fromGeneralFops(relation, rel.getFops());
            }
            this.afterRulesAppliedConsumer.accept(item);
        }

        public Set<PaymentType> getAllowedPaymentTypes(RailwayProductCommissionActionSet actionSet) {
            return actionSet.getAllowedPaymentTypes();
        }

        protected List<GeneralProductContractRelationData> getUnmodifiableContractRelations(RailwayProduct item) {
            return this.productHandler.getUnmodifiableContractRelations((BaseProduct)item);
        }

        protected ProductHandler<RailwayProduct> getProductHandler() {
            return HandlersRegistry.get().findProductHandler(RailwayProduct.class);
        }
    }
}

