/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.handlers.stockcontrol;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class RailwayProductStockControlHandler
implements StockControlProductHandler<RailwayProduct, RailwayProductIndex, RailwayProductFop> {
    public Class<RailwayProduct> getProductClass() {
        return RailwayProduct.class;
    }

    public List<ValidationMessage> getValidationMessages(RailwayProduct product) {
        return product.getValidationMessages();
    }

    public List<String> getSCNs(RailwayProduct product) {
        return TextUtil.isBlank((String)product.getScn()) ? new ArrayList() : Collections.singletonList(product.getScn());
    }

    public ProductStatus getStatus(RailwayProduct product) {
        return product.getStatus();
    }

    public RailwayProduct getPreviousProduct(RailwayProduct product) {
        return product.getPreviousProduct();
    }

    public RailwayProduct getNextProduct(RailwayProduct product) {
        return product.getNextProduct();
    }

    public TicketType getTicketType(RailwayProduct product) {
        return product.getTicketType();
    }

    public Class<RailwayProductIndex> getProductIndexClass() {
        return RailwayProductIndex.class;
    }

    public String getStatusIndexPropertyName() {
        return RailwayProductIndex.Property.status.name();
    }

    public String getSCNIndexPropertyName() {
        return RailwayProductIndex.Property.sncs.name();
    }

    public String getTicketTypeIndexPropertyName() {
        return RailwayProductIndex.Property.ticketType.name();
    }

    public EntityReference<Organization> getBlankOwner(RailwayProduct product) {
        return product.getBlankOwnerRef();
    }

    public EntityReference<Organization> getSubagency(RailwayProduct product) {
        return RailwayProductHelper.getSubagency((RailwayProduct)product);
    }

    public EntityReference<Person> getAgent(RailwayProduct product) {
        return product.getCashier();
    }

    public String getPCC(RailwayProduct product) {
        return product.getPcc();
    }

    public String getValidator(RailwayProduct product) {
        return product.getValidatorCode();
    }

    public String getSystemNumber(RailwayProduct product) {
        return product.getSystemNumber();
    }

    public TariffType getTariffType(RailwayProduct product) {
        return TariffType.REGULAR;
    }

    public List<RailwayProductFop> getVendorFops(RailwayProduct product) {
        return RailwayProductHelper.getVendorFops((RailwayProduct)product);
    }

    public Date getOperationDate(RailwayProductFop fop) {
        return fop.getOperationDate();
    }

    public Date getIssueDate(RailwayProduct product) {
        return product.getIssueDate();
    }

    public int getConjCount(RailwayProduct product) {
        return 0;
    }

    public Traveller getTraveller(RailwayProduct product) {
        return !product.getPassengers().isEmpty() ? (Traveller)product.getPassengers().get(0) : null;
    }

    public ProductSearchResult findProductByScnAndDate(String scn, Date issueDate, long threshold, ProductStatus status) throws Exception {
        List data;
        SearchQuery query = new SearchQuery();
        if (status != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)status));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), null)}));
        if (!TextUtil.isBlank((String)scn)) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)RailwayProductIndex.Property.sncs.name(), (Object)scn));
        }
        if (issueDate != null) {
            Date lowerLim = new Date(issueDate.getTime() - threshold);
            Date upperLim = new Date(issueDate.getTime() + threshold);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)RailwayProductIndex.Property.issueDate.name(), (Object)lowerLim));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)RailwayProductIndex.Property.issueDate.name(), (Object)upperLim));
        }
        if ((data = EntityStorage.get().search(RailwayProductIndex.class, query).getData()).isEmpty()) {
            return null;
        }
        RailwayProductIndex idx = (RailwayProductIndex)data.get(0);
        EntityContainer bfCtr = EntityStorage.get().resolve(idx.getSource());
        BookingFile booking = (BookingFile)bfCtr.getEntity();
        BaseProduct bp = BookingHelper.findProduct((BookingFile)booking, (String)idx.getNavigationKey());
        return new ProductSearchResult(booking, bp, bp.getReservation(), bfCtr, data.size() == 1);
    }

    public int getEticketCount(EntityReference<Organization> blankOwner, EntityReference<Organization> agency, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType, boolean countVoid) throws Exception {
        SearchQuery query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), null), SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.OWN)}));
        if (countVoid) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.VOID)}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
        }
        if (blankOwner != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.blankOwner.name(), blankOwner));
        }
        if (agency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.agency.name(), agency));
        }
        if (subagency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.subagency.name(), subagency));
        }
        if (salesPoint != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.salesPoint.name(), salesPoint));
        }
        if (gdsNames != null) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (GdsName gdsName : gdsNames) {
                criterions.add(SearchCriterion.contains((String)RailwayProductIndex.Property.gdsNames.name(), (Object)gdsName));
                criterions.add(SearchCriterion.eq((String)RailwayProductIndex.Property.gdsName.name(), (Object)gdsName));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        }
        if (blankType != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.blankType.name(), blankType));
        }
        return EntityStorage.get().search(RailwayProductIndex.class, query).getTotalCount();
    }

    public EntityReference<SalesPoint> getSalesPoint(RailwayProduct product) {
        return product.getSalesPoint();
    }

    public String getIssueDateIndexPropertyName() {
        return RailwayProductIndex.Property.issueDate.name();
    }

    public List<SearchCriterion> getProductIndexAdditionalCriterions(RailwayProduct product) {
        return Collections.emptyList();
    }
}

