/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.handlers.stockcontrol;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class RailwayReferenceMCOStockControlHandler
implements StockControlProductHandler<RailwayReferenceMCO, RailwayProductIndex, GeneralProductFop> {
    public Class<RailwayReferenceMCO> getProductClass() {
        return RailwayReferenceMCO.class;
    }

    public List<ValidationMessage> getValidationMessages(RailwayReferenceMCO product) {
        return product.getValidationMessages();
    }

    public List<String> getSCNs(RailwayReferenceMCO product) {
        return TextUtil.isBlank((String)product.getScn()) ? new ArrayList() : Collections.singletonList(product.getScn());
    }

    public ProductStatus getStatus(RailwayReferenceMCO product) {
        return ProductStatus.SELL;
    }

    public RailwayReferenceMCO getPreviousProduct(RailwayReferenceMCO product) {
        return null;
    }

    public RailwayReferenceMCO getNextProduct(RailwayReferenceMCO product) {
        return null;
    }

    public TicketType getTicketType(RailwayReferenceMCO product) {
        return product.getTicketType();
    }

    public Class<RailwayProductIndex> getProductIndexClass() {
        return RailwayProductIndex.class;
    }

    public String getStatusIndexPropertyName() {
        return RailwayProductIndex.Property.status.name();
    }

    public String getSCNIndexPropertyName() {
        return RailwayProductIndex.Property.sncs.name();
    }

    public String getTicketTypeIndexPropertyName() {
        return RailwayProductIndex.Property.ticketType.name();
    }

    public EntityReference<Organization> getBlankOwner(RailwayReferenceMCO product) {
        ProductHandler handler = product.getRelatedProduct() != null ? GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct()) : null;
        return handler != null ? handler.getBlankOwner(product.getRelatedProduct()) : null;
    }

    public EntityReference<Organization> getSubagency(RailwayReferenceMCO product) {
        return product.getRelatedProduct() != null ? GeneralProductHelper.getSubagency((BaseProduct)product.getRelatedProduct()) : null;
    }

    public EntityReference<Person> getAgent(RailwayReferenceMCO product) {
        ProductHandler handler = product.getRelatedProduct() != null ? GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct()) : null;
        return handler != null ? handler.findIssuingAgent(product.getRelatedProduct()) : null;
    }

    public String getPCC(RailwayReferenceMCO product) {
        return null;
    }

    public String getValidator(RailwayReferenceMCO product) {
        return null;
    }

    public String getSystemNumber(RailwayReferenceMCO product) {
        return product.getSystemNumber();
    }

    public TariffType getTariffType(RailwayReferenceMCO product) {
        return TariffType.REGULAR;
    }

    public List<GeneralProductFop> getVendorFops(RailwayReferenceMCO product) {
        return Collections.emptyList();
    }

    public Date getOperationDate(GeneralProductFop fop) {
        return fop.getOperationDate();
    }

    public Date getIssueDate(RailwayReferenceMCO product) {
        return product.getIssueDate();
    }

    public int getConjCount(RailwayReferenceMCO product) {
        return 0;
    }

    public Traveller getTraveller(RailwayReferenceMCO product) {
        ProductHandler handler = product.getRelatedProduct() != null ? GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct()) : null;
        List travellers = handler != null ? handler.getTravellers(product.getRelatedProduct()) : Collections.emptyList();
        return travellers.size() < 0 ? (Traveller)travellers.iterator().next() : null;
    }

    public ProductSearchResult findProductByScnAndDate(String scn, Date issueDate, long threshold, ProductStatus status) throws Exception {
        List data;
        SearchQuery query = new SearchQuery();
        if (status != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)status));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)RailwayProductIndex.Property.ticketType.name(), null)}));
        if (!TextUtil.isBlank((String)scn)) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)RailwayProductIndex.Property.sncs.name(), (Object)scn));
        }
        if (issueDate != null) {
            Date lowerLim = new Date(issueDate.getTime() - threshold);
            Date upperLim = new Date(issueDate.getTime() + threshold);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)RailwayProductIndex.Property.issueDate.name(), (Object)lowerLim));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)RailwayProductIndex.Property.issueDate.name(), (Object)upperLim));
        }
        if ((data = EntityStorage.get().search(RailwayProductIndex.class, query).getData()).isEmpty()) {
            return null;
        }
        RailwayProductIndex idx = (RailwayProductIndex)data.get(0);
        EntityContainer bfCtr = EntityStorage.get().resolve(idx.getSource());
        BookingFile booking = (BookingFile)bfCtr.getEntity();
        BaseProduct bp = BookingHelper.findProduct((BookingFile)booking, (String)idx.getNavigationKey());
        return new ProductSearchResult(booking, bp, bp.getReservation(), bfCtr, data.size() == 1);
    }

    public int getEticketCount(EntityReference<Organization> blankOwner, EntityReference<Organization> agency, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType, boolean countVoid) throws Exception {
        return 0;
    }

    public EntityReference<SalesPoint> getSalesPoint(RailwayReferenceMCO product) {
        return null;
    }

    public String getIssueDateIndexPropertyName() {
        return RailwayProductIndex.Property.issueDate.name();
    }

    public List<SearchCriterion> getProductIndexAdditionalCriterions(RailwayReferenceMCO product) {
        return Collections.emptyList();
    }
}

