/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.handlers.validation;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ValidatorHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.railway.model.validation.RailwayValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class BaseRailwayProductValidationHandler<P extends BaseProduct>
implements ProductValidationHandler<P> {
    public void validate(P product, ProductValidationContext ctx) throws Exception {
        List validatorIndexes;
        ProductHandler ph = ProductHandler.of(product);
        List messages = ph.getValidationMessages(product);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (ph.getTicketType(product) == TicketType.FAKE) {
            return;
        }
        GeneralProductValidationHelper.getAllValidationMessages(product, (GeneralProductValidationHelper.ProductIndexProvider)new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, RailwayProductIndex>(){

            public Class<RailwayProductIndex> getIndexClass() {
                return RailwayProductIndex.class;
            }

            public String getSystemNumberIndexPropertyName() {
                return RailwayProductIndex.Property.systemNumber.name();
            }

            public String getStatusIndexPropertyName() {
                return RailwayProductIndex.Property.status.name();
            }

            public String getProductTypeIndexPropertyName() {
                return RailwayProductIndex.Property.ticketType.name();
            }

            public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                return Collections.emptyList();
            }

            public boolean hasEquivalentFare() {
                return true;
            }

            public boolean hasTicketType() {
                return true;
            }

            public boolean hasBlankOwner() {
                return true;
            }

            public boolean hasSubagency() {
                return true;
            }
        }, (List)messages, (ProductValidationContext)ctx);
        ProductStatus productStatus = ph.getStatus(product);
        if (ProductStatusHandler.getAllVoidStatuses().contains(productStatus)) {
            return;
        }
        if (productStatus == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)RailwayValidationMessageType.RPI_PRODUCT_STATUS_UNDEFINED));
        }
        DictionaryReference blankTypeReference = ph.getBlankType(product);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(productStatus)) {
            if (blankTypeReference == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)RailwayValidationMessageType.RPI_BLANK_IS_EMPTY));
            } else {
                BlankType type = (BlankType)DictionaryCache.get().resolveReference(blankTypeReference);
                if (type == null) {
                    messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)RailwayValidationMessageType.RPI_BLANK_TYPE_HAS_WRONG_VALUE));
                }
            }
        }
        EntityReference<Organization> blankOwner = this.getBlankOwner(product);
        String validatorCode = ph.getValidatorNumber(product);
        Date issueDate = ph.findIssueDate(product);
        String pcc = ph.getPCC(product);
        if (!TextUtil.isBlank((String)validatorCode) && (validatorIndexes = ValidatorHelper.getValidatorIndexes((String)validatorCode, blankOwner, (String)pcc, (Date)issueDate)).size() != 0) {
            EntityReference validatorSalesPoint;
            EntityReference productSalesPoint;
            EntityReference validatorSubagency;
            EntityReference productSubagency;
            EntityReference validatorAgency;
            if (validatorIndexes.size() > 1) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)RailwayValidationMessageType.RPI_MORE_THAN_ONE_VALIDATOR, (Object[])new Object[]{validatorCode}));
            }
            ValidatorIndex validatorIndex = (ValidatorIndex)validatorIndexes.get(0);
            EntityReference productAgency = GeneralProductHelper.getAgency(product);
            if (!MiscUtil.equals((Object)productAgency, (Object)(validatorAgency = validatorIndex.getAgency()))) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)RailwayValidationMessageType.RPI_AGENCY_DOESNT_MATCH_VALIDATOR_CODE, (Object[])new Object[]{productAgency, validatorCode}));
            }
            if (!MiscUtil.equals((Object)(productSubagency = GeneralProductHelper.getSubagency(product)), (Object)(validatorSubagency = validatorIndex.getSubagency()))) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)RailwayValidationMessageType.RPI_SUBAGENCY_DOESNT_MATCH_VALIDATOR_CODE, (Object[])new Object[]{productSubagency, validatorCode}));
            }
            if (!MiscUtil.equals((Object)(productSalesPoint = ph.findSalesPoint(product)), (Object)(validatorSalesPoint = validatorIndex.getSource()))) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)RailwayValidationMessageType.RPI_SALES_POINT_DOESNT_MATCH_VALIDATOR_CODE, (Object[])new Object[]{productSalesPoint, validatorCode}));
            }
        }
        for (RailwaySegment segment : this.getRailwaySegments(product)) {
            DictionaryReference carrierRef = segment.getCarrier();
            if (carrierRef == null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)RailwayValidationMessageType.RPI_CARRIER_IN_SEGMENT_IS_EMPTY, (Object[])new Object[]{segment.getNumber()}));
                continue;
            }
            RailwayCarrier carrier = (RailwayCarrier)DictionaryCache.get().resolveReference(carrierRef);
            if (carrier != null) continue;
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)RailwayValidationMessageType.RPI_CARRIER_IN_SEGMENT_HAS_WRONG_VALUE, (Object[])new Object[]{segment.getNumber()}));
        }
    }

    protected EntityReference<Organization> getBlankOwner(P product) {
        return ProductHandler.of(product).getBlankOwner(product);
    }

    protected List<RailwaySegment> getRailwaySegments(P product) {
        return Collections.emptyList();
    }
}

