/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.midoffice;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.railway.model.RailwayAncillaryFee;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DecomposeRailwayReservationAncillaryFeesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation;
        Map reservationFees = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_ANCILLARY_FEES);
        List ancillaryFees = (List)reservationFees.get(reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION));
        if (ancillaryFees == null || ancillaryFees.isEmpty()) {
            return;
        }
        List railAncillaryFees = ancillaryFees.stream().filter(RailwayAncillaryFee.class::isInstance).map(RailwayAncillaryFee.class::cast).collect(Collectors.toList());
        HashMap productFees = new HashMap();
        for (RailwayAncillaryFee fee : railAncillaryFees) {
            RailwayProduct product = (RailwayProduct)Objects.requireNonNull(BookingHelper.findProduct((Reservation)reservation, (String)fee.getProductUid()));
            List mcoProducts = RailwayProductHelper.getMcoByRelatedProduct((RailwayProduct)product);
            int exists = (int)mcoProducts.stream().filter(mco -> mco.getStatus() == ProductStatus.BOOKING).filter(mco -> MiscUtil.equals((Object)mco.getMcoCategory(), (Object)fee.getMcoCategory())).count();
            fee.setQuantity(Integer.valueOf(exists));
            Collection fees = CollectionUtil.getFromMap(productFees, (Object)product, ArrayList::new);
            fees.add(fee);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.PRODUCT_ANCILLARY_FEES, productFees);
    }
}

