/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.common;

import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.railway.model.helpers.CommonRailwayHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Set;

public final class CommonRailwayParsersHelper {
    public static final String BLANK_OWNER_CODE = "\u0420\u0416\u0414";

    public static String getBlankOwnerCode(GdsName gds) {
        return (String)MiscUtil.guarded((Object)CommonRailwayHelper.getBlankOwnerCode((GdsName)gds), (Object)BLANK_OWNER_CODE);
    }

    public static DictionaryReference<Principal> getCarrier(String registrationId, MessageContext ctx) {
        if (TextUtil.isBlank((String)registrationId)) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0418\u041d\u041d \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430", (Object[])new Object[0]));
            return null;
        }
        Set principals = DictionaryCache.get().search(Principal.class, DictSearchCriterion.eq((String)Principal.Property.registrationId.name(), (Object)registrationId));
        if (principals.isEmpty()) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043f\u043e \u0418\u041d\u041d {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430", (Object[])new Object[]{registrationId}));
            return null;
        }
        Principal principal = (Principal)principals.iterator().next();
        if (principals.size() > 1) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043f\u043e \u0418\u041d\u041d {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u043e\u0432, \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d {1}", (Object[])new Object[]{registrationId, principal.toReference()}));
            return null;
        }
        return principal.toReference();
    }

    public static boolean isVatApplicable(String vatRateType) {
        if (vatRateType != null) {
            switch (vatRateType) {
                case "BaseRateInPercents": 
                case "ReducedRateInPercents": 
                case "BaseRate": 
                case "ReducedRate": 
                case "ExportRateInPercents": {
                    return true;
                }
                case "NotSubjectToVatByLaw": 
                case "NonTaxable": {
                    return false;
                }
            }
        }
        return true;
    }

    private CommonRailwayParsersHelper() {
    }
}

