/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.express;

import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.railway.parsers.ExpressExchangeDocument;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.ibus.parsers.express.ExpressData;
import java.util.Collection;
import java.util.List;

public class ExpressCreateExchangeDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        ExchangeFile file = (ExchangeFile)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
        String checkSum = (String)context.getMandatoryObject((Enum)IBusParsersContextKeys.CHECK_SUM);
        List exchangeDocumentsList = (List)context.getMandatoryObject((Enum)IBusParsersContextKeys.REGISTRING_DOCUMENTS_LIST);
        ExpressData data = (ExpressData)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        String agentCode = (String)context.getObject((Enum)IBusParsersContextKeys.AGENT_CODE);
        ExpressExchangeDocument exchangeDocument = new ExpressExchangeDocument();
        exchangeDocument.setContentType(ContentType.TEXT);
        exchangeDocument.setContent(data.getContent().getBytes("utf-8"));
        exchangeDocument.setCreated(file.getCreated());
        exchangeDocument.setLocation(file.getLocation());
        exchangeDocument.setType(file.getType());
        exchangeDocument.setCheckSum(checkSum);
        exchangeDocument.setSystemNumber(data.getSystemNumber());
        exchangeDocument.setIssueDate(data.getIssueDate());
        exchangeDocument.setTransactionType(data.getTransactionType());
        exchangeDocument.setCashierCode(agentCode);
        exchangeDocument.getTravellers().clear();
        for (Traveller traveller : data.getTravellers()) {
            exchangeDocument.getTravellers().add(traveller.getName());
        }
        exchangeDocument.getMessages().clear();
        exchangeDocument.getMessages().addAll(context.getMessagesReadOnly());
        if (MessageHelper.hasMessages((Collection)exchangeDocument.getMessages(), (MessageType)MessageType.ERROR)) {
            exchangeDocument.setStatus(ProcessingStatus.ERROR);
        } else {
            exchangeDocument.setStatus(ProcessingStatus.UNPROCESSED);
        }
        exchangeDocumentsList.add(exchangeDocument);
    }
}

