/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.express;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.common.CommonRailwayParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.express.ExpressHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.express.ExpressRailwayProductData;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum ExpressEntryHandlers implements ExpressHelper.EntryHandler<ExpressRailwayProductData>
{
    SELL{

        @Override
        public ProductStatus getProductStatus() {
            return ProductStatus.SELL;
        }

        @Override
        public void parse(ExpressRailwayProductData data, String content, String agentCode, Map<ExpressHelper.RecordType, ExpressHelper.RecordHandler<ExpressRailwayProductData>> handlers, List<Message> messages, boolean registration) {
            data.setContent(content);
            for (MiscUtil.Pair record : ExpressHelper.getRecords(content, handlers).stream().sorted((o1, o2) -> Double.compare(((ExpressHelper.RecordHandler)handlers.get(o1.getFirst())).getPriority(), ((ExpressHelper.RecordHandler)handlers.get(o2.getFirst())).getPriority())).collect(Collectors.toList())) {
                handlers.get(record.getFirst()).parse(data, (String)record.getSecond(), agentCode, messages, registration);
            }
            GdsName gds = GdsName.EXPRESS;
            RecordLocatorType type = RecordLocatorType.DEFAULT;
            TicketType ticketType = TicketType.OWN;
            ParsersHelper.SalesContextData salesContextData = ParsersHelper.getSalesContextData((String)CommonRailwayParsersHelper.getBlankOwnerCode(gds), null, null, (String)agentCode, null, (String)data.getPcc(), (GdsName)gds, (Date)data.getIssueDate(), messages);
            EntityReference blankOwner = salesContextData.getBlankOwner();
            EntityReference supplier = salesContextData.getSupplier();
            EntityReference agency = salesContextData.getAgency();
            EntityReference subagency = salesContextData.getSubagency();
            EntityReference salesPoint = salesContextData.getSalesPoint();
            EntityReference agent = salesContextData.getAgent();
            String validatorCode = salesContextData.getValidatorCode();
            NestedEntityReference validator = salesContextData.getValidator();
            String pccCode = salesContextData.getPccCode();
            DictionaryReference blankType = ParsersHelper.getBlankType((String)"\u0420\u0416\u0414 \u0421\u043b\u0438\u043f");
            if (data.getSegments().size() > 0) {
                data.getSegments().get(0).setNumber(1);
                if (data.getReservedSeats().size() > 0) {
                    data.getReservedSeats().get(0).setSegment(data.getSegments().get(0));
                }
                if (data.getTaxes().size() > 0) {
                    data.getTaxes().get(0).setSegment(data.getSegments().get(0));
                }
            }
            data.setTransactionType(TransactionType.SELL);
            data.setStatus(ProductStatus.SELL);
            data.setGds(gds);
            data.setRecordLocatorType(type);
            data.setTicketType(ticketType);
            data.setBlankOwner((EntityReference<Organization>)blankOwner);
            data.setSupplier((EntityReference<Organization>)supplier);
            data.setAgency((EntityReference<Organization>)agency);
            data.setSubagency((EntityReference<Organization>)subagency);
            data.setSalesPoint((EntityReference<SalesPoint>)salesPoint);
            data.setAgent((EntityReference<Person>)agent);
            data.setValidatorCode(validatorCode);
            data.setValidator((NestedEntityReference<SalesPoint, Validator>)validator);
            data.setPcc(pccCode);
            data.setBlankType((DictionaryReference<BlankType>)blankType);
        }
    }
    ,
    REFUND{

        @Override
        public ProductStatus getProductStatus() {
            return ProductStatus.REFUND;
        }

        @Override
        public void parse(ExpressRailwayProductData data, String content, String agentCode, Map<ExpressHelper.RecordType, ExpressHelper.RecordHandler<ExpressRailwayProductData>> handlers, List<Message> messages, boolean registration) {
            data.setContent(content);
            for (MiscUtil.Pair record : ExpressHelper.getRecords(content, handlers).stream().sorted((o1, o2) -> Double.compare(((ExpressHelper.RecordHandler)handlers.get(o1.getFirst())).getPriority(), ((ExpressHelper.RecordHandler)handlers.get(o2.getFirst())).getPriority())).collect(Collectors.toList())) {
                handlers.get(record.getFirst()).parse(data, (String)record.getSecond(), agentCode, messages, registration);
            }
            GdsName gds = GdsName.EXPRESS;
            RecordLocatorType type = RecordLocatorType.DEFAULT;
            TicketType ticketType = TicketType.OWN;
            ParsersHelper.SalesContextData salesContextData = ParsersHelper.getSalesContextData((String)CommonRailwayParsersHelper.getBlankOwnerCode(gds), null, null, (String)agentCode, null, (String)data.getPcc(), (GdsName)gds, (Date)data.getIssueDate(), messages);
            EntityReference blankOwner = salesContextData.getBlankOwner();
            EntityReference supplier = salesContextData.getSupplier();
            EntityReference agency = salesContextData.getAgency();
            EntityReference subagency = salesContextData.getSubagency();
            EntityReference salesPoint = salesContextData.getSalesPoint();
            EntityReference agent = salesContextData.getAgent();
            String validatorCode = salesContextData.getValidatorCode();
            NestedEntityReference validator = salesContextData.getValidator();
            String pccCode = salesContextData.getPccCode();
            DictionaryReference blankType = ParsersHelper.getBlankType((String)"\u0420\u0416\u0414 \u0421\u043b\u0438\u043f");
            DictionaryReference mcoBlankType = ParsersHelper.getBlankType((String)"\u0420\u0416\u0414 \u041a\u0420\u0421");
            if (data.getSegments().size() > 0) {
                data.getSegments().get(0).setNumber(1);
                if (data.getReservedSeats().size() > 0) {
                    data.getReservedSeats().get(0).setSegment(data.getSegments().get(0));
                }
                if (data.getTaxes().size() > 0) {
                    data.getTaxes().get(0).setSegment(data.getSegments().get(0));
                }
            }
            data.setTransactionType(TransactionType.REFUND);
            data.setStatus(ProductStatus.REFUND);
            data.setGds(gds);
            data.setRecordLocatorType(type);
            data.setTicketType(ticketType);
            data.setBlankOwner((EntityReference<Organization>)blankOwner);
            data.setSupplier((EntityReference<Organization>)supplier);
            data.setAgency((EntityReference<Organization>)agency);
            data.setSubagency((EntityReference<Organization>)subagency);
            data.setSalesPoint((EntityReference<SalesPoint>)salesPoint);
            data.setAgent((EntityReference<Person>)agent);
            data.setValidatorCode(validatorCode);
            data.setValidator((NestedEntityReference<SalesPoint, Validator>)validator);
            data.setPcc(pccCode);
            data.setBlankType((DictionaryReference<BlankType>)blankType);
            data.setMcoBlankType((DictionaryReference<BlankType>)mcoBlankType);
        }
    }
    ,
    VOID{

        @Override
        public ProductStatus getProductStatus() {
            return ProductStatus.VOID;
        }

        @Override
        public void parse(ExpressRailwayProductData data, String content, String agentCode, Map<ExpressHelper.RecordType, ExpressHelper.RecordHandler<ExpressRailwayProductData>> handlers, List<Message> messages, boolean registration) {
            data.setContent(content);
            for (MiscUtil.Pair record : ExpressHelper.getRecords(content, handlers).stream().sorted((o1, o2) -> Double.compare(((ExpressHelper.RecordHandler)handlers.get(o1.getFirst())).getPriority(), ((ExpressHelper.RecordHandler)handlers.get(o2.getFirst())).getPriority())).collect(Collectors.toList())) {
                handlers.get(record.getFirst()).parse(data, (String)record.getSecond(), agentCode, messages, registration);
            }
            GdsName gds = GdsName.EXPRESS;
            RecordLocatorType type = RecordLocatorType.DEFAULT;
            TicketType ticketType = TicketType.OWN;
            ParsersHelper.SalesContextData salesContextData = ParsersHelper.getSalesContextData((String)CommonRailwayParsersHelper.getBlankOwnerCode(gds), null, null, (String)agentCode, null, (String)data.getPcc(), (GdsName)gds, (Date)data.getIssueDate(), messages);
            EntityReference blankOwner = salesContextData.getBlankOwner();
            EntityReference supplier = salesContextData.getSupplier();
            EntityReference agency = salesContextData.getAgency();
            EntityReference subagency = salesContextData.getSubagency();
            EntityReference salesPoint = salesContextData.getSalesPoint();
            EntityReference agent = salesContextData.getAgent();
            String validatorCode = salesContextData.getValidatorCode();
            NestedEntityReference validator = salesContextData.getValidator();
            String pccCode = salesContextData.getPccCode();
            DictionaryReference blankType = ParsersHelper.getBlankType((String)"\u0420\u0416\u0414 \u0421\u043b\u0438\u043f");
            if (data.getSegments().size() > 0) {
                data.getSegments().get(0).setNumber(1);
                if (data.getReservedSeats().size() > 0) {
                    data.getReservedSeats().get(0).setSegment(data.getSegments().get(0));
                }
                if (data.getTaxes().size() > 0) {
                    data.getTaxes().get(0).setSegment(data.getSegments().get(0));
                }
            }
            data.setTransactionType(TransactionType.CANCEL);
            data.setStatus(ProductStatus.VOID);
            data.setGds(gds);
            data.setRecordLocatorType(type);
            data.setTicketType(ticketType);
            data.setBlankOwner((EntityReference<Organization>)blankOwner);
            data.setSupplier((EntityReference<Organization>)supplier);
            data.setAgency((EntityReference<Organization>)agency);
            data.setSubagency((EntityReference<Organization>)subagency);
            data.setSalesPoint((EntityReference<SalesPoint>)salesPoint);
            data.setAgent((EntityReference<Person>)agent);
            data.setValidatorCode(validatorCode);
            data.setValidator((NestedEntityReference<SalesPoint, Validator>)validator);
            data.setPcc(pccCode);
            data.setBlankType((DictionaryReference<BlankType>)blankType);
        }
    };

}

