/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.express;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.railway.ibus.parsers.express.ExpressData;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ExpressHelper {
    public static final String SOURCE_ENCODING = "cp1251";
    public static final String STORE_ENCODING = "utf-8";
    public static final String TOKEN_SEPARATOR = "\n";
    public static final String BLANK_TYPE_CODE = "\u0420\u0416\u0414 \u0421\u043b\u0438\u043f";
    public static final String MCO_BLANK_TYPE_CODE = "\u0420\u0416\u0414 \u041a\u0420\u0421";
    public static final String INSURANCE_TAX_CODE = "\u0421\u0422\u0420";

    public static <D extends ExpressData> List<MiscUtil.Pair<RecordType, String>> getRecords(String content, Map<RecordType, RecordHandler<D>> handlers) {
        ArrayList<MiscUtil.Pair<RecordType, String>> records = new ArrayList<MiscUtil.Pair<RecordType, String>>();
        String[] tokens = content.split(TOKEN_SEPARATOR);
        RecordType lastType = null;
        StringBuilder lastRecord = null;
        boolean searchingRecordEnd = false;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            block1: for (Map.Entry<RecordType, RecordHandler<D>> entry : handlers.entrySet()) {
                RecordType type = entry.getKey();
                RecordHandler<D> handler = entry.getValue();
                for (String pattern : handler.getPatterns()) {
                    if (!Pattern.compile(pattern).matcher(token.trim()).find()) continue;
                    if (searchingRecordEnd) {
                        records.add((MiscUtil.Pair<RecordType, String>)new MiscUtil.Pair((Object)lastType, (Object)lastRecord.toString()));
                        searchingRecordEnd = false;
                    }
                    if (handler.isMultiline()) {
                        lastType = type;
                        lastRecord = new StringBuilder();
                        searchingRecordEnd = true;
                        break block1;
                    }
                    records.add((MiscUtil.Pair<RecordType, String>)new MiscUtil.Pair((Object)type, (Object)token));
                    break block1;
                }
            }
            if (!searchingRecordEnd) continue;
            lastRecord.append(token);
            if (i != tokens.length - 1) continue;
            records.add((MiscUtil.Pair<RecordType, String>)new MiscUtil.Pair(lastType, (Object)lastRecord.toString()));
        }
        return records;
    }

    public static CarriageType getCarriageType(String carriageTypeCode) {
        if (!TextUtil.isBlank((String)carriageTypeCode)) {
            if (carriageTypeCode.equals("\u041b")) {
                return CarriageType.L;
            }
            if (carriageTypeCode.equals("\u041c")) {
                return CarriageType.M;
            }
            if (carriageTypeCode.equals("\u041a")) {
                return CarriageType.K;
            }
            if (carriageTypeCode.equals("\u041f")) {
                return CarriageType.P;
            }
            if (carriageTypeCode.equals("\u0421")) {
                return CarriageType.S;
            }
            if (carriageTypeCode.equals("\u041e")) {
                return CarriageType.O;
            }
        }
        return null;
    }

    public static CompartmentType getCompartmentType(String compartmentTypeCode) {
        if (!TextUtil.isBlank((String)compartmentTypeCode)) {
            if (compartmentTypeCode.equals("\u041c\u0423\u0416\u0421\u041a\u041e\u0415")) {
                return CompartmentType.MEN;
            }
            if (compartmentTypeCode.equals("\u0416\u0415\u041d\u0421\u041a\u041e\u0415")) {
                return CompartmentType.WOMEN;
            }
        }
        return null;
    }

    public static ServiceClass getServiceClass(String serviceClassCode) {
        if (!TextUtil.isBlank((String)serviceClassCode)) {
            return RzdServiceConverter.getServiceClassByName(serviceClassCode);
        }
        return null;
    }

    public static PaymentType getPaymentType(String paymentTypeCode) {
        if (!TextUtil.isBlank((String)paymentTypeCode)) {
            if (paymentTypeCode.equals("\u041d")) {
                return PaymentType.CASH;
            }
            if (paymentTypeCode.equals("\u04121")) {
                return PaymentType.MTD;
            }
            if (paymentTypeCode.equals("\u04123")) {
                return PaymentType.MTD;
            }
            if (paymentTypeCode.equals("\u04125")) {
                return PaymentType.MTD;
            }
            if (paymentTypeCode.equals("\u04127")) {
                return PaymentType.MTD;
            }
            if (paymentTypeCode.equals("\u041213")) {
                return PaymentType.MTD;
            }
        }
        return null;
    }

    public static PassengerStatus getPassengerStatus(String paymentTypeCode) {
        if (!TextUtil.isBlank((String)paymentTypeCode)) {
            if (paymentTypeCode.equals("\u04121")) {
                return PassengerStatus.VS_MO;
            }
            if (paymentTypeCode.equals("\u04123")) {
                return PassengerStatus.VS_MVD;
            }
            if (paymentTypeCode.equals("\u04125")) {
                return PassengerStatus.VS_MO;
            }
            if (paymentTypeCode.equals("\u04127")) {
                return PassengerStatus.VS_FSB;
            }
            if (paymentTypeCode.equals("\u041213")) {
                return PassengerStatus.MCHS;
            }
        }
        return null;
    }

    public static PassportType getPassportType(String passportTypeCode) {
        if (!TextUtil.isBlank((String)passportTypeCode)) {
            if (passportTypeCode.equals("\u041f\u041d")) {
                return PassportType.INTERNAL;
            }
            if (passportTypeCode.equals("\u0417\u041f")) {
                return PassportType.FOREIGN;
            }
            if (passportTypeCode.equals("\u0421\u041f")) {
                return PassportType.SERVICE_PASSPORT;
            }
            if (passportTypeCode.equals("\u0414\u041f")) {
                return PassportType.DIPLOMATIC;
            }
            if (passportTypeCode.equals("\u041f\u0421")) {
                return PassportType.INTERNAL;
            }
            if (passportTypeCode.equals("\u0421\u0420")) {
                return PassportType.BIRTHDAY_NOTIFICATION;
            }
            if (passportTypeCode.equals("\u0412\u0411")) {
                return PassportType.MILITARYID;
            }
            if (passportTypeCode.equals("\u0423\u0412")) {
                return PassportType.MILITARYCERTIFICATE;
            }
            if (passportTypeCode.equals("\u0417\u0417")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u0411\u0413")) {
                return PassportType.IDENTITYCARD;
            }
            if (passportTypeCode.equals("\u0412\u0416")) {
                return PassportType.RESIDENCEPERMIT;
            }
            if (passportTypeCode.equals("\u0421\u0423")) {
                return PassportType.PASSPORTLOSSCERTIFICATE;
            }
            if (passportTypeCode.equals("\u0421\u0412")) {
                return PassportType.BACKTOUSSRCERTIFICATE;
            }
            if (passportTypeCode.equals("\u041f\u041c")) {
                return PassportType.SEAMANSID;
            }
            if (passportTypeCode.equals("\u0421\u041e")) {
                return PassportType.CERTIFICATEOFRELEASE;
            }
            if (passportTypeCode.equals("\u041f\u0411")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u0417\u041c")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u0423")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u041a")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u0422")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u0417")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u0423\u041b")) {
                return PassportType.IDENTITYCARD;
            }
            if (passportTypeCode.equals("\u0418\u0418")) {
                return PassportType.IDENTITYCARD;
            }
        }
        return null;
    }

    public static Gender getGender(String genderCode) {
        if (!TextUtil.isBlank((String)genderCode)) {
            if (genderCode.equals("\u041c")) {
                return Gender.MALE;
            }
            if (genderCode.equals("M")) {
                return Gender.MALE;
            }
            if (genderCode.equals("\u0416")) {
                return Gender.FEMALE;
            }
            if (genderCode.equals("F")) {
                return Gender.FEMALE;
            }
        }
        return null;
    }

    public static interface RecordHandler<D extends ExpressData> {
        public RecordType getRecordType();

        public boolean isMultiline();

        public double getPriority();

        public List<String> getPatterns();

        public void parse(D var1, String var2, String var3, List<Message> var4, boolean var5);
    }

    public static interface EntryHandler<D extends ExpressData> {
        public ProductStatus getProductStatus();

        public void parse(D var1, String var2, String var3, Map<RecordType, RecordHandler<D>> var4, List<Message> var5, boolean var6);
    }

    public static enum RecordType {
        TERMINAL,
        GENERAL,
        INN,
        SEGMENT,
        PLACE,
        PASSENGER,
        TARIFF,
        TARIFF_REFUND,
        TARIFF_VOID,
        TIME,
        TIME_REFUND,
        DEPARTURE,
        ARRIVE,
        ENDORSEMENT;

    }

    public static class TaxData {
        private String code;
        private BigDecimal amount;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }
    }

    public static class FopData {
        private PaymentType paymentType;
        private BigDecimal amount;
        private PassengerStatus passengerStatus;

        public PaymentType getPaymentType() {
            return this.paymentType;
        }

        public void setPaymentType(PaymentType paymentType) {
            this.paymentType = paymentType;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public PassengerStatus getPassengerStatus() {
            return this.passengerStatus;
        }

        public void setPassengerStatus(PassengerStatus passengerStatus) {
            this.passengerStatus = passengerStatus;
        }
    }
}

