/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.express;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.railway.ibus.parsers.express.ExpressData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ExpressRailwayProductData
extends ExpressData {
    private ProductStatus status;
    private EntityReference<Organization> client;
    private EntityReference<Organization> blankOwner;
    private EntityReference<Organization> supplier;
    private EntityReference<Organization> agency;
    private EntityReference<Organization> subagency;
    private EntityReference<SalesPoint> salesPoint;
    private EntityReference<Person> agent;
    private String mcoSystemNumber;
    private DictionaryReference<BlankType> blankType;
    private DictionaryReference<BlankType> mcoBlankType;
    private DictionaryReference<Principal> carrier;
    private TicketType ticketType;
    private GdsName gds;
    private RecordLocatorType recordLocatorType;
    private String pnr;
    private String pcc;
    private String validatorCode;
    private NestedEntityReference<SalesPoint, Validator> validator;
    private BigDecimal tariffAmount;
    private BigDecimal tariffVatAmount;
    private BigDecimal tariffVatRate;
    private BigDecimal serviceAmount;
    private BigDecimal serviceVatAmount;
    private BigDecimal serviceVatRate;
    private BigDecimal penaltyAmount;
    private BigDecimal penaltyVatAmount;
    private BigDecimal penaltyVatRate;
    private BigDecimal totalAmount;
    private BigDecimal totalVatAmount;
    private String endorsement;
    private VatDetalization vatDetalization;
    private final List<RailwaySegment> segments = new ArrayList<RailwaySegment>();
    private final List<ReservedSeat> reservedSeats = new ArrayList<ReservedSeat>();
    private final List<RailwayTax> taxes = new ArrayList<RailwayTax>();
    private final List<RailwayProductFop> fops = new ArrayList<RailwayProductFop>();

    public ProductStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProductStatus status) {
        this.status = status;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public void setClient(EntityReference<Organization> client) {
        this.client = client;
    }

    public EntityReference<Organization> getBlankOwner() {
        return this.blankOwner;
    }

    public void setBlankOwner(EntityReference<Organization> blankOwner) {
        this.blankOwner = blankOwner;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public void setSupplier(EntityReference<Organization> supplier) {
        this.supplier = supplier;
    }

    public EntityReference<Organization> getAgency() {
        return this.agency;
    }

    public void setAgency(EntityReference<Organization> agency) {
        this.agency = agency;
    }

    public EntityReference<Organization> getSubagency() {
        return this.subagency;
    }

    public void setSubagency(EntityReference<Organization> subagency) {
        this.subagency = subagency;
    }

    public EntityReference<SalesPoint> getSalesPoint() {
        return this.salesPoint;
    }

    public void setSalesPoint(EntityReference<SalesPoint> salesPoint) {
        this.salesPoint = salesPoint;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public void setAgent(EntityReference<Person> agent) {
        this.agent = agent;
    }

    public String getMcoSystemNumber() {
        return this.mcoSystemNumber;
    }

    public void setMcoSystemNumber(String mcoSystemNumber) {
        this.mcoSystemNumber = mcoSystemNumber;
    }

    public DictionaryReference<BlankType> getBlankType() {
        return this.blankType;
    }

    public void setBlankType(DictionaryReference<BlankType> blankType) {
        this.blankType = blankType;
    }

    public DictionaryReference<BlankType> getMcoBlankType() {
        return this.mcoBlankType;
    }

    public void setMcoBlankType(DictionaryReference<BlankType> mcoBlankType) {
        this.mcoBlankType = mcoBlankType;
    }

    public DictionaryReference<Principal> getCarrier() {
        return this.carrier;
    }

    public void setCarrier(DictionaryReference<Principal> carrier) {
        this.carrier = carrier;
    }

    public TicketType getTicketType() {
        return this.ticketType;
    }

    public void setTicketType(TicketType ticketType) {
        this.ticketType = ticketType;
    }

    public GdsName getGds() {
        return this.gds;
    }

    public void setGds(GdsName gds) {
        this.gds = gds;
    }

    public String getPnr() {
        return this.pnr;
    }

    public RecordLocatorType getRecordLocatorType() {
        return this.recordLocatorType;
    }

    public void setRecordLocatorType(RecordLocatorType recordLocatorType) {
        this.recordLocatorType = recordLocatorType;
    }

    public void setPnr(String pnr) {
        this.pnr = pnr;
    }

    public String getPcc() {
        return this.pcc;
    }

    public void setPcc(String pcc) {
        this.pcc = pcc;
    }

    public String getValidatorCode() {
        return this.validatorCode;
    }

    public void setValidatorCode(String validatorCode) {
        this.validatorCode = validatorCode;
    }

    public NestedEntityReference<SalesPoint, Validator> getValidator() {
        return this.validator;
    }

    public void setValidator(NestedEntityReference<SalesPoint, Validator> validator) {
        this.validator = validator;
    }

    public BigDecimal getTariffAmount() {
        return this.tariffAmount;
    }

    public void setTariffAmount(BigDecimal tariffAmount) {
        this.tariffAmount = tariffAmount;
    }

    public BigDecimal getTariffVatAmount() {
        return this.tariffVatAmount;
    }

    public void setTariffVatAmount(BigDecimal tariffVatAmount) {
        this.tariffVatAmount = tariffVatAmount;
    }

    public BigDecimal getTariffVatRate() {
        return this.tariffVatRate;
    }

    public void setTariffVatRate(BigDecimal tariffVatRate) {
        this.tariffVatRate = tariffVatRate;
    }

    public BigDecimal getServiceAmount() {
        return this.serviceAmount;
    }

    public void setServiceAmount(BigDecimal serviceAmount) {
        this.serviceAmount = serviceAmount;
    }

    public BigDecimal getServiceVatAmount() {
        return this.serviceVatAmount;
    }

    public void setServiceVatAmount(BigDecimal serviceVatAmount) {
        this.serviceVatAmount = serviceVatAmount;
    }

    public BigDecimal getServiceVatRate() {
        return this.serviceVatRate;
    }

    public void setServiceVatRate(BigDecimal serviceVatRate) {
        this.serviceVatRate = serviceVatRate;
    }

    public BigDecimal getPenaltyAmount() {
        return this.penaltyAmount;
    }

    public void setPenaltyAmount(BigDecimal penaltyAmount) {
        this.penaltyAmount = penaltyAmount;
    }

    public BigDecimal getPenaltyVatAmount() {
        return this.penaltyVatAmount;
    }

    public void setPenaltyVatAmount(BigDecimal penaltyVatAmount) {
        this.penaltyVatAmount = penaltyVatAmount;
    }

    public BigDecimal getPenaltyVatRate() {
        return this.penaltyVatRate;
    }

    public void setPenaltyVatRate(BigDecimal penaltyVatRate) {
        this.penaltyVatRate = penaltyVatRate;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getTotalVatAmount() {
        return this.totalVatAmount;
    }

    public void setTotalVatAmount(BigDecimal totalVatAmount) {
        this.totalVatAmount = totalVatAmount;
    }

    public String getEndorsement() {
        return this.endorsement;
    }

    public void setEndorsement(String endorsement) {
        this.endorsement = endorsement;
    }

    public VatDetalization getVatDetalization() {
        return this.vatDetalization;
    }

    public void setVatDetalization(VatDetalization vatDetalization) {
        this.vatDetalization = vatDetalization;
    }

    public List<RailwaySegment> getSegments() {
        return this.segments;
    }

    public List<ReservedSeat> getReservedSeats() {
        return this.reservedSeats;
    }

    public List<RailwayTax> getTaxes() {
        return this.taxes;
    }

    public List<RailwayProductFop> getFops() {
        return this.fops;
    }

    private String toString(VatComponent vatComponent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sum -> " + (vatComponent.getSum() != null ? vatComponent.getSum().toPlainString() : "?"));
        stringBuilder.append("\n");
        stringBuilder.append("rate -> " + vatComponent.getRate());
        stringBuilder.append("\n");
        stringBuilder.append("basis -> " + (vatComponent.getBasis() != null ? vatComponent.getBasis().toPlainString() : "?"));
        stringBuilder.append("\n");
        stringBuilder.append("basisTypes -> " + Arrays.toString(vatComponent.getBasisTypes().toArray()));
        return stringBuilder.toString();
    }

    private String toString(VatDetalization vatDetalization) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("detalized -> " + vatDetalization.isDetalized());
        stringBuilder.append("\n");
        stringBuilder.append(DebugUtil.decorate((Iterable)vatDetalization.getComponents().stream().map(value -> this.toString((VatComponent)value)).collect(Collectors.toList()), null, (String)"components", (boolean)true));
        return stringBuilder.toString();
    }

    private String toString(RailwaySegment segment) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("departureStation -> " + segment.getDepartureStation());
        stringBuilder.append("\n");
        stringBuilder.append("arriveStation -> " + segment.getArriveStation());
        stringBuilder.append("\n");
        stringBuilder.append("trainNumber -> " + segment.getTrainNumber());
        stringBuilder.append("\n");
        stringBuilder.append("slot -> " + segment.getSlot());
        stringBuilder.append("\n");
        stringBuilder.append("carriageNumber -> " + segment.getCarriageNumber());
        stringBuilder.append("\n");
        stringBuilder.append("carriageType -> " + segment.getCarriageType());
        stringBuilder.append("\n");
        stringBuilder.append("compartmentType -> " + segment.getCompartmentType());
        stringBuilder.append("\n");
        stringBuilder.append("serviceClass -> " + segment.getServiceClass());
        stringBuilder.append("\n");
        stringBuilder.append("departureDate -> " + segment.getDepartureDate());
        stringBuilder.append("\n");
        stringBuilder.append("arriveDate -> " + segment.getArriveDate());
        stringBuilder.append("\n");
        stringBuilder.append("amount -> " + (segment.getFare() != null ? (segment.getFare().getValue() != null ? segment.getFare().getValue().toPlainString() : "?") + " " + (segment.getFare().getCurrency() != null ? segment.getFare().getCurrency() : "?") : null));
        stringBuilder.append("\n");
        stringBuilder.append("equivalentAmount -> " + segment.getEquivalentFare());
        stringBuilder.append("\n");
        stringBuilder.append("places -> " + Arrays.toString(segment.getPlaces().toArray()));
        return stringBuilder.toString();
    }

    private String toString(ReservedSeat reservedSeat) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("amount -> " + (reservedSeat.getFare() != null ? (reservedSeat.getFare().getValue() != null ? reservedSeat.getFare().getValue().toPlainString() : "?") + " " + (reservedSeat.getFare().getCurrency() != null ? reservedSeat.getFare().getCurrency() : "?") : null));
        stringBuilder.append("\n");
        stringBuilder.append("equivalentAmount -> " + reservedSeat.getEquivalentFare());
        return stringBuilder.toString();
    }

    private String toString(RailwayTax tax) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("code -> " + tax.getCode());
        stringBuilder.append("\n");
        stringBuilder.append("fare -> " + (tax.getFare() != null ? (tax.getFare().getValue() != null ? tax.getFare().getValue().toPlainString() : "?") + " " + (tax.getFare().getCurrency() != null ? tax.getFare().getCurrency() : "?") : null));
        stringBuilder.append("\n");
        stringBuilder.append("equivalentFare -> " + tax.getEquivalentFare());
        return stringBuilder.toString();
    }

    private String toString(RailwayProductFop fop) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("paymentType -> " + fop.getType());
        stringBuilder.append("\n");
        stringBuilder.append("amount -> " + (fop.getAmount() != null ? (fop.getAmount().getValue() != null ? fop.getAmount().getValue().toPlainString() : "?") + " " + (fop.getAmount().getCurrency() != null ? fop.getAmount().getCurrency() : "?") : null));
        stringBuilder.append("\n");
        stringBuilder.append("passengerStatus -> " + fop.getPassengerStatus());
        stringBuilder.append("\n");
        stringBuilder.append("relatedTicketNumber -> " + fop.getRelatedTicketNumber());
        stringBuilder.append("\n");
        stringBuilder.append("operationDate -> " + fop.getOperationDate());
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("status -> " + this.status);
        stringBuilder.append("\n");
        stringBuilder.append("client -> " + this.client);
        stringBuilder.append("\n");
        stringBuilder.append("blankOwner -> " + this.blankOwner);
        stringBuilder.append("\n");
        stringBuilder.append("supplier -> " + this.supplier);
        stringBuilder.append("\n");
        stringBuilder.append("agency -> " + this.agency);
        stringBuilder.append("\n");
        stringBuilder.append("subagency -> " + this.subagency);
        stringBuilder.append("\n");
        stringBuilder.append("salesPoint -> " + this.salesPoint);
        stringBuilder.append("\n");
        stringBuilder.append("agent -> " + this.agent);
        stringBuilder.append("\n");
        stringBuilder.append("mcoSystemNumber -> " + this.mcoSystemNumber);
        stringBuilder.append("\n");
        stringBuilder.append("blankType -> " + this.blankType);
        stringBuilder.append("\n");
        stringBuilder.append("mcoBlankType -> " + this.mcoBlankType);
        stringBuilder.append("\n");
        stringBuilder.append("carrier -> " + this.carrier);
        stringBuilder.append("\n");
        stringBuilder.append("ticketType -> " + this.ticketType);
        stringBuilder.append("\n");
        stringBuilder.append("gds -> " + this.gds);
        stringBuilder.append("\n");
        stringBuilder.append("pnr -> " + this.pnr);
        stringBuilder.append("\n");
        stringBuilder.append("pcc -> " + this.pcc);
        stringBuilder.append("\n");
        stringBuilder.append("validatorCode -> " + this.validatorCode);
        stringBuilder.append("\n");
        stringBuilder.append("validator -> " + this.validator);
        stringBuilder.append("\n");
        stringBuilder.append("tariffAmount -> " + this.tariffAmount);
        stringBuilder.append("\n");
        stringBuilder.append("tariffVatAmount -> " + this.tariffVatAmount);
        stringBuilder.append("\n");
        stringBuilder.append("tariffVatRate -> " + this.tariffVatRate);
        stringBuilder.append("\n");
        stringBuilder.append("serviceAmount -> " + this.serviceAmount);
        stringBuilder.append("\n");
        stringBuilder.append("serviceVatAmount -> " + this.serviceVatAmount);
        stringBuilder.append("\n");
        stringBuilder.append("serviceVatRate -> " + this.serviceVatRate);
        stringBuilder.append("\n");
        stringBuilder.append("penaltyAmount -> " + this.penaltyAmount);
        stringBuilder.append("\n");
        stringBuilder.append("penaltyVatAmount -> " + this.penaltyVatAmount);
        stringBuilder.append("\n");
        stringBuilder.append("penaltyVatRate -> " + this.penaltyVatRate);
        stringBuilder.append("\n");
        stringBuilder.append("totalAmount -> " + this.totalAmount);
        stringBuilder.append("\n");
        stringBuilder.append("totalVatAmount -> " + this.totalVatAmount);
        stringBuilder.append("\n");
        stringBuilder.append("endorsement -> " + this.endorsement);
        stringBuilder.append("\n");
        if (this.vatDetalization != null) {
            stringBuilder.append(DebugUtil.decorate((String)this.toString(this.vatDetalization), null, (String)"vatDetalization", (boolean)true));
        }
        stringBuilder.append(DebugUtil.decorate((Iterable)this.segments.stream().map(value -> this.toString((RailwaySegment)value)).collect(Collectors.toList()), null, (String)"segments", (boolean)true));
        stringBuilder.append(DebugUtil.decorate((Iterable)this.reservedSeats.stream().map(value -> this.toString((ReservedSeat)value)).collect(Collectors.toList()), null, (String)"reservedSeats", (boolean)true));
        stringBuilder.append(DebugUtil.decorate((Iterable)this.taxes.stream().map(value -> this.toString((RailwayTax)value)).collect(Collectors.toList()), null, (String)"taxes", (boolean)true));
        stringBuilder.append(DebugUtil.decorate((Iterable)this.fops.stream().map(value -> this.toString((RailwayProductFop)value)).collect(Collectors.toList()), null, (String)"fops", (boolean)true));
        return stringBuilder.toString();
    }
}

