/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.express;

import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.railway.parsers.ExpressExchangeDocument;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.ibus.parsers.express.ExpressData;
import java.util.Collection;

public class ExpressUpdateExchangeDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        ExpressExchangeDocument exchangeDocument = (ExpressExchangeDocument)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT);
        ExpressData data = (ExpressData)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        ProductSearchResult searchResult = (ProductSearchResult)context.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        exchangeDocument.setOwner(searchResult.getBookingFile().toReference());
        exchangeDocument.setRelatedBookingFile(searchResult.getBookingFile().toReference());
        exchangeDocument.setSystemNumber(data.getSystemNumber());
        exchangeDocument.setIssueDate(data.getIssueDate());
        exchangeDocument.setTransactionType(data.getTransactionType());
        exchangeDocument.getTravellers().clear();
        for (Traveller traveller : data.getTravellers()) {
            exchangeDocument.getTravellers().add(traveller.getName());
        }
        exchangeDocument.getMessages().clear();
        exchangeDocument.getMessages().addAll(context.getMessagesReadOnly());
        if (MessageHelper.hasMessages((Collection)exchangeDocument.getMessages(), (MessageType)MessageType.ERROR)) {
            exchangeDocument.setStatus(ProcessingStatus.ERROR);
        } else if (MessageHelper.hasMessages((Collection)exchangeDocument.getMessages(), (MessageType)MessageType.WARNING)) {
            exchangeDocument.setStatus(ProcessingStatus.WARNING);
        } else {
            exchangeDocument.setStatus(ProcessingStatus.OK);
        }
    }
}

