/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.express;

import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.TravellerHelper;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.ibus.parsers.express.ExpressRailwayProductData;
import java.util.ArrayList;
import java.util.Collection;

public class ExpressUpdateRailwayProductCommonProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        ExpressRailwayProductData data = (ExpressRailwayProductData)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        ProductSearchResult productSearchResult = (ProductSearchResult)context.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        if (this.log.isDebugEnabled()) {
            this.log.debug("railway product parse data -> \n\n" + data);
        }
        boolean exists = productSearchResult.isExists();
        this.update(context, product, data, exists);
    }

    private void update(MessageContext context, RailwayProduct product, ExpressRailwayProductData data, boolean exists) throws Exception {
        BookingFile bookingFile = product.getReservation().getBookingFile();
        if (bookingFile.getCustomerProfile() == null) {
            bookingFile.setCustomerProfile(data.getClient());
        }
        if (bookingFile.getAgency() == null) {
            bookingFile.setAgency(data.getAgency());
        }
        if (bookingFile.getCreateDate() == null) {
            bookingFile.setCreateDate(data.getIssueDate());
        }
        ArrayList<Traveller> productTravellers = new ArrayList<Traveller>();
        for (Traveller traveller : data.getTravellers()) {
            Traveller bookingFileTraveller = (Traveller)CollectionUtil.find((Collection)bookingFile.getTravellers(), (Object)traveller, TravellerHelper::equals);
            if (bookingFileTraveller != null) {
                if (bookingFileTraveller.getName() == null) {
                    bookingFileTraveller.setName(traveller.getName());
                }
                if (bookingFileTraveller.getCyrillicName() == null) {
                    bookingFileTraveller.setCyrillicName(traveller.getCyrillicName());
                }
                if (bookingFileTraveller.getPassport() != null) {
                    if (traveller.getPassport() != null) {
                        if (bookingFileTraveller.getPassport().getLastName() == null) {
                            bookingFileTraveller.getPassport().setLastName(traveller.getPassport().getLastName());
                        }
                        if (bookingFileTraveller.getPassport().getFirstName() == null) {
                            bookingFileTraveller.getPassport().setFirstName(traveller.getPassport().getFirstName());
                        }
                        if (bookingFileTraveller.getPassport().getMiddleName() == null) {
                            bookingFileTraveller.getPassport().setMiddleName(traveller.getPassport().getMiddleName());
                        }
                        if (bookingFileTraveller.getPassport().getType() == null) {
                            bookingFileTraveller.getPassport().setType(traveller.getPassport().getType());
                        }
                        if (bookingFileTraveller.getPassport().getNumber() == null) {
                            bookingFileTraveller.getPassport().setNumber(traveller.getPassport().getNumber());
                        }
                        if (bookingFileTraveller.getPassport().getBirthday() == null) {
                            bookingFileTraveller.getPassport().setBirthday(traveller.getPassport().getBirthday());
                        }
                        if (bookingFileTraveller.getPassport().getGender() == null) {
                            bookingFileTraveller.getPassport().setGender(traveller.getPassport().getGender());
                        }
                        if (bookingFileTraveller.getPassport().getCitizenship() == null) {
                            bookingFileTraveller.getPassport().setCitizenship(traveller.getPassport().getCitizenship());
                        }
                    }
                } else {
                    bookingFileTraveller.setPassport(traveller.getPassport());
                }
                productTravellers.add(bookingFileTraveller);
                continue;
            }
            bookingFile.getTravellers().add(traveller);
            productTravellers.add(traveller);
        }
        Reservation reservation = product.getReservation();
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)data.getGds(), (RecordLocatorType)data.getRecordLocatorType(), (String)data.getPnr());
        if (reservation.getSubagency() == null) {
            reservation.setSubagency(data.getSubagency());
        }
        if (reservation.getSalesPoint() == null) {
            reservation.setSalesPoint(data.getSalesPoint());
        }
        if (reservation.getBookingAgent() == null) {
            reservation.setBookingAgent(data.getAgent());
        }
        product.setTicketType(data.getTicketType());
        if (product.getStatus() != ProductStatus.VOID) {
            product.setStatus(data.getStatus());
        }
        product.setBlankOwnerRef(data.getBlankOwner());
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, data.getSupplier());
        RailwayProductHelper.setAgency((BaseTicketProduct)product, data.getAgency());
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, data.getSubagency());
        product.setSalesPoint(data.getSalesPoint());
        product.setCashier(data.getAgent());
        product.setValidatorCode(data.getValidatorCode());
        product.setValidatorRef(data.getValidator());
        product.setBlankType(data.getBlankType());
        product.setIssueDate(data.getIssueDate());
        product.setSystemNumber(data.getSystemNumber());
        product.setPcc(data.getPcc());
        product.setCarrier(data.getCarrier());
        product.getPassengers().clear();
        product.getPassengers().addAll(productTravellers);
        product.getPassengerTypes().clear();
        product.setEquivalentFare(data.getTariffAmount());
        product.setEquivalentVAT(data.getTariffVatAmount());
        product.setServiceFare(data.getServiceAmount());
        product.setServiceVAT(data.getServiceVatAmount());
        product.setTotalEquivalentFare(data.getTotalAmount());
        product.setTotalEquivalentVAT(data.getTotalVatAmount());
        product.getSegments().clear();
        product.getSegments().addAll(data.getSegments());
        product.getReservedSeats().clear();
        product.getReservedSeats().addAll(data.getReservedSeats());
        product.getTaxes().clear();
        product.getTaxes().addAll(data.getTaxes());
        product.setVendorVatDetalization(data.getVatDetalization());
        if (!exists) {
            product.setChecked(false);
            product.setContractRulesApplied(false);
            RailwayProductContractRelationData vendorContractRelation = RailwayProductHelper.getVendorContractRelation((RailwayProduct)product);
            RailwayProductContractRelationData subagentContractRelation = RailwayProductHelper.getSubagentContractRelation((RailwayProduct)product, (boolean)false);
            RailwayProductContractRelationData clientContractRelation = RailwayProductHelper.getClientContractRelation((RailwayProduct)product);
            if (vendorContractRelation != null) {
                vendorContractRelation.getFops().clear();
            }
            if (subagentContractRelation != null) {
                subagentContractRelation.getFops().clear();
            }
            if (clientContractRelation != null) {
                clientContractRelation.getFops().clear();
            }
            for (RailwayProductFop fop : data.getFops()) {
                fop.setAgent(null);
                fop.setOperationDate(null);
                if (vendorContractRelation != null) {
                    RailwayProductFop vendorFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    vendorContractRelation.getFops().add(vendorFop);
                }
                if (subagentContractRelation != null) {
                    RailwayProductFop subagentFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    subagentContractRelation.getFops().add(subagentFop);
                }
                if (clientContractRelation == null) continue;
                RailwayProductFop clientFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                clientContractRelation.getFops().add(clientFop);
            }
        }
        product.setEndorsement(data.getEndorsement());
    }
}

