/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.express;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.ibus.parsers.express.ExpressRailwayProductData;

public class ExpressUpdateRailwayProductRefundProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        ExpressRailwayProductData data = (ExpressRailwayProductData)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        ProductSearchResult productSearchResult = (ProductSearchResult)context.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        boolean exists = productSearchResult.isExists();
        this.update(context, product, data, exists);
    }

    private void update(MessageContext context, RailwayProduct product, ExpressRailwayProductData data, boolean exists) throws Exception {
        if (data.getMcoSystemNumber() != null) {
            RailwayReferenceMCO mco = product.getReservation().getProducts().stream().filter(item -> item instanceof RailwayReferenceMCO).map(item -> (RailwayReferenceMCO)item).filter(item -> MiscUtil.equals((Object)item.getRelatedProduct(), (Object)product) && MiscUtil.equals((Object)item.getSystemNumber(), (Object)data.getMcoSystemNumber()) && item.getStatus() == ProductStatus.SELL).findFirst().orElse(null);
            if (mco == null) {
                mco = new RailwayReferenceMCO();
                product.getReservation().getProducts().add(mco);
                mco.setReservation(product.getReservation());
            }
            mco.setTicketType(data.getTicketType());
            mco.setStatus(ProductStatus.SELL);
            mco.setBlankType(data.getMcoBlankType());
            mco.setIssueDate(data.getIssueDate());
            mco.setSystemNumber(data.getMcoSystemNumber());
            mco.setRelatedProduct((BaseProduct)product);
        }
        product.setPenalty(data.getPenaltyAmount());
        product.setPenaltyVAT(data.getPenaltyVatAmount());
    }
}

