/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.express;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCardType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDictionaryHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.railway.ibus.parsers.express.ExpressHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.express.ExpressRailwayProductData;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ExpressVoidRecordHandlers implements ExpressHelper.RecordHandler<ExpressRailwayProductData>
{
    TERMINAL{

        @Override
        public ExpressHelper.RecordType getRecordType() {
            return ExpressHelper.RecordType.TERMINAL;
        }

        @Override
        public boolean isMultiline() {
            return false;
        }

        @Override
        public double getPriority() {
            return 0.0;
        }

        @Override
        public List<String> getPatterns() {
            return Arrays.asList("^\\D{2}\\d{6}\\s+.{3}\\s+(\\D{1}\\s+)*.{2}\\s+\\d{7}\\s+\\d{6}\\s+\\d{4}\\s+.+$");
        }

        @Override
        public void parse(ExpressRailwayProductData data, String record, String agentCode, List<Message> messages, boolean registration) {
            String systemNumber = null;
            Date issueDate = null;
            String pnr = null;
            String pcc = null;
            if (Pattern.compile(this.getPatterns().get(0)).matcher(record).find()) {
                String[] entries = record.split("[\\s/]+");
                for (int i = 0; i < entries.length; ++i) {
                    if (Pattern.compile("^\\D{1,2}\\d{6}$").matcher(entries[i].trim()).find()) {
                        systemNumber = entries[i].trim();
                    }
                    if (Pattern.compile("^\\d{7}$").matcher(entries[i].trim()).find()) {
                        pnr = entries[i].trim();
                    }
                    if (Pattern.compile("^\\d{6}$").matcher(entries[i].trim()).find() && i + 1 < entries.length && Pattern.compile("^\\d{4}$").matcher(entries[i + 1].trim()).find()) {
                        String dateEntry = entries[i].trim();
                        String timeEntry = entries[i + 1].trim();
                        try {
                            issueDate = new SimpleDateFormat("ddMMyy.HHmm").parse(String.format("%s.%s", dateEntry, timeEntry));
                        }
                        catch (ParseException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductIssueDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    }
                    if (!Pattern.compile("^\\D{2}\\d{3}\\D{1}\\d{2}$").matcher(entries[i].trim()).find()) continue;
                    pcc = entries[i].trim().substring(2);
                }
            }
            data.setSystemNumber(systemNumber);
            data.setIssueDate(issueDate);
            data.setPnr(pnr);
            data.setPcc(pcc);
        }
    }
    ,
    GENERAL{

        @Override
        public ExpressHelper.RecordType getRecordType() {
            return ExpressHelper.RecordType.GENERAL;
        }

        @Override
        public boolean isMultiline() {
            return false;
        }

        @Override
        public double getPriority() {
            return 1.0;
        }

        @Override
        public List<String> getPatterns() {
            return Arrays.asList("^\\d{3}[\\*\\s]*\\D{2}\\s+\\d{2}\\.\\d{2}\\s+\\d{2}(\\.|:)\\d{2}\\s+\\d{2}\\s+\\D{1}\\s+\\d{6}\\.\\d{1}\\s+\\d{6}\\.\\d{1}\\s+.+$");
        }

        @Override
        public void parse(ExpressRailwayProductData data, String record, String agentCode, List<Message> messages, boolean registration) {
            String trainNumber = null;
            String slot = null;
            String carriageNumber = null;
            CarriageType carriageType = null;
            Date departureDate = null;
            Money segmentAmount = null;
            Money reservedSeatAmount = null;
            String currency = DictHelper.getCurrencyByAnyCode((String)"RUB");
            if (Pattern.compile(this.getPatterns().get(0)).matcher(record).find()) {
                BigDecimal amount;
                String entry;
                int index;
                String[] entries = record.split("\\s+");
                if (entries.length > (index = 0)) {
                    entry = entries[index].trim();
                    if (Pattern.compile("^\\d{3}$").matcher(entry).find()) {
                        try {
                            trainNumber = String.valueOf(Integer.valueOf(entry));
                        }
                        catch (NumberFormatException e) {
                            trainNumber = entry;
                        }
                        if (entries.length > index + 1) {
                            slot = entries[index + 1].trim();
                            ++index;
                        }
                    } else {
                        Matcher matcher = Pattern.compile("^(\\d{3})\\**(\\D{2})$").matcher(entry);
                        if (matcher.matches()) {
                            try {
                                trainNumber = String.valueOf(Integer.valueOf(matcher.group(1)));
                            }
                            catch (NumberFormatException e) {
                                trainNumber = matcher.group(1);
                            }
                            slot = matcher.group(2);
                        }
                    }
                    ++index;
                }
                if (entries.length > index + 1) {
                    String yearEntry = String.valueOf(Calendar.getInstance().get(1));
                    String dateEntry = entries[index].trim();
                    String timeEntry = entries[index + 1].trim();
                    timeEntry = timeEntry.replaceAll(":", ".");
                    try {
                        departureDate = new SimpleDateFormat("yyyy.dd.MM.HH.mm").parse(String.format("%s.%s.%s", yearEntry, dateEntry, timeEntry));
                        if (data.getIssueDate() != null && data.getIssueDate().after(departureDate)) {
                            departureDate = MiscUtil.addToDate((Date)departureDate, (int)1, (int)1);
                        }
                    }
                    catch (ParseException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentDepartureDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    index += 2;
                }
                if (entries.length > index) {
                    entry = entries[index].trim();
                    try {
                        carriageNumber = String.valueOf(Integer.valueOf(entry));
                    }
                    catch (NumberFormatException e) {
                        carriageNumber = entry;
                    }
                    ++index;
                }
                if (entries.length > index) {
                    entry = entries[index].trim();
                    carriageType = ExpressHelper.getCarriageType(entry);
                    if (carriageType == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentCarriageTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_carriageTypeWithCodeNotSupported, (Object[])new Object[]{entry}), (Object[])new Object[0]));
                    }
                    ++index;
                }
                if (entries.length > index) {
                    entry = entries[index].trim();
                    try {
                        amount = new BigDecimal(entry);
                        segmentAmount = new Money();
                        segmentAmount.setValue(amount);
                        segmentAmount.setCurrency(currency);
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    ++index;
                }
                if (entries.length > index) {
                    entry = entries[index].trim();
                    try {
                        amount = new BigDecimal(entry);
                        reservedSeatAmount = new Money();
                        reservedSeatAmount.setValue(amount);
                        reservedSeatAmount.setCurrency(currency);
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductReservedSeatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    ++index;
                }
            }
            RailwaySegment segment = data.getSegments().size() > 0 ? data.getSegments().get(0) : new RailwaySegment();
            segment.setTrainNumber(trainNumber);
            segment.setSlot(slot);
            segment.setCarriageNumber(carriageNumber);
            segment.setCarriageType(carriageType);
            segment.setDepartureDate(departureDate);
            segment.setFare(segmentAmount);
            segment.setEquivalentFare(segmentAmount != null ? segmentAmount.getValue() : null);
            ReservedSeat reservedSeat = data.getReservedSeats().size() > 0 ? data.getReservedSeats().get(0) : new ReservedSeat();
            reservedSeat.setFare(reservedSeatAmount);
            reservedSeat.setEquivalentFare(reservedSeatAmount != null ? reservedSeatAmount.getValue() : null);
            data.getSegments().clear();
            data.getSegments().add(segment);
            data.getReservedSeats().clear();
            data.getReservedSeats().add(reservedSeat);
        }
    }
    ,
    SEGMENT{

        @Override
        public ExpressHelper.RecordType getRecordType() {
            return ExpressHelper.RecordType.SEGMENT;
        }

        @Override
        public boolean isMultiline() {
            return false;
        }

        @Override
        public double getPriority() {
            return 2.0;
        }

        @Override
        public List<String> getPatterns() {
            return Arrays.asList("^.+-.+\\s+\\(\\d{7}-\\d{7}\\)\\s+.+$", "^.+->.+\\s+.+$");
        }

        @Override
        public void parse(ExpressRailwayProductData data, String record, String agentCode, List<Message> messages, boolean registration) {
            Matcher matcher;
            RailwayStationReference departureStation = null;
            RailwayStationReference arriveStation = null;
            ServiceClass serviceClass = null;
            if (Pattern.compile(this.getPatterns().get(0)).matcher(record).find()) {
                int index;
                String[] entries = record.split("[()]");
                if (entries.length > (index = 1)) {
                    Iterator iterator;
                    String routeString = entries[index].trim();
                    String[] values = routeString.split("-");
                    if (values.length > 0) {
                        RailwayStation departureLocation;
                        String departureStationCode = values[0].trim();
                        Collection departureLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)departureStationCode);
                        if (departureLocations.size() > 1) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentDepartureStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_railwayStationWithCodeMultipleFound, (Object[])new Object[]{departureStationCode}), (Object[])new Object[0]));
                        }
                        RailwayStation railwayStation = departureLocation = (iterator = departureLocations.iterator()).hasNext() ? (RailwayStation)iterator.next() : null;
                        if (departureLocation != null) {
                            departureStation = departureLocation.toReference();
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentDepartureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_railwayStationWithCodeNotFound, (Object[])new Object[]{departureStationCode}), (Object[])new Object[0]));
                        }
                    }
                    if (values.length > 1) {
                        RailwayStation arriveLocation;
                        String arriveStationCode = values[1].trim();
                        Collection arriveLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)arriveStationCode);
                        if (arriveLocations.size() > 1) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentArriveStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_railwayStationWithCodeMultipleFound, (Object[])new Object[]{arriveStationCode}), (Object[])new Object[0]));
                        }
                        RailwayStation railwayStation = arriveLocation = (iterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)iterator.next() : null;
                        if (arriveLocation != null) {
                            arriveStation = arriveLocation.toReference();
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentArriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_railwayStationWithCodeNotFound, (Object[])new Object[]{arriveStationCode}), (Object[])new Object[0]));
                        }
                    }
                    ++index;
                }
                if (entries.length > index) {
                    String[] values = entries[2].trim().split("\\s+");
                    String trainTitleString = null;
                    Object serviceClassString = null;
                    for (String value : values) {
                        if (Pattern.compile("^(\u0424\u0418\u0420\u041c|\u0421\u0410\u041f\u0421\u0410\u041d|\u041b\u0410\u0421\u0422\u041e\u0427\u041a\u0410|\u0421\u0422\u0420\u0418\u0416|\u0422\u0410\u0412\u0420\u0418\u042f)$").matcher(value.trim()).find()) {
                            trainTitleString = value;
                        } else if (Pattern.compile("^\u041a\u041b\\.\u041e\u0411\u0421\u041b\\.\\d{1}\\D{1}$").matcher(value.trim()).find()) {
                            serviceClassString = value.substring(8);
                        } else if (Pattern.compile("^\\d{1}\\D{1}$").matcher(value.trim()).find()) {
                            serviceClassString = value;
                        }
                        if (trainTitleString != null && serviceClassString != null) break;
                    }
                    if (trainTitleString != null) {
                        // empty if block
                    }
                    if (serviceClassString != null && (serviceClass = ExpressHelper.getServiceClass(serviceClassString)) == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentServiceClassDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_serviceClassWithCodeNotSupported, (Object[])new Object[]{serviceClassString}), (Object[])new Object[0]));
                    }
                    ++index;
                }
            } else if (Pattern.compile(this.getPatterns().get(1)).matcher(record).find() && (matcher = Pattern.compile("^(.+)->(.+)$").matcher(record)).matches()) {
                Iterator iterator;
                RailwayStation departureLocation;
                Collection departureLocations;
                String departureStationName = matcher.group(1).trim();
                if (departureStationName.indexOf("(") >= 0) {
                    departureStationName = departureStationName.substring(0, departureStationName.indexOf("("));
                }
                if ((departureLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)departureStationName, (RailwayStationVendorCardType)RailwayStationVendorCardType.RZD)).size() == 0) {
                    departureLocations = RailwayProductDictionaryHelper.findStationsByTranslationOrSpellVariant((String)departureStationName, (RailwayStationVendorCardType)RailwayStationVendorCardType.RZD);
                }
                if (departureLocations.size() > 1) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentDepartureStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_railwayStationWithNameMultipleFound, (Object[])new Object[]{departureStationName}), (Object[])new Object[0]));
                }
                RailwayStation railwayStation = departureLocation = (iterator = departureLocations.iterator()).hasNext() ? (RailwayStation)iterator.next() : null;
                if (departureLocation != null) {
                    departureStation = departureLocation.toReference();
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentDepartureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_railwayStationWithNameNotFound, (Object[])new Object[]{departureStationName}), (Object[])new Object[0]));
                }
                String[] values = matcher.group(2).trim().split("\\s+");
                String arriveStationName = null;
                String trainTitleString = null;
                String serviceClassString = null;
                boolean searchingArriveStationNameEnd = true;
                for (String value : values) {
                    if (Pattern.compile("^(\u0424\u0418\u0420\u041c|\u0421\u0410\u041f\u0421\u0410\u041d|\u041b\u0410\u0421\u0422\u041e\u0427\u041a\u0410|\u0421\u0422\u0420\u0418\u0416|\u0422\u0410\u0412\u0420\u0418\u042f)$").matcher(value.trim()).find()) {
                        trainTitleString = value;
                        searchingArriveStationNameEnd = false;
                    } else if (Pattern.compile("^(\u0411\u042e\u0414\u0416\u0415\u0422|\u0421\u0422\u0410\u041d\u0414\u0410\u0420\u0422|\u041a\u041e\u041c\u0424\u041e\u0420\u0422)$").matcher(value.trim()).find()) {
                        searchingArriveStationNameEnd = false;
                    } else if (Pattern.compile("^\u041a\u041b\\.\u041e\u0411\u0421\u041b\\.\\d{1}\\D{1}$").matcher(value.trim()).find()) {
                        serviceClassString = value.substring(8);
                        searchingArriveStationNameEnd = false;
                    } else if (Pattern.compile("^\\d{1}\\D{1}$").matcher(value.trim()).find()) {
                        serviceClassString = value;
                        searchingArriveStationNameEnd = false;
                    } else if (searchingArriveStationNameEnd) {
                        String string = arriveStationName = arriveStationName != null ? String.format("%s %s", arriveStationName, value) : value;
                    }
                    if (arriveStationName != null && trainTitleString != null && serviceClassString != null) break;
                }
                if (arriveStationName != null) {
                    RailwayStation arriveLocation;
                    Collection arriveLocations;
                    if (arriveStationName.indexOf("(") >= 0) {
                        arriveStationName = arriveStationName.substring(0, arriveStationName.indexOf("("));
                    }
                    if ((arriveLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)arriveStationName, (RailwayStationVendorCardType)RailwayStationVendorCardType.RZD)).size() == 0) {
                        arriveLocations = RailwayProductDictionaryHelper.findStationsByTranslationOrSpellVariant((String)arriveStationName, (RailwayStationVendorCardType)RailwayStationVendorCardType.RZD);
                    }
                    if (arriveLocations.size() > 1) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentArriveStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_railwayStationWithNameMultipleFound, (Object[])new Object[]{arriveStationName}), (Object[])new Object[0]));
                    }
                    RailwayStation railwayStation2 = arriveLocation = (iterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)iterator.next() : null;
                    if (arriveLocation != null) {
                        arriveStation = arriveLocation.toReference();
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentArriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_railwayStationWithNameNotFound, (Object[])new Object[]{arriveStationName}), (Object[])new Object[0]));
                    }
                }
                if (trainTitleString != null) {
                    // empty if block
                }
                if (serviceClassString != null && (serviceClass = ExpressHelper.getServiceClass(serviceClassString)) == null) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentServiceClassDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_serviceClassWithCodeNotSupported, (Object[])new Object[]{serviceClassString}), (Object[])new Object[0]));
                }
            }
            RailwaySegment segment = data.getSegments().size() > 0 ? data.getSegments().get(0) : new RailwaySegment();
            segment.setDepartureStation(departureStation);
            segment.setArriveStation(arriveStation);
            segment.setServiceClass(serviceClass);
            data.getSegments().clear();
            data.getSegments().add(segment);
        }
    }
    ,
    PLACE{

        @Override
        public ExpressHelper.RecordType getRecordType() {
            return ExpressHelper.RecordType.PLACE;
        }

        @Override
        public boolean isMultiline() {
            return false;
        }

        @Override
        public double getPriority() {
            return 3.0;
        }

        @Override
        public List<String> getPatterns() {
            return Arrays.asList("^(\u041c\u0415\u0421\u0422\u0410|\u0411\u0415\u0417 \u041c\u0415\u0421\u0422)\\s+.+$");
        }

        @Override
        public void parse(ExpressRailwayProductData data, String record, String agentCode, List<Message> messages, boolean registration) {
            CompartmentType compartmentType = null;
            ArrayList<String> places = new ArrayList<String>();
            if (Pattern.compile(this.getPatterns().get(0)).matcher(record).find()) {
                String entry;
                int index;
                String[] entries = record.split("\\s+");
                if (entries.length > (index = 0)) {
                    entry = entries[index].trim();
                    if (Pattern.compile("^\u041c\u0415\u0421\u0422\u0410$").matcher(entry).find() && entries.length > ++index) {
                        entry = entries[index].trim();
                        for (String place : entry.split(";")) {
                            if (place.contains("-")) {
                                String[] values = place.split("-");
                                if (values.length != 2) continue;
                                Integer startPlace = null;
                                Integer endPlace = null;
                                try {
                                    startPlace = Integer.valueOf(values[0].trim());
                                    endPlace = Integer.valueOf(values[1].trim());
                                }
                                catch (NumberFormatException e) {
                                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentSeatNumberDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                                }
                                if (startPlace == null || endPlace == null || startPlace > endPlace) continue;
                                for (int i = startPlace.intValue(); i <= endPlace; ++i) {
                                    places.add(String.valueOf(i));
                                }
                                continue;
                            }
                            places.add(place);
                        }
                        ++index;
                    }
                }
                if (entries.length > index) {
                    entry = entries[index].trim();
                    Matcher matcher = Pattern.compile("^/(\\D+)$").matcher(entry);
                    if (matcher.matches()) {
                        compartmentType = ExpressHelper.getCompartmentType(matcher.group(1).trim());
                        if (compartmentType == null) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductSegmentCompartmentTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_compartmentTypeWithCodeNotSupported, (Object[])new Object[]{entry}), (Object[])new Object[0]));
                        }
                    } else {
                        compartmentType = CompartmentType.COMMON;
                    }
                    ++index;
                }
            }
            RailwaySegment segment = data.getSegments().size() > 0 ? data.getSegments().get(0) : new RailwaySegment();
            segment.setCompartmentType(compartmentType);
            segment.getPlaces().clear();
            segment.getPlaces().addAll(places);
            data.getSegments().clear();
            data.getSegments().add(segment);
        }
    }
    ,
    PASSENGER{

        @Override
        public ExpressHelper.RecordType getRecordType() {
            return ExpressHelper.RecordType.PASSENGER;
        }

        @Override
        public boolean isMultiline() {
            return false;
        }

        @Override
        public double getPriority() {
            return 4.0;
        }

        @Override
        public List<String> getPatterns() {
            return Arrays.asList("^(.+/)*(\u041f\u041d|\u0417\u041f|\u0421\u041f|\u0414\u041f|\u041f\u0421|\u0421\u0420|\u0412\u0411|\u0423\u0412|\u0417\u0417|\u0411\u0413|\u0412\u0416|\u0421\u0423|\u0421\u0412|\u041f\u041c|\u0421\u041e|\u041f\u0411|\u0417\u041c|\u041f\u0423|\u041f\u041a|\u041f\u0422|\u041f\u0417|\u0423\u041b|\u0418\u0418)[^=]+/.+=.+$");
        }

        @Override
        public void parse(ExpressRailwayProductData data, String record, String agentCode, List<Message> messages, boolean registration) {
            ArrayList<Traveller> travellers = new ArrayList<Traveller>();
            if (Pattern.compile(this.getPatterns().get(0)).matcher(record).find()) {
                String[] entries = record.split("/");
                int endEntryIndex = 0;
                for (int i = 0; i < entries.length; ++i) {
                    String passportTypeCode;
                    String entry = entries[i].trim();
                    if (Pattern.compile("^(\u0421\u041f\u0420|\u0421\u041f\u0420\u0410\u0412\u041a\u0410).*$").matcher(entry).find() || !Pattern.compile("^(\u041f\u041d|\u0417\u041f|\u0421\u041f|\u0414\u041f|\u041f\u0421|\u0421\u0420|\u0412\u0411|\u0423\u0412|\u0417\u0417|\u0411\u0413|\u0412\u0416|\u0421\u0423|\u0421\u0412|\u041f\u041c|\u0421\u041e|\u041f\u0411|\u0417\u041c|\u041f\u0423|\u041f\u041a|\u041f\u0422|\u041f\u0417|\u0423\u041b|\u0418\u0418)[^=]+$").matcher(entry).find()) continue;
                    PassportType passportType = null;
                    String passportNumber = null;
                    String lastName = null;
                    String firstName = null;
                    String middleName = null;
                    Date birthday = null;
                    CountryReference citizenship = null;
                    Gender gender = null;
                    if (i - endEntryIndex >= 2) {
                        // empty if block
                    }
                    if (entry.length() > 1 && (passportType = ExpressHelper.getPassportType(passportTypeCode = entry.substring(0, 2))) == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductTravellerPassportTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_passportTypeWithCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
                    }
                    if (entry.length() > 2) {
                        passportNumber = entry.substring(2);
                    }
                    endEntryIndex = i + 1;
                    if (entries.length > i + 1) {
                        entry = entries[i + 1].trim();
                        if (Pattern.compile(".+=.+(=.+)*").matcher(entry).find()) {
                            String value;
                            String[] values = entry.split("[=]");
                            if (values.length > 0) {
                                lastName = value = values[0].trim().replaceAll("[\\d-]", "");
                            }
                            if (values.length > 1) {
                                value = values[1].trim().replaceAll("[\\d-]", "");
                                if (value.length() == 2 && values.length == 2) {
                                    firstName = value.substring(0, 1);
                                    middleName = value.substring(1, 2);
                                } else {
                                    firstName = value;
                                }
                            }
                            if (middleName == null && values.length > 2) {
                                middleName = value = values[2].trim().replaceAll("[\\d-]", "");
                            }
                            ++endEntryIndex;
                        }
                    }
                    if (entries.length > i + 2) {
                        entry = entries[i + 2].trim();
                        if (Pattern.compile("^\\d{8}$").matcher(entry).find()) {
                            try {
                                birthday = new SimpleDateFormat("ddMMyyyy").parse(entry);
                            }
                            catch (ParseException e) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductTravellerBirthdayDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                            ++endEntryIndex;
                        }
                    }
                    if (entries.length > i + 3) {
                        entry = entries[i + 3].trim();
                        if (Pattern.compile("^\\w{3}$").matcher(entry).find()) {
                            Iterator iterator;
                            Country country;
                            String countryCodeString = entry;
                            Set countries = DictionaryCache.get().lookup(Country.class, countryCodeString, new String[]{CodeSystem.ISO.name(), CodeSystem.ISO_ALPHA3.name()});
                            if (countries.isEmpty()) {
                                countries = DictionaryCache.get().lookup(Country.class, countryCodeString, new String[]{CodeSystem.ISO_ALPHA3.name()});
                            }
                            if (countries.size() > 1) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductTravellerCitizenshipDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_countryWithCodeMultipleFound, (Object[])new Object[]{countryCodeString}), (Object[])new Object[0]));
                            }
                            Country country2 = country = (iterator = countries.iterator()).hasNext() ? (Country)iterator.next() : null;
                            if (country != null) {
                                citizenship = country.toReference();
                            } else {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductTravellerCitizenshipDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_countryWithCodeNotFound, (Object[])new Object[]{countryCodeString}), (Object[])new Object[0]));
                            }
                            ++endEntryIndex;
                        }
                    }
                    if (entries.length > i + 4) {
                        entry = entries[i + 4].trim();
                        if (Pattern.compile("^(\u041c|M|\u0416|F)$").matcher(entry).find()) {
                            String genderCode = entry;
                            gender = ExpressHelper.getGender(genderCode);
                            if (gender == null) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductTravellerGenderDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_genderWithCodeNotSupported, (Object[])new Object[]{genderCode}), (Object[])new Object[0]));
                            }
                            ++endEntryIndex;
                        }
                    }
                    if (passportType == null && passportNumber == null && lastName == null && firstName == null && middleName == null && birthday == null && citizenship == null && gender == null) continue;
                    Traveller traveller = new Traveller();
                    Passport passport = new Passport();
                    passport.setType(passportType);
                    passport.setNumber(passportNumber);
                    passport.setLastName(lastName);
                    passport.setFirstName(firstName);
                    passport.setMiddleName(middleName);
                    passport.setBirthday(birthday);
                    passport.setCitizenship(citizenship);
                    passport.setGender(gender);
                    String name = TextUtil.buildFullName((PersonalName)passport);
                    String cyrillicName = TextUtil.translit((String)name, (boolean)false);
                    traveller.setName(name);
                    traveller.setCyrillicName(cyrillicName);
                    traveller.setBirthday(birthday);
                    traveller.setGender(gender);
                    traveller.setPassport(passport);
                    travellers.add(traveller);
                }
            }
            data.getTravellers().clear();
            data.getTravellers().addAll(travellers);
        }
    }
    ,
    TARIFF{

        @Override
        public ExpressHelper.RecordType getRecordType() {
            return ExpressHelper.RecordType.TARIFF;
        }

        @Override
        public boolean isMultiline() {
            return true;
        }

        @Override
        public double getPriority() {
            return 5.0;
        }

        @Override
        public List<String> getPatterns() {
            return Arrays.asList("^\u041d-\\d+.\\d{1}\\s+.+$");
        }

        @Override
        public void parse(ExpressRailwayProductData data, String record, String agentCode, List<Message> messages, boolean registration) {
            TransportationType transportationType;
            BigDecimal tariffAmount = null;
            BigDecimal tariffVatAmount = null;
            BigDecimal tariffVatRate = null;
            BigDecimal serviceAmount = null;
            BigDecimal serviceVatAmount = null;
            BigDecimal serviceVatRate = null;
            BigDecimal totalAmount = null;
            BigDecimal totalVatAmount = null;
            ArrayList<ExpressHelper.FopData> fopDatas = new ArrayList<ExpressHelper.FopData>();
            ArrayList<ExpressHelper.TaxData> taxDatas = new ArrayList<ExpressHelper.TaxData>();
            String currency = DictHelper.getCurrencyByAnyCode((String)"RUB");
            if (Pattern.compile(this.getPatterns().get(0)).matcher(record).find()) {
                BigDecimal insuranceTaxAmount = null;
                String[] entries = record.split("[\\s();]+");
                for (int i = 0; i < entries.length; ++i) {
                    if (Pattern.compile("^(\u041d|\u04121|\u04123|\u04125|\u04127|\u041213)\\-.+$").matcher(entries[i].trim()).find()) {
                        PaymentType paymentType = null;
                        PassengerStatus passengerStatus = null;
                        BigDecimal amount = null;
                        String[] values = entries[i].trim().split("-");
                        if (values.length > 0) {
                            String paymentTypeCode = values[0].trim();
                            paymentType = ExpressHelper.getPaymentType(paymentTypeCode);
                            passengerStatus = ExpressHelper.getPassengerStatus(paymentTypeCode);
                            if (paymentType == null) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductFopPaymentTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_paymentTypeWithCodeNotSupported, (Object[])new Object[]{paymentTypeCode}), (Object[])new Object[0]));
                            }
                        }
                        if (values.length > 1) {
                            try {
                                amount = new BigDecimal(values[1].trim());
                            }
                            catch (NumberFormatException e) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductFopAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                        }
                        if (paymentType == null || amount == null) continue;
                        ExpressHelper.FopData fopData = new ExpressHelper.FopData();
                        fopData.setPaymentType(paymentType);
                        fopData.setAmount(amount);
                        fopData.setPassengerStatus(passengerStatus);
                        fopDatas.add(fopData);
                        totalAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount, totalAmount});
                        continue;
                    }
                    if (Pattern.compile("^\u0422\\.\u0427\\.\u0421\u0422\u0420\\.").matcher(entries[i].trim()).find()) {
                        String[] values = entries[i].trim().split(";");
                        String insuranceTaxFareString = values[0].trim();
                        if (insuranceTaxFareString.length() <= 8) continue;
                        try {
                            insuranceTaxAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{new BigDecimal(insuranceTaxFareString.substring(8)), insuranceTaxAmount});
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductTaxAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        continue;
                    }
                    if (Pattern.compile("^\u0422\u0410\u0420\u0418\u0424$").matcher(entries[i].trim()).find() && i + 1 < entries.length && Pattern.compile("^\u0420\u0424(\\+\u041a\u0421\u0411)*$").matcher(entries[i + 1].trim()).find()) {
                        if (i + 2 >= entries.length) continue;
                        try {
                            tariffAmount = new BigDecimal(entries[i + 2].trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductTariffAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        continue;
                    }
                    if (Pattern.compile("^\u0421\u0415\u0420\u0412\u0418\u0421$").matcher(entries[i].trim()).find()) {
                        if (i + 1 >= entries.length) continue;
                        try {
                            serviceAmount = new BigDecimal(entries[i + 1].trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductServiceAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        continue;
                    }
                    if (!Pattern.compile("^\u041d\u0414\u0421$").matcher(entries[i].trim()).find() || i + 1 >= entries.length || !Pattern.compile("^\\d+%$").matcher(entries[i + 1].trim()).find() || i + 2 >= entries.length || !Pattern.compile("^\\d+\\.\\d{2}$").matcher(entries[i + 2].trim()).find()) continue;
                    Object vatRate = null;
                    try {
                        vatRate = new BigDecimal(entries[i + 1].trim().replaceAll("%", ""));
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductVatRateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (vatRate == null) continue;
                    if (BigDecimal.valueOf(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)data.getIssueDate())).compareTo((BigDecimal)vatRate) == 0) {
                        try {
                            tariffVatAmount = new BigDecimal(entries[i + 2].trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductTariffVatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        continue;
                    }
                    if (BigDecimal.valueOf(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)data.getIssueDate())).compareTo((BigDecimal)vatRate) != 0) continue;
                    try {
                        serviceVatAmount = new BigDecimal(entries[i + 2].trim());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_railwayProductServiceVatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
                if (insuranceTaxAmount != null) {
                    ExpressHelper.TaxData taxData = new ExpressHelper.TaxData();
                    taxData.setCode("\u0421\u0422\u0420");
                    taxData.setAmount(insuranceTaxAmount);
                    taxDatas.add(taxData);
                }
            }
            if ((transportationType = RailwayProductHelper.getTransportationType(data.getSegments())) == TransportationType.DOMESTIC) {
                tariffVatRate = BigDecimal.valueOf(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)data.getIssueDate()));
                if (tariffAmount != null && tariffVatRate != null) {
                    tariffVatAmount = MiscUtil.scale((BigDecimal)BigDecimal.valueOf(tariffAmount.doubleValue() / (100.0 + tariffVatRate.doubleValue()) * tariffVatRate.doubleValue()), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                } else if (tariffVatAmount != null && tariffVatRate != null && tariffVatRate.compareTo(BigDecimal.ZERO) != 0) {
                    tariffAmount = MiscUtil.scale((BigDecimal)MiscUtil.round((BigDecimal)BigDecimal.valueOf(tariffVatAmount.doubleValue() * ((100.0 + tariffVatRate.doubleValue()) / tariffVatRate.doubleValue())), (RoundingMode)RoundingMode.HALF_UP, (BigDecimal)BigDecimal.valueOf(0.1)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                }
                serviceVatRate = BigDecimal.valueOf(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)data.getIssueDate()));
                if (serviceAmount != null && serviceVatRate != null) {
                    serviceVatAmount = MiscUtil.scale((BigDecimal)BigDecimal.valueOf(serviceAmount.doubleValue() / (100.0 + serviceVatRate.doubleValue()) * serviceVatRate.doubleValue()), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                } else if (serviceVatAmount != null && serviceVatRate != null && serviceVatRate.compareTo(BigDecimal.ZERO) != 0) {
                    serviceAmount = MiscUtil.scale((BigDecimal)MiscUtil.round((BigDecimal)BigDecimal.valueOf(serviceVatAmount.doubleValue() * ((100.0 + serviceVatRate.doubleValue()) / serviceVatRate.doubleValue())), (RoundingMode)RoundingMode.HALF_UP, (BigDecimal)BigDecimal.valueOf(0.1)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                }
            }
            if (totalAmount != null) {
                if (tariffAmount == null) {
                    tariffAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalAmount, MiscUtil.negate(serviceAmount)});
                }
                if (serviceAmount == null) {
                    serviceAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalAmount, MiscUtil.negate((BigDecimal)tariffAmount)});
                }
            }
            totalVatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tariffVatAmount, serviceVatAmount});
            VatDetalization vatDetalization = new VatDetalization();
            if (tariffAmount != null && tariffAmount.compareTo(BigDecimal.ZERO) != 0 || tariffVatAmount != null && tariffVatAmount.compareTo(BigDecimal.ZERO) != 0 || serviceAmount != null && serviceAmount.compareTo(BigDecimal.ZERO) != 0 || serviceVatAmount != null && serviceVatAmount.compareTo(BigDecimal.ZERO) != 0) {
                vatDetalization.setDetalized(true);
                vatDetalization.getComponents().clear();
                if (tariffAmount != null && tariffAmount.compareTo(BigDecimal.ZERO) != 0 || tariffVatAmount != null && tariffVatAmount.compareTo(BigDecimal.ZERO) != 0) {
                    VatComponent vatComponent = new VatComponent();
                    vatComponent.setBasis(tariffAmount);
                    vatComponent.setSum(tariffVatAmount);
                    vatComponent.setRate(tariffVatRate != null ? Double.valueOf(tariffVatRate.doubleValue()) : null);
                    vatComponent.getBasisTypes().clear();
                    vatComponent.getBasisTypes().add(VatBasisType.FARE);
                    vatDetalization.getComponents().add(vatComponent);
                }
                if (serviceAmount != null && serviceAmount.compareTo(BigDecimal.ZERO) != 0 || serviceVatAmount != null && serviceVatAmount.compareTo(BigDecimal.ZERO) != 0) {
                    VatComponent vatComponent = new VatComponent();
                    vatComponent.setBasis(serviceAmount);
                    vatComponent.setSum(serviceVatAmount);
                    vatComponent.setRate(serviceVatRate != null ? Double.valueOf(serviceVatRate.doubleValue()) : null);
                    vatComponent.getBasisTypes().clear();
                    vatComponent.getBasisTypes().add(VatBasisType.SERVICE);
                    vatDetalization.getComponents().add(vatComponent);
                }
            }
            ArrayList<RailwayTax> taxes = new ArrayList<RailwayTax>();
            for (ExpressHelper.TaxData taxData : taxDatas) {
                RailwayTax tax = new RailwayTax();
                tax.setCode(taxData.getCode());
                Money money = new Money();
                money.setValue(taxData.getAmount());
                money.setCurrency(currency);
                tax.setFare(money);
                tax.setEquivalentFare(taxData.getAmount());
                taxes.add(tax);
            }
            ArrayList<RailwayProductFop> fops = new ArrayList<RailwayProductFop>();
            for (ExpressHelper.FopData fopData : fopDatas) {
                RailwayProductFop fop = new RailwayProductFop();
                fop.setType(fopData.getPaymentType());
                Money money = new Money();
                money.setValue(fopData.getAmount());
                money.setCurrency(currency);
                fop.setAmount(money);
                fop.setPassengerStatus(fopData.getPassengerStatus());
                fops.add(fop);
            }
            data.setTariffAmount(tariffAmount);
            data.setTariffVatAmount(tariffVatAmount);
            data.setTariffVatRate(tariffVatRate);
            data.setServiceAmount(serviceAmount);
            data.setServiceVatAmount(serviceVatAmount);
            data.setServiceVatRate(serviceVatRate);
            data.setTotalAmount(totalAmount);
            data.setTotalVatAmount(totalVatAmount);
            data.setVatDetalization(vatDetalization);
            data.getTaxes().clear();
            data.getTaxes().addAll(taxes);
            data.getFops().clear();
            data.getFops().addAll(fops);
        }
    }
    ,
    TARIFF_VOID{

        @Override
        public ExpressHelper.RecordType getRecordType() {
            return ExpressHelper.RecordType.TARIFF_VOID;
        }

        @Override
        public boolean isMultiline() {
            return true;
        }

        @Override
        public double getPriority() {
            return 7.0;
        }

        @Override
        public List<String> getPatterns() {
            return Arrays.asList("^.*\u041f\u041e\u0413\u0410\u0428\u0415\u041d\u041e\\s+\\D+-\\d+\\.\\d{1}\\s+.+$");
        }

        @Override
        public void parse(ExpressRailwayProductData data, String record, String agentCode, List<Message> messages, boolean registration) {
        }
    };

}

