/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.parsers2.inmob.InmobData;
import com.gridnine.xtrip.server.parsers2.inmob.InmobHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayMcoProductData;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InmobParseRailwayMcoProductCommonDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Document document = (Document)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_ENTRY);
        InmobRailwayMcoProductData data = (InmobRailwayMcoProductData)((Object)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA));
        data.setContent(XUtil.toString((Document)document, (String)"utf-8"));
        this.parse(ctx, data, document);
    }

    private void parse(MessageContext context, InmobRailwayMcoProductData data, Document document) throws Exception {
        String railwayMcoNumber;
        String crDate = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/CreateDateTime");
        Date issueDate = null;
        if (!TextUtil.isBlank((String)crDate)) {
            try {
                issueDate = InmobHelper.getDateFormat().parse(crDate.trim());
            }
            catch (ParseException e) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayIssueDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedIssueDate, (Object[])new Object[]{crDate}), (Object[])new Object[0]));
            }
        }
        railwayMcoNumber = !TextUtil.isBlank((String)(railwayMcoNumber = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemBlanks/VoucherNumber"))) ? railwayMcoNumber.trim() : null;
        String relatedSystemNumber = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemBlanks/BlankNumber");
        relatedSystemNumber = !TextUtil.isBlank((String)relatedSystemNumber) ? relatedSystemNumber.trim() : null;
        DictionaryReference blankType = ParsersHelper.getBlankType((String)"\u0420\u0416\u0414 \u041a\u0420\u0421 \u042d\u0411");
        String pnr = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OrderId");
        pnr = TextUtil.nonBlank((String)pnr) ? pnr.trim() : null;
        String oldPnr = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/ReservationNumber");
        oldPnr = TextUtil.nonBlank((String)oldPnr) ? oldPnr.trim() : null;
        String firstName = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/FirstName");
        firstName = !TextUtil.isBlank((String)firstName) ? firstName.trim() : null;
        String middleName = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/MiddleName");
        middleName = !TextUtil.isBlank((String)middleName) ? middleName.trim() : null;
        String lastName = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/LastName");
        lastName = !TextUtil.isBlank((String)lastName) ? lastName.trim() : null;
        Traveller traveller = new Traveller();
        String fullName = InmobRailwayHelper.buildFullName(lastName, firstName, middleName);
        traveller.setName(fullName);
        if (TextUtil.isCyrillic((String)fullName, (boolean)true)) {
            traveller.setCyrillicName(fullName);
        }
        InmobData.TravellerData travellerData = new InmobData.TravellerData();
        travellerData.setTraveller(traveller);
        data.setStatus(ProductStatus.SELL);
        data.setIssueDate(issueDate);
        data.setSystemNumber(railwayMcoNumber);
        data.setTicketType(TicketType.OWN);
        data.setBlankType((DictionaryReference<BlankType>)blankType);
        data.setRelatedSystemNumber(relatedSystemNumber);
        data.getTravellers().add(travellerData);
        data.setTransactionType(TransactionType.SELL);
        data.setProductType(ProductType.RAILWAY_REFERENCE_MCO);
        data.setPnr(pnr);
        data.setOldPnr(oldPnr);
    }
}

