/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.model.helpers.CommonRailwayHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDictionaryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.parsers2.inmob.InmobData;
import com.gridnine.xtrip.server.parsers2.inmob.InmobHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.common.CommonRailwayParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayProductData;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InmobParseRailwayProductCommonDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Document document = (Document)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_ENTRY);
        InmobRailwayProductData data = (InmobRailwayProductData)((Object)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA));
        data.setContent(XUtil.toString((Document)document, (String)"utf-8"));
        this.parse(ctx, data, document);
    }

    private void parse(MessageContext context, InmobRailwayProductData data, Document document) throws Exception {
        String documentNumber;
        EntityReference bookingAgent;
        String pnr;
        Element[] seats;
        List listPlaces;
        String carriageNumber;
        Collection locations;
        Collection locations2;
        String currency = DictHelper.getCurrencyByAnyCode((String)"RUB");
        String depCode = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OriginLocationCode");
        String depShortName = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OriginStationName");
        String depName = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OriginLocationName");
        RailwayStationReference departureStation = null;
        if (TextUtil.nonBlank((String)depCode)) {
            Collection locations22 = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)depCode.trim());
            if (locations22 == null || locations22.isEmpty()) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_departureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_StationWithCodeNotFound, (Object[])new Object[]{depCode}), (Object[])new Object[0]));
            } else {
                departureStation = ((RailwayStation)locations22.iterator().next()).toReference();
            }
        }
        if (departureStation == null && TextUtil.nonBlank((String)depShortName)) {
            locations2 = RailwayProductDictionaryHelper.findStationsByShortName((String)depShortName.trim());
            if (locations2 == null || locations2.isEmpty()) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_departureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_StationWithShortNameNotFound, (Object[])new Object[]{depShortName}), (Object[])new Object[0]));
            } else {
                departureStation = ((RailwayStation)locations2.iterator().next()).toReference();
            }
        }
        if (departureStation == null && TextUtil.nonBlank((String)depName)) {
            locations2 = RailwayProductDictionaryHelper.findStationsByName((String)depName.trim());
            if (locations2 == null || locations2.isEmpty()) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_departureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_StationWithNameNotFound, (Object[])new Object[]{depName}), (Object[])new Object[0]));
            } else {
                departureStation = ((RailwayStation)locations2.iterator().next()).toReference();
            }
        }
        String arrCode = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/DestinationLocationCode");
        String arrShortName = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/DestinationStationName");
        String arrName = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/DestinationLocationName");
        RailwayStationReference arriveStation = null;
        if (TextUtil.nonBlank((String)arrCode)) {
            locations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)arrCode.trim());
            if (locations == null || locations.isEmpty()) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_arriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_StationWithCodeNotFound, (Object[])new Object[]{arrCode}), (Object[])new Object[0]));
            } else {
                arriveStation = ((RailwayStation)locations.iterator().next()).toReference();
            }
        }
        if (arriveStation == null && TextUtil.nonBlank((String)arrShortName)) {
            locations = RailwayProductDictionaryHelper.findStationsByShortName((String)arrShortName.trim());
            if (locations == null || locations.isEmpty()) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_arriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_StationWithShortNameNotFound, (Object[])new Object[]{arrShortName}), (Object[])new Object[0]));
            } else {
                arriveStation = ((RailwayStation)locations.iterator().next()).toReference();
            }
        }
        if (arriveStation == null && TextUtil.nonBlank((String)arrName)) {
            locations = RailwayProductDictionaryHelper.findStationsByTranslationOrSpellVariant((String)arrName.trim());
            if (locations == null || locations.isEmpty()) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_arriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_StationWithNameNotFound, (Object[])new Object[]{arrName}), (Object[])new Object[0]));
            } else {
                arriveStation = ((RailwayStation)locations.iterator().next()).toReference();
            }
        }
        String depDate = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/DepartureDateTime");
        Date departureDate = null;
        if (TextUtil.nonBlank((String)depDate)) {
            try {
                departureDate = InmobHelper.getDateFormat().parse(depDate.trim());
            }
            catch (ParseException e2) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayDepartureDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedDate, (Object[])new Object[]{depDate}), (Object[])new Object[0]));
            }
        }
        String arrDate = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/ArrivalDateTime");
        Date arrivalDate = null;
        if (TextUtil.nonBlank((String)arrDate)) {
            try {
                arrivalDate = InmobHelper.getDateFormat().parse(arrDate.trim());
            }
            catch (ParseException e3) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayArrivalDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedDate, (Object[])new Object[]{arrDate}), (Object[])new Object[0]));
            }
        }
        String localDepDate = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/LocalDepartureDateTime");
        Date localDepartureDate = null;
        if (TextUtil.nonBlank((String)localDepDate)) {
            try {
                localDepartureDate = InmobHelper.getDateFormat().parse(localDepDate.trim());
            }
            catch (ParseException e4) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayLocalDepartureDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedDate, (Object[])new Object[]{localDepDate}), (Object[])new Object[0]));
            }
        }
        String localArrDate = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/LocalArrivalDateTime");
        Date localArrivalDate = null;
        if (TextUtil.nonBlank((String)localArrDate)) {
            try {
                localArrivalDate = InmobHelper.getDateFormat().parse(localArrDate.trim());
            }
            catch (ParseException e5) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayLocalArrivalDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedDate, (Object[])new Object[]{localArrDate}), (Object[])new Object[0]));
            }
        }
        String crDate = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/CreateDateTime");
        Date issueDate = null;
        if (TextUtil.nonBlank((String)crDate)) {
            try {
                issueDate = InmobHelper.getDateFormat().parse(crDate.trim());
            }
            catch (ParseException e6) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayIssueDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedIssueDate, (Object[])new Object[]{crDate}), (Object[])new Object[0]));
            }
        }
        String ticketNumber = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemBlanks/BlankNumber");
        String carrierTin = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/CarrierTin");
        String carrier = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/Carrier");
        ticketNumber = TextUtil.nonBlank((String)ticketNumber) ? ticketNumber.trim() : null;
        String trainNumberWithSlot = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/TrainNumber");
        String trainNumber = null;
        String slot = null;
        if (TextUtil.nonBlank((String)trainNumberWithSlot)) {
            MiscUtil.Pair<String, String> trainNumberAndSlot = InmobRailwayHelper.parseTrainNumber(trainNumberWithSlot);
            if (trainNumberAndSlot != null) {
                trainNumber = (String)trainNumberAndSlot.getFirst();
                slot = (String)trainNumberAndSlot.getSecond();
            } else {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_trainNumberDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_unsupportedTrainNumber, (Object[])new Object[]{trainNumberAndSlot}), (Object[])new Object[0]));
            }
        }
        carriageNumber = TextUtil.nonBlank((String)(carriageNumber = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/CarNumber"))) ? carriageNumber.trim() : null;
        String carType = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/CarType");
        CarriageType carriageType = null;
        if (TextUtil.nonBlank((String)carType) && (carriageType = InmobRailwayHelper.getCarriageType(carType)) == null) {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_carriageTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_unsupportedCarriageType, (Object[])new Object[]{carType}), (Object[])new Object[0]));
        }
        String serClass = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/ServiceClass");
        ServiceClass serviceClass = null;
        if (TextUtil.nonBlank((String)serClass) && (serviceClass = InmobRailwayHelper.getServiceClass(serClass)) == null) {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_serviceClassDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_unsupportedServiceClass, (Object[])new Object[]{serClass}), (Object[])new Object[0]));
        }
        if ((listPlaces = Arrays.stream(seats = XmlUtil.getElements((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemCustomers/PlacesWithType")).filter(Objects::nonNull).map(e -> XmlUtil.getValue((Element)e, (String)"Number")).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty() && seats.length > 0) {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_placesDefineFailed, (Object[])new Object[0]));
        }
        pnr = TextUtil.nonBlank((String)(pnr = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OrderId"))) ? pnr.trim() : null;
        String oldPnr = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/ReservationNumber");
        oldPnr = TextUtil.nonBlank((String)oldPnr) ? oldPnr.trim() : null;
        String bookingAgentCode = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"PosSysName");
        bookingAgentCode = TextUtil.nonBlank((String)bookingAgentCode) ? bookingAgentCode.trim() : null;
        String agentCode = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/PosSysName");
        agentCode = TextUtil.nonBlank((String)agentCode) ? agentCode.trim() : null;
        String providerPaymentForm = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/ProviderPaymentForm");
        PaymentType paymentType = null;
        if (TextUtil.nonBlank((String)providerPaymentForm) && (paymentType = InmobHelper.getPaymentType((String)providerPaymentForm)) == null) {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayPaymentTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedPaymentType, (Object[])new Object[]{providerPaymentForm}), (Object[])new Object[0]));
        }
        GdsName gdsName = InmobRailwayHelper.gdsName;
        RecordLocatorType type = InmobRailwayHelper.recordLocatorType;
        BigDecimal totalAmount = null;
        BigDecimal serviceAmount = null;
        BigDecimal serviceVatAmount = null;
        BigDecimal segmentFare = null;
        BigDecimal reservedSeatPrice = null;
        String amount = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemBlanks/Amount");
        if (TextUtil.nonBlank((String)amount)) {
            try {
                totalAmount = new BigDecimal(amount);
            }
            catch (NumberFormatException e7) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedAmount, (Object[])new Object[]{amount}), (Object[])new Object[0]));
            }
        }
        ArrayList<VatComponent> vatComponents = new ArrayList<VatComponent>();
        if (this.isFareComponentsPresent(document)) {
            VatAmount vatAmount;
            BigDecimal fareVat;
            boolean tariffVatApplicable;
            for (Element reservedSeatElement : this.getFareComponentsByName(document, "\u0422\u0410\u0420\u0418\u0424 \u041f\u041b\u0410\u0426\u041a\u0410\u0420\u0422\u042b")) {
                String resSeatPrice = XmlUtil.getValue((Element)reservedSeatElement, (String)"ComponentCost");
                if (!TextUtil.nonBlank((String)resSeatPrice)) continue;
                try {
                    reservedSeatPrice = MiscUtil.sum((BigDecimal[])new BigDecimal[]{reservedSeatPrice, new BigDecimal(resSeatPrice)});
                }
                catch (NumberFormatException e8) {
                    context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_priceDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_unsupportedPrice, (Object[])new Object[]{resSeatPrice}), (Object[])new Object[0]));
                }
                tariffVatApplicable = this.isVatApplicable(reservedSeatElement);
                String string = XmlUtil.getValue((Element)reservedSeatElement, (String)"Vat");
                try {
                    fareVat = TextUtil.nonBlank((String)string) ? new BigDecimal(string) : null;
                    vatAmount = VatAmount.of((BigDecimal)new BigDecimal(resSeatPrice), (BigDecimal)this.convertVatAmount(fareVat, tariffVatApplicable));
                    InmobRailwayHelper.addVatComponent(vatComponents, vatAmount, VatBasisType.FARE);
                }
                catch (NumberFormatException e9) {
                    context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.InmobExchangeProcessor_invalidVat, (Throwable)e9, (Object[])new Object[]{string}));
                }
            }
            if (reservedSeatPrice == null) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_priceDefineFailed, (Object[])new Object[0]));
            }
            for (Element segmentFareElement : this.getFareComponentsByName(document, "\u0422\u0410\u0420\u0418\u0424 \u0411\u0418\u041b\u0415\u0422\u0410")) {
                String segmentFarePrice = XmlUtil.getValue((Element)segmentFareElement, (String)"ComponentCost");
                if (!TextUtil.nonBlank((String)segmentFarePrice)) continue;
                try {
                    segmentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{segmentFare, new BigDecimal(segmentFarePrice)});
                }
                catch (NumberFormatException e10) {
                    context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_priceDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_unsupportedPrice, (Object[])new Object[]{segmentFarePrice}), (Object[])new Object[0]));
                }
                tariffVatApplicable = this.isVatApplicable(segmentFareElement);
                String string = XmlUtil.getValue((Element)segmentFareElement, (String)"Vat");
                try {
                    fareVat = TextUtil.nonBlank((String)string) ? new BigDecimal(string) : null;
                    vatAmount = VatAmount.of((BigDecimal)new BigDecimal(segmentFarePrice), (BigDecimal)this.convertVatAmount(fareVat, tariffVatApplicable));
                    InmobRailwayHelper.addVatComponent(vatComponents, vatAmount, VatBasisType.FARE);
                }
                catch (NumberFormatException e11) {
                    context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.InmobExchangeProcessor_invalidVat, (Throwable)e11, (Object[])new Object[]{string}));
                }
            }
            if (segmentFare == null) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_priceDefineFailed, (Object[])new Object[0]));
            }
            for (Element serviceElement : this.getFareComponentsByName(document, "\u0421\u0415\u0420\u0412\u0418\u0421")) {
                String servicePrice = XmlUtil.getValue((Element)serviceElement, (String)"ComponentCost");
                if (!TextUtil.nonBlank((String)servicePrice)) continue;
                try {
                    serviceAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{serviceAmount, new BigDecimal(servicePrice)});
                }
                catch (NumberFormatException e12) {
                    context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_serviceAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_unsupportedServiceAmount, (Object[])new Object[]{servicePrice}), (Object[])new Object[0]));
                }
                boolean serviceVatApplicable = this.isVatApplicable(serviceElement);
                String string = XmlUtil.getValue((Element)serviceElement, (String)"Vat");
                try {
                    BigDecimal serviceVat = TextUtil.nonBlank((String)string) ? new BigDecimal(string) : null;
                    serviceVatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{serviceVatAmount, serviceVat});
                    vatAmount = VatAmount.of((BigDecimal)new BigDecimal(servicePrice), (BigDecimal)this.convertVatAmount(serviceVat, serviceVatApplicable));
                    InmobRailwayHelper.addVatComponent(vatComponents, vatAmount, VatBasisType.SERVICE);
                }
                catch (NumberFormatException e13) {
                    context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.InmobExchangeProcessor_invalidVat, (Throwable)e13, (Object[])new Object[]{string}));
                }
            }
            if (serviceAmount == null) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_serviceAmountDefineFailed, (Object[])new Object[0]));
            }
            for (Element penaltyElement : this.getFareComponentsByName(document, "\u0421\u0411\u041e\u0420 \u0417\u0410 \u0412\u041e\u0417\u0412\u0420\u0410\u0422")) {
                boolean penaltyVatApplicable = this.isVatApplicable(penaltyElement);
                String componentCostStr = XmlUtil.getValue((Element)penaltyElement, (String)"ComponentCost");
                String string = XmlUtil.getValue((Element)penaltyElement, (String)"Vat");
                if (!TextUtil.nonBlank((String)componentCostStr)) continue;
                try {
                    BigDecimal penaltyVat = TextUtil.nonBlank((String)string) ? new BigDecimal(string) : null;
                    vatAmount = VatAmount.of((BigDecimal)new BigDecimal(componentCostStr), (BigDecimal)this.convertVatAmount(penaltyVat, penaltyVatApplicable));
                    InmobRailwayHelper.addVatComponent(vatComponents, vatAmount, VatBasisType.PENALTY);
                }
                catch (NumberFormatException e14) {
                    context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.InmobExchangeProcessor_invalidVat, (Throwable)e14, (Object[])new Object[]{string}));
                }
            }
        } else {
            String additionalPrice;
            String resSeatPrice = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemBlanks/BaseFare");
            if (TextUtil.nonBlank((String)resSeatPrice)) {
                try {
                    reservedSeatPrice = new BigDecimal(resSeatPrice);
                }
                catch (NumberFormatException e15) {
                    context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_priceDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_unsupportedPrice, (Object[])new Object[]{resSeatPrice}), (Object[])new Object[0]));
                }
            }
            if (TextUtil.nonBlank((String)(additionalPrice = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemBlanks/AdditionalPrice")))) {
                try {
                    segmentFare = new BigDecimal(additionalPrice);
                }
                catch (NumberFormatException e16) {
                    context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_priceDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_unsupportedPrice, (Object[])new Object[]{additionalPrice}), (Object[])new Object[0]));
                }
            }
            HashMap<Double, BigDecimal> vatValues = new HashMap<Double, BigDecimal>();
            for (Element vatRateElement : XmlUtil.getElements((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemBlanks/VatRateValues")) {
                String rateString = XmlUtil.getValue((Element)vatRateElement, (String)"Rate");
                String valueString = XmlUtil.getValue((Element)vatRateElement, (String)"Value");
                try {
                    double rate = Double.parseDouble(rateString);
                    BigDecimal value = new BigDecimal(valueString);
                    vatValues.merge(rate, value, BigDecimal::add);
                }
                catch (Exception e17) {
                    context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.InmobExchangeProcessor_invalidVatComponent, (Throwable)e17, (Object[])new Object[]{valueString, rateString}));
                }
            }
            for (Map.Entry entry : vatValues.entrySet()) {
                Double rate = (Double)entry.getKey();
                BigDecimal value = (BigDecimal)entry.getValue();
                if (rate == 0.0) continue;
                BigDecimal basis = value.multiply(new BigDecimal(100.0 + rate)).divide(new BigDecimal(rate), 2, 4);
                serviceAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{serviceAmount, basis});
                serviceVatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{serviceVatAmount, value});
            }
        }
        ArrayList messages = new ArrayList();
        ParsersHelper.SalesContextData salesContextData = ParsersHelper.getSalesContextData((String)CommonRailwayParsersHelper.getBlankOwnerCode(gdsName), null, null, (String)agentCode, null, null, (GdsName)gdsName, (Date)issueDate, messages);
        EntityReference blankOwner = salesContextData.getBlankOwner();
        EntityReference provider = salesContextData.getProvider();
        EntityReference entityReference = (EntityReference)MiscUtil.guarded((Object)CommonRailwayHelper.getSupplier((GdsName)gdsName), (Object)InmobHelper.getOrganizationByCode((String)"\u0418\u041c"));
        EntityReference agency = salesContextData.getAgency();
        EntityReference subagency = salesContextData.getSubagency();
        EntityReference salesPoint = salesContextData.getSalesPoint();
        EntityReference agent = salesContextData.getAgent();
        List bookingAgents = ProfileDao.getGdsReferenceIndexes((GdsName)GdsName.INMOB, (EntityReference)agency, null, (String)bookingAgentCode, (Date)issueDate).stream().map(GdsReferenceIndex::getSource).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (bookingAgents.isEmpty()) {
            context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.InmobExchangeProcessor_BookingAgentNotFound, (Object[])new Object[]{bookingAgentCode}));
            bookingAgent = agent;
        } else {
            bookingAgent = (EntityReference)bookingAgents.get(0);
            if (bookingAgents.size() > 1) {
                context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.InmobExchangeProcessor_FewBookingAgentsFound, (Object[])new Object[]{bookingAgentCode}));
            }
        }
        String validatorCode = salesContextData.getValidatorCode();
        String pccCode = salesContextData.getPccCode();
        context.addMessages(messages);
        DictionaryReference blankType = ParsersHelper.getBlankType((String)"\u0420\u0416\u0414 \u042d\u0411");
        ReservedSeat reservedSeat = new ReservedSeat();
        reservedSeat.setFare(InmobHelper.getMoney((BigDecimal)reservedSeatPrice, (String)currency));
        reservedSeat.setEquivalentFare(reservedSeatPrice);
        reservedSeat.setEquivalentVAT(BigDecimal.ZERO);
        String electronicRegistrationSet = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemBlanks/IsElectronicRegistrationSet");
        boolean wasElectronicRegistrationPassed = false;
        if (TextUtil.nonBlank((String)electronicRegistrationSet)) {
            if ((electronicRegistrationSet = electronicRegistrationSet.trim()).equalsIgnoreCase("true")) {
                wasElectronicRegistrationPassed = true;
            } else if (!electronicRegistrationSet.equalsIgnoreCase("false")) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_electronicRegistrationSetDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_unsupportedElectronicRegistrationSet, (Object[])new Object[]{electronicRegistrationSet}), (Object[])new Object[0]));
            }
        }
        String blankStatus = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemBlanks/BlankStatus");
        boolean isElectronicRegistrationPossible = false;
        if (TextUtil.nonBlank((String)blankStatus)) {
            if ((blankStatus = blankStatus.trim()).equalsIgnoreCase("ElectronicRegistrationPresent")) {
                isElectronicRegistrationPossible = true;
            } else if (!blankStatus.equalsIgnoreCase("ElectronicRegistrationAbsent")) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_blankStatusDefineFailed, (String)L10nResourcesManager.getStr((String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_unsupportedBlankStatus, (Object[])new Object[]{blankStatus}), (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        String placeQuantity = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/PlaceQuantity");
        Integer travellersCount = null;
        if (TextUtil.nonBlank((String)placeQuantity)) {
            travellersCount = Integer.parseInt(placeQuantity);
        }
        Traveller traveller = new Traveller();
        String firstName = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/FirstName");
        firstName = TextUtil.nonBlank((String)firstName) ? firstName.trim() : null;
        String middleName = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/MiddleName");
        middleName = TextUtil.nonBlank((String)middleName) ? middleName.trim() : null;
        String lastName = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/LastName");
        lastName = TextUtil.nonBlank((String)lastName) ? lastName.trim() : null;
        String sex = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/Sex");
        Gender gender = null;
        if (TextUtil.nonBlank((String)sex) && (gender = InmobHelper.getGenderByCode((String)sex)) == null) {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayGenderDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedGender, (Object[])new Object[]{sex}), (Object[])new Object[0]));
        }
        String birthDate = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/BirthDate");
        Date birthday = null;
        if (TextUtil.nonBlank((String)birthDate)) {
            try {
                birthday = InmobHelper.getDateFormat().parse(birthDate.trim());
            }
            catch (ParseException e18) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayBirthdayDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedBirthdayDate, (Object[])new Object[]{birthDate}), (Object[])new Object[0]));
            }
        }
        documentNumber = TextUtil.nonBlank((String)(documentNumber = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/DocumentNumber"))) ? documentNumber.trim() : null;
        String documentValidTill = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/DocumentValidTill");
        Date docExpireDate = null;
        if (TextUtil.nonBlank((String)documentValidTill)) {
            try {
                docExpireDate = InmobHelper.getDateFormat().parse(documentValidTill.trim());
            }
            catch (ParseException e19) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayDocumentExpireDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedDocumentExpireDate, (Object[])new Object[]{documentValidTill}), (Object[])new Object[0]));
            }
        }
        String documentType = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/DocumentType");
        PassportType passportType = null;
        if (TextUtil.nonBlank((String)documentType) && (passportType = InmobHelper.getPassportType((String)documentType)) == null) {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayPassportTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedPassportType, (Object[])new Object[]{documentType}), (Object[])new Object[0]));
        }
        String citizenshipCode = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderCustomers/CitizenshipCode");
        DictionaryReference countryRef = null;
        if (TextUtil.nonBlank((String)citizenshipCode) && (countryRef = InmobHelper.getCountryRef((String)citizenshipCode)) == null) {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_railwayCitizenshipCodeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_railwayUnsupportedCitizenshipCode, (Object[])new Object[]{citizenshipCode}), (Object[])new Object[0]));
        }
        String passengerTypeCode = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemCustomers/Category");
        DictionaryReference<PassengerType> passengerType = null;
        if (TextUtil.nonBlank((String)passengerTypeCode) && (passengerType = InmobRailwayHelper.getPassengerType(passengerTypeCode)) == null) {
            context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.InmobExchangeProcessor_PassengerTypeNotFound, (Object[])new Object[]{passengerTypeCode}));
        }
        String fullName = InmobRailwayHelper.buildFullName(lastName, firstName, middleName);
        traveller.setName(fullName);
        if (TextUtil.isCyrillic((String)fullName, (boolean)true)) {
            traveller.setCyrillicName(fullName);
        }
        traveller.setGender(gender);
        traveller.setBirthday(birthday);
        Passport passport = new Passport();
        passport.setFirstName(firstName);
        passport.setMiddleName(middleName);
        passport.setLastName(lastName);
        passport.setBirthday(birthday);
        passport.setGender(gender);
        passport.setCitizenship(countryRef);
        passport.setExpired(docExpireDate);
        passport.setNumber(documentNumber);
        passport.setType(passportType);
        traveller.setPassport(passport);
        InmobData.TravellerData travellerData = new InmobData.TravellerData();
        travellerData.setTraveller(traveller);
        travellerData.setPassengerType(passengerType);
        data.setTravellersCount(travellersCount);
        data.getTravellers().add(travellerData);
        ArrayList<RailwayProductFop> fops = new ArrayList<RailwayProductFop>();
        if (totalAmount != null && currency != null) {
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(paymentType);
            Money money = InmobHelper.getMoney((BigDecimal)totalAmount, (String)currency);
            fop.setAmount(money);
            fop.setAgent(agent);
            fop.setOperationDate(issueDate);
            fops.add(fop);
        }
        RailwaySegment segment = new RailwaySegment();
        segment.setDepartureStation((DictionaryReference)departureStation);
        segment.setArriveStation((DictionaryReference)arriveStation);
        segment.setDepartureDate(departureDate);
        segment.setArriveDate(arrivalDate);
        segment.setLocalDepartureDate(localDepartureDate);
        segment.setLocalArriveDate(localArrivalDate);
        segment.setTrainNumber(trainNumber);
        segment.setSlot(slot);
        segment.setCarriageNumber(carriageNumber);
        segment.setCarriageType(carriageType);
        segment.setServiceClass(serviceClass);
        segment.setFare(InmobHelper.getMoney((BigDecimal)segmentFare, (String)currency));
        segment.getPlaces().addAll(listPlaces);
        segment.setERegEnabled(isElectronicRegistrationPossible);
        segment.setHasEReg(wasElectronicRegistrationPassed);
        segment.setEquivalentVAT(BigDecimal.ZERO);
        segment.setEquivalentFare(segmentFare);
        segment.setNumber(1);
        segment.setCarrier(InmobRailwayHelper.getCarrier(carrier, carrierTin, context));
        reservedSeat.setSegment(segment);
        data.setTicketType(TicketType.OWN);
        data.setGds(gdsName);
        data.setRecordLocatorType(type);
        data.getFops().clear();
        data.getFops().addAll(fops);
        data.setSystemNumber(ticketNumber);
        data.setCarrierTin(carrierTin);
        data.getSegments().add(segment);
        data.setIssueDate(issueDate);
        data.setPnr(pnr);
        data.setOldPnr(oldPnr);
        data.setBlankOwner((EntityReference<Organization>)blankOwner);
        data.setBlankType((DictionaryReference<BlankType>)blankType);
        data.setSubagency((EntityReference<Organization>)subagency);
        data.setAgency((EntityReference<Organization>)agency);
        data.setBookingAgent((EntityReference<Person>)bookingAgent);
        data.setAgent((EntityReference<Person>)agent);
        data.setSalesPoint((EntityReference<SalesPoint>)salesPoint);
        data.setSupplier((EntityReference<Organization>)entityReference);
        data.setValidatorCode(validatorCode);
        data.setPcc(pccCode);
        data.setProvider((EntityReference<Organization>)provider);
        data.setServiceAmount(serviceAmount);
        data.setServiceVatAmount(serviceVatAmount);
        data.setTotalAmount(totalAmount);
        data.getReservedSeats().add(reservedSeat);
        data.getVatComponents().clear();
        data.getVatComponents().addAll(vatComponents);
        data.setIssueDate(issueDate);
        data.setProductType(ProductType.RAILWAY_PRODUCT);
    }

    private boolean isFareComponentsPresent(Document document) {
        return this.getFareComponents(document).length > 0;
    }

    private List<Element> getFareComponentsByName(Document document, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : this.getFareComponents(document)) {
            String componentName = XmlUtil.getValue((Element)element, (String)"ComponentName");
            if (TextUtil.isBlank((String)componentName) || !(componentName = componentName.trim()).toUpperCase().startsWith(name)) continue;
            result.add(element);
        }
        return result;
    }

    private Element[] getFareComponents(Document document) {
        return XmlUtil.getElements((Element)document.getDocumentElement(), (String)"OrderItem/OrderItemBlanks/FareInfo/Components");
    }

    private boolean isVatApplicable(Element fareComponentElement) {
        String vatRateType = XmlUtil.getValue((Element)fareComponentElement, (String)"VatRateType");
        return CommonRailwayParsersHelper.isVatApplicable(vatRateType);
    }

    private BigDecimal convertVatAmount(BigDecimal vatAmount, Boolean vatApplicable) {
        return vatAmount != null ? vatAmount : (Boolean.FALSE.equals(vatApplicable) ? null : BigDecimal.ZERO);
    }
}

