/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayProductData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InmobParseRailwayProductRefundDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Document document = (Document)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_ENTRY);
        InmobRailwayProductData data = (InmobRailwayProductData)((Object)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA));
        this.parse(ctx, data, document);
    }

    private void parse(MessageContext context, InmobRailwayProductData data, Document document) throws Exception {
        data.setStatus(ProductStatus.REFUND);
        data.setTransactionType(TransactionType.REFUND);
        String reason = XmlUtil.getValue((Element)document.getDocumentElement(), (String)"OrderItem/OperationReason");
        if (TextUtil.nonBlank((String)reason)) {
            try {
                data.setOperationReason(InmobRailwayProductData.OperationReason.valueOf(reason));
            }
            catch (Exception e) {
                context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.InmobExchangeProcessor_unknownRefundType, (Object[])new Object[]{reason}));
            }
        }
    }
}

