/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InmobRailwayHelper {
    public static final String SUPPLIER_CODE = "\u0418\u041c";
    public static final String BLANK_TYPE_CODE = "\u0420\u0416\u0414 \u042d\u0411";
    public static final String MCO_BLANK_TYPE_CODE = "\u0420\u0416\u0414 \u041a\u0420\u0421 \u042d\u0411";
    public static final GdsName gdsName = GdsName.INMOB;
    public static final RecordLocatorType recordLocatorType = RecordLocatorType.DEFAULT;
    private static final Logger log = LoggerFactory.getLogger(InmobRailwayHelper.class);

    public static MiscUtil.Pair<String, String> parseTrainNumber(String number) {
        if (TextUtil.isBlank((String)number)) {
            return null;
        }
        String pattern = "^([\\d]+)([\\D]*)$";
        Matcher matcher = Pattern.compile(pattern).matcher(number.trim());
        if (matcher.matches()) {
            String trainNumber = matcher.group(1);
            String slot = matcher.group(2);
            return new MiscUtil.Pair((Object)trainNumber, (Object)slot);
        }
        return null;
    }

    public static List<String> parsePlaces(String places, MessageContext context) {
        ArrayList<String> result = new ArrayList<String>();
        for (String place : places.trim().split(",")) {
            if (place.contains("-")) {
                String[] values = place.split("-");
                if (values.length != 2) continue;
                String postfix = "";
                String startPlaceStr = values[0];
                String endPlaceStr = values[1];
                if (!endPlaceStr.matches("\\d+")) {
                    postfix = values[1].replaceAll("\\d", "");
                    startPlaceStr = values[0].replaceAll("\\D", "");
                    endPlaceStr = values[1].replaceAll("\\D", "");
                }
                Integer startPlace = null;
                Integer endPlace = null;
                try {
                    startPlace = Integer.valueOf(startPlaceStr.trim());
                    endPlace = Integer.valueOf(endPlaceStr.trim());
                }
                catch (NumberFormatException e) {
                    context.addMessage(MessageHelper.createWarningMessage((String)Messages.InmobExchangeProcessor_placesDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.InmobExchangeProcessor_errorOfParsingPlaces, (Object[])new Object[]{result}), (Object[])new Object[0]));
                }
                if (startPlace == null || endPlace == null || startPlace > endPlace) continue;
                for (int i = startPlace.intValue(); i <= endPlace; ++i) {
                    result.add(i + postfix);
                }
                continue;
            }
            result.add(place);
        }
        return result;
    }

    public static CarriageType getCarriageType(String string) {
        if (TextUtil.isBlank((String)string)) {
            return null;
        }
        if (TextUtil.isSame((String)string, (String)"Shared", (boolean)true)) {
            return CarriageType.O;
        }
        if (TextUtil.isSame((String)string, (String)"Soft", (boolean)true)) {
            return CarriageType.M;
        }
        if (TextUtil.isSame((String)string, (String)"Luxury", (boolean)true)) {
            return CarriageType.L;
        }
        if (TextUtil.isSame((String)string, (String)"Compartment", (boolean)true)) {
            return CarriageType.K;
        }
        if (TextUtil.isSame((String)string, (String)"ReservedSeat", (boolean)true)) {
            return CarriageType.P;
        }
        if (TextUtil.isSame((String)string, (String)"Sedentary", (boolean)true)) {
            return CarriageType.S;
        }
        return null;
    }

    public static ServiceClass getServiceClass(String serviceClassCode) {
        if (!TextUtil.isBlank((String)serviceClassCode)) {
            return RzdServiceConverter.getServiceClassByName(serviceClassCode);
        }
        return null;
    }

    public static DictionaryReference<PassengerType> getPassengerType(String string) {
        if (TextUtil.isBlank((String)string)) {
            return null;
        }
        if (TextUtil.isSame((String)string, (String)"Adult", (boolean)true)) {
            return DictHelper.getAdultPassengerType();
        }
        if (TextUtil.isSame((String)string, (String)"Child", (boolean)true)) {
            return DictHelper.getChildPassengerType();
        }
        if (TextUtil.isSame((String)string, (String)"BabyWithoutPlace", (boolean)true)) {
            return DictHelper.getInfantPassengerType();
        }
        return null;
    }

    public static void addVatComponent(List<VatComponent> vatComponents, VatAmount vatAmount, VatBasisType vatBasisType) {
        if (vatAmount == null) {
            return;
        }
        if (MiscUtil.isZero((BigDecimal)vatAmount.getTotal(), (boolean)true)) {
            return;
        }
        Double rate = vatAmount.getVat() != null ? Double.valueOf(Math.round(vatAmount.getVat())) : null;
        VatComponent vatComponent = vatComponents.stream().filter(vc -> vc.getBasisTypes().contains(vatBasisType)).filter(vc -> MiscUtil.equals((Object)vc.getRate(), (Object)rate)).findFirst().orElse(null);
        if (vatComponent == null) {
            vatComponent = new VatComponent();
            vatComponent.getBasisTypes().add(vatBasisType);
            vatComponent.setRate(rate);
            vatComponents.add(vatComponent);
        }
        vatComponent.setBasis(MiscUtil.sum((BigDecimal[])new BigDecimal[]{vatComponent.getBasis(), vatAmount.getTotal()}));
        vatComponent.setSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{vatComponent.getSum(), vatAmount.getVatAmount()}));
    }

    public static BigDecimal calcTotalVat(List<VatComponent> vatComponents, VatBasisType vatBasisType) {
        return vatComponents.stream().filter(vc -> vatBasisType == null || vc.getBasisTypes().contains(vatBasisType)).map(VatComponent::getSum).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(null);
    }

    public static String buildFullName(String lastName, String firstName, String middleName) {
        return String.join((CharSequence)" ", TextUtil.nonBlankStr((String)lastName), TextUtil.nonBlankStr((String)firstName), TextUtil.nonBlankStr((String)middleName)).trim();
    }

    public static DictionaryReference<RailwayCarrier> getCarrier(String code, String carrierInn, MessageContext ctx) {
        RailwayCarrier railwayCarrier;
        if (TextUtil.isBlank((String)code)) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u0434 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430", (Object[])new Object[0]));
            return null;
        }
        DictionaryReference carrier = new CodeTranslator(new String[]{CodeSystem.INMOB.name(), CodeSystem.EXPRESS.name()}).resolveNativeCode(RailwayCarrier.class, code, false, true);
        if (carrier == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a \u043f\u043e \u043a\u043e\u0434\u0443 {0}", (Object[])new Object[]{code}));
            return null;
        }
        if (!TextUtil.isBlank((String)carrierInn) && !carrierInn.equals((railwayCarrier = (RailwayCarrier)DictionaryCache.get().resolveReference(carrier)).getInn())) {
            try {
                railwayCarrier.setInn(carrierInn);
                railwayCarrier.setDataSource("Inmob-getCarrier");
                DictionaryStorage.get().save((BaseDictionary)railwayCarrier);
            }
            catch (Exception e) {
                log.error(String.format("can't save RailwayCarrier with inn %s for code %s", carrierInn, code), (Throwable)e);
            }
        }
        return carrier;
    }
}

