/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.server.parsers2.inmob.InmobData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class InmobRailwayProductData
extends InmobData {
    private ProductStatus status;
    private OperationReason operationReason;
    private EntityReference<Organization> client;
    private EntityReference<Organization> blankOwner;
    private EntityReference<Organization> supplier;
    private EntityReference<Organization> agency;
    private EntityReference<Organization> subagency;
    private EntityReference<Organization> provider;
    private EntityReference<SalesPoint> salesPoint;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Person> agent;
    private String validatorCode;
    private NestedEntityReference<SalesPoint, Validator> validator;
    private DictionaryReference<BlankType> blankType;
    private TicketType ticketType;
    private GdsName gds;
    private RecordLocatorType recordLocatorType;
    private String pnr;
    private String oldPnr;
    private String pcc;
    private String terminal;
    private BigDecimal totalAmount;
    private BigDecimal tariffAmount;
    private BigDecimal serviceAmount;
    private BigDecimal totalVatAmount;
    private BigDecimal tariffVatAmount;
    private BigDecimal serviceVatAmount;
    private String carrierTin;
    private final List<VatComponent> vatComponents = new ArrayList<VatComponent>();
    private final List<RailwaySegment> segments = new ArrayList<RailwaySegment>();
    private final List<ReservedSeat> reservedSeats = new ArrayList<ReservedSeat>();
    private final List<RailwayProductFop> fops = new ArrayList<RailwayProductFop>();

    public ProductStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProductStatus status) {
        this.status = status;
    }

    public OperationReason getOperationReason() {
        return this.operationReason;
    }

    public void setOperationReason(OperationReason operationReason) {
        this.operationReason = operationReason;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public void setClient(EntityReference<Organization> client) {
        this.client = client;
    }

    public EntityReference<Organization> getBlankOwner() {
        return this.blankOwner;
    }

    public void setBlankOwner(EntityReference<Organization> blankOwner) {
        this.blankOwner = blankOwner;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public void setSupplier(EntityReference<Organization> supplier) {
        this.supplier = supplier;
    }

    public EntityReference<Organization> getAgency() {
        return this.agency;
    }

    public void setAgency(EntityReference<Organization> agency) {
        this.agency = agency;
    }

    public EntityReference<Organization> getSubagency() {
        return this.subagency;
    }

    public void setSubagency(EntityReference<Organization> subagency) {
        this.subagency = subagency;
    }

    public EntityReference<SalesPoint> getSalesPoint() {
        return this.salesPoint;
    }

    public void setSalesPoint(EntityReference<SalesPoint> salesPoint) {
        this.salesPoint = salesPoint;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }

    public void setBookingAgent(EntityReference<Person> bookingAgent) {
        this.bookingAgent = bookingAgent;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public void setAgent(EntityReference<Person> agent) {
        this.agent = agent;
    }

    public String getValidatorCode() {
        return this.validatorCode;
    }

    public void setValidatorCode(String validatorCode) {
        this.validatorCode = validatorCode;
    }

    public DictionaryReference<BlankType> getBlankType() {
        return this.blankType;
    }

    public void setBlankType(DictionaryReference<BlankType> blankType) {
        this.blankType = blankType;
    }

    public TicketType getTicketType() {
        return this.ticketType;
    }

    public void setTicketType(TicketType ticketType) {
        this.ticketType = ticketType;
    }

    public GdsName getGds() {
        return this.gds;
    }

    public void setGds(GdsName gds) {
        this.gds = gds;
    }

    public RecordLocatorType getRecordLocatorType() {
        return this.recordLocatorType;
    }

    public void setRecordLocatorType(RecordLocatorType recordLocatorType) {
        this.recordLocatorType = recordLocatorType;
    }

    public String getPnr() {
        return this.pnr;
    }

    public void setPnr(String pnr) {
        this.pnr = pnr;
    }

    public String getOldPnr() {
        return this.oldPnr;
    }

    public void setOldPnr(String oldPnr) {
        this.oldPnr = oldPnr;
    }

    public String getPcc() {
        return this.pcc;
    }

    public void setPcc(String pcc) {
        this.pcc = pcc;
    }

    public String getTerminal() {
        return this.terminal;
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getTariffAmount() {
        return this.tariffAmount;
    }

    public void setTariffAmount(BigDecimal tariffAmount) {
        this.tariffAmount = tariffAmount;
    }

    public BigDecimal getServiceAmount() {
        return this.serviceAmount;
    }

    public void setServiceAmount(BigDecimal serviceAmount) {
        this.serviceAmount = serviceAmount;
    }

    public BigDecimal getTotalVatAmount() {
        return this.totalVatAmount;
    }

    public void setTotalVatAmount(BigDecimal totalVatAmount) {
        this.totalVatAmount = totalVatAmount;
    }

    public BigDecimal getTariffVatAmount() {
        return this.tariffVatAmount;
    }

    public void setTariffVatAmount(BigDecimal tariffVatAmount) {
        this.tariffVatAmount = tariffVatAmount;
    }

    public BigDecimal getServiceVatAmount() {
        return this.serviceVatAmount;
    }

    public void setServiceVatAmount(BigDecimal serviceVatAmount) {
        this.serviceVatAmount = serviceVatAmount;
    }

    public List<VatComponent> getVatComponents() {
        return this.vatComponents;
    }

    public List<RailwaySegment> getSegments() {
        return this.segments;
    }

    public List<ReservedSeat> getReservedSeats() {
        return this.reservedSeats;
    }

    public List<RailwayProductFop> getFops() {
        return this.fops;
    }

    public NestedEntityReference<SalesPoint, Validator> getValidator() {
        return this.validator;
    }

    public void setValidator(NestedEntityReference<SalesPoint, Validator> validator) {
        this.validator = validator;
    }

    public EntityReference<Organization> getProvider() {
        return this.provider;
    }

    public void setProvider(EntityReference<Organization> provider) {
        this.provider = provider;
    }

    public String getCarrierTin() {
        return this.carrierTin;
    }

    public void setCarrierTin(String carrierTin) {
        this.carrierTin = carrierTin;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("status -> ").append(this.status);
        stringBuilder.append("\n");
        stringBuilder.append("operationReason -> ").append((Object)this.operationReason);
        stringBuilder.append("\n");
        stringBuilder.append("client -> ").append(this.client);
        stringBuilder.append("\n");
        stringBuilder.append("blankOwner -> ").append(this.blankOwner);
        stringBuilder.append("\n");
        stringBuilder.append("supplier -> ").append(this.supplier);
        stringBuilder.append("\n");
        stringBuilder.append("agency -> ").append(this.agency);
        stringBuilder.append("\n");
        stringBuilder.append("subagency -> ").append(this.subagency);
        stringBuilder.append("\n");
        stringBuilder.append("salesPoint -> ").append(this.salesPoint);
        stringBuilder.append("\n");
        stringBuilder.append("agent -> ").append(this.agent);
        stringBuilder.append("\n");
        stringBuilder.append("blankType -> ").append(this.blankType);
        stringBuilder.append("\n");
        stringBuilder.append("gds -> ").append(this.gds);
        stringBuilder.append("\n");
        stringBuilder.append("pnr -> ").append(this.pnr);
        stringBuilder.append("\n");
        stringBuilder.append("oldPnr -> ").append(this.oldPnr);
        stringBuilder.append("\n");
        if (this.segments != null && !this.segments.isEmpty()) {
            stringBuilder.append("segments -> ");
            stringBuilder.append("\n");
            for (int i = 0; i < this.segments.size(); ++i) {
                RailwaySegment segment = this.segments.get(i);
                stringBuilder.append("\n\t");
                stringBuilder.append("number -> ").append(segment.getNumber());
                stringBuilder.append("\n\t");
                stringBuilder.append("departure station -> ").append(segment.getDepartureStation() != null ? segment.getDepartureStation().getCaption() : null);
                stringBuilder.append("\n\t");
                stringBuilder.append("arrive station -> ").append(segment.getArriveStation() != null ? segment.getArriveStation().getCaption() : null);
                stringBuilder.append("\n\t");
                stringBuilder.append("train number -> ").append(segment.getTrainNumber());
                stringBuilder.append("\n\t");
                stringBuilder.append("slot -> ").append(segment.getSlot());
                stringBuilder.append("\n\t");
                stringBuilder.append("carriage number -> ").append(segment.getCarriageNumber());
                stringBuilder.append("\n\t");
                stringBuilder.append("carriage type -> ").append(segment.getCarriageType() != null ? segment.getCarriageType().name() : null);
                stringBuilder.append("\n\t");
                stringBuilder.append("departure date -> ").append(segment.getDepartureDate());
                stringBuilder.append("\n\t");
                if (segment.getPlaces() != null && !segment.getPlaces().isEmpty()) {
                    stringBuilder.append("places -> ");
                    StringBuilder places = new StringBuilder();
                    for (String string : segment.getPlaces()) {
                        places.append(" ").append(string);
                    }
                    stringBuilder.append((CharSequence)places);
                    stringBuilder.append("\n\t");
                }
                stringBuilder.append("service class -> ").append(segment.getServiceClass());
                stringBuilder.append("\n\t");
                stringBuilder.append("fare -> ").append(segment.getFare() != null ? segment.getFare() : "?");
                stringBuilder.append("\n\t");
                if (this.reservedSeats == null || this.reservedSeats.size() <= i || this.reservedSeats.get(i) == null) continue;
                stringBuilder.append("reservedFare -> ").append(this.reservedSeats.get(i).getEquivalentFare());
                stringBuilder.append("\n\t");
            }
        }
        stringBuilder.append("tariffAmount -> ").append(this.tariffAmount != null ? this.tariffAmount.toString() : "?").append(" ").append("RUB");
        stringBuilder.append("\n");
        stringBuilder.append("serviceAmount -> ").append(this.serviceAmount != null ? this.serviceAmount.toString() : "?").append(" ").append("RUB");
        stringBuilder.append("\n");
        stringBuilder.append("totalAmount -> ").append(this.totalAmount != null ? this.totalAmount.toString() : "?").append(" ").append("RUB");
        stringBuilder.append("\n");
        stringBuilder.append("\n\n");
        stringBuilder.append("fops -> ");
        stringBuilder.append("\n");
        for (RailwayProductFop fop : this.fops) {
            stringBuilder.append("\n\t");
            stringBuilder.append("paymentType -> ").append(fop.getType());
            stringBuilder.append("\n\t");
            stringBuilder.append("equivalentAmount -> ").append(fop.getAmount() != null ? fop.getAmount() : "?");
            stringBuilder.append("\n\t");
            stringBuilder.append("agent -> ").append(fop.getAgent());
            stringBuilder.append("\n\t");
            stringBuilder.append("operationDate -> ").append(fop.getOperationDate());
            stringBuilder.append("\n");
        }
        if (this.fops.size() > 0) {
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static enum OperationReason {
        Voluntary,
        Forced,
        ByCarrierFault,
        ForcedWithCarrierFault;

    }
}

