/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayTestBase;
import com.gridnine.xtrip.server.railway.model.helpers.BookingDao;
import java.math.BigDecimal;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class InmobRailwayProductTest
extends InmobRailwayTestBase {
    @Test
    public void testSell() throws Exception {
        this.parseFile("testdata/railwaytest/inmob_online_20180305113547839.xml");
        RailwayProduct product = BookingDao.getProduct("71830835827451", ProductStatus.SELL);
        Assert.assertNotNull((Object)product);
        this.testBaseFields(product);
        Assert.assertNotNull((Object)product.getReservation());
        Assert.assertEquals((Object)MiscUtil.addSecondsToDate((Date)MiscUtil.addMinutesToDate((Date)MiscUtil.addHoursToDate((Date)MiscUtil.createDate((int)2018, (int)3, (int)5), (int)11), (int)33), (int)42), (Object)product.getReservation().getResDate());
        Assert.assertEquals((Object)MiscUtil.addSecondsToDate((Date)MiscUtil.addMinutesToDate((Date)MiscUtil.addHoursToDate((Date)MiscUtil.createDate((int)2018, (int)3, (int)5), (int)11), (int)33), (int)42), (Object)product.getReservation().getBookingFile().getCreateDate());
        Assert.assertEquals((Object)ProductStatus.SELL, (Object)product.getStatus());
        RailwaySegment segment = (RailwaySegment)product.getSegments().get(0);
        Assert.assertEquals((long)1L, (long)segment.getPlaces().size());
        Assert.assertEquals((Object)"007", segment.getPlaces().get(0));
        Assert.assertTrue((boolean)segment.isERegEnabled());
        Assert.assertTrue((boolean)segment.isHasEReg());
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.valueOf(1549.2), (Object)segment.getFare().getValue()));
        Assert.assertEquals((Object)"RUB", (Object)segment.getFare().getCurrency());
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.valueOf(1549.2), (Object)segment.getEquivalentFare()));
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.ZERO, (Object)segment.getEquivalentVAT()));
        ReservedSeat reservedSeat = (ReservedSeat)product.getReservedSeats().get(0);
        Assert.assertNotNull((Object)reservedSeat.getFare());
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.valueOf(1730.8), (Object)reservedSeat.getFare().getValue()));
        Assert.assertEquals((Object)"RUB", (Object)reservedSeat.getFare().getCurrency());
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.valueOf(1730.8), (Object)reservedSeat.getEquivalentFare()));
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.ZERO, (Object)reservedSeat.getEquivalentVAT()));
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.valueOf(2582L), (Object)product.getEquivalentFare()));
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.ZERO, (Object)product.getEquivalentVAT()));
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.valueOf(698L), (Object)product.getServiceFare()));
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.valueOf(106.47), (Object)product.getServiceVAT()));
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.valueOf(3280L), (Object)product.getTotalEquivalentFare()));
        Assert.assertTrue((boolean)MiscUtil.equals((Object)BigDecimal.valueOf(106.47), (Object)product.getTotalEquivalentVAT()));
    }

    @Test
    public void testRefundProduct() throws Exception {
        this.parseFile("testdata/railwaytest/inmob_online_20180307212151744.xml");
        RailwayProduct product = BookingDao.getProduct("71830835827451", ProductStatus.REFUND);
        Assert.assertNotNull((Object)product);
        this.testBaseFields(product);
        Assert.assertNotNull((Object)product.getReservation());
        Assert.assertEquals((Object)MiscUtil.addSecondsToDate((Date)MiscUtil.addMinutesToDate((Date)MiscUtil.addHoursToDate((Date)MiscUtil.createDate((int)2018, (int)3, (int)7), (int)21), (int)21), (int)49), (Object)product.getReservation().getResDate());
        Assert.assertEquals((Object)MiscUtil.addSecondsToDate((Date)MiscUtil.addMinutesToDate((Date)MiscUtil.addHoursToDate((Date)MiscUtil.createDate((int)2018, (int)3, (int)7), (int)21), (int)21), (int)49), (Object)product.getReservation().getBookingFile().getCreateDate());
        Assert.assertEquals((Object)ProductStatus.REFUND, (Object)product.getStatus());
        RailwaySegment segment = (RailwaySegment)product.getSegments().get(0);
        Assert.assertEquals((long)0L, (long)segment.getPlaces().size());
        Assert.assertFalse((boolean)segment.isERegEnabled());
        Assert.assertFalse((boolean)segment.isHasEReg());
        Assert.assertNotNull((Object)product.getPreviousProduct());
    }

    private void testBaseFields(RailwayProduct product) {
        Assert.assertNotNull((Object)product);
        Assert.assertNotNull((Object)product.getReservation());
        Reservation reservation = product.getReservation();
        Assert.assertTrue((boolean)CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)"5117223", (GdsName)GdsName.INMOB));
        Assert.assertEquals((Object)"71830835827451", (Object)product.getSystemNumber());
        Assert.assertEquals((Object)TicketType.OWN, (Object)product.getTicketType());
        Assert.assertEquals((Object)ServiceLocationType.DOMESTIC, (Object)product.getServiceLocationType());
        Assert.assertNotNull((Object)product.getBlankOwnerRef());
        Assert.assertEquals((Object)"\u0420\u0416\u0414", (Object)product.getBlankOwnerRef().getCaption());
        Assert.assertNotNull((Object)product.getBlankType());
        Assert.assertEquals((Object)"\u0420\u0416\u0414 \u042d\u0411", (Object)product.getBlankType().getCode());
        Assert.assertEquals((Object)"\u0420\u0416\u0414 \u042d\u0411", (Object)product.getBlankType().getCaption());
        Assert.assertEquals((long)1L, (long)product.getPassengers().size());
        Traveller traveller = (Traveller)product.getPassengers().get(0);
        Assert.assertEquals((Object)"\u041b\u043e\u0431\u0430\u0441\u0442\u043e\u0432 \u041a\u0438\u0440\u0438\u043b\u043b \u0412\u0438\u043a\u0442\u043e\u0440\u043e\u0432\u0438\u0447", (Object)traveller.getName());
        Assert.assertEquals((Object)Gender.MALE, (Object)traveller.getGender());
        Assert.assertEquals((Object)MiscUtil.createDate((int)1984, (int)6, (int)12), (Object)traveller.getBirthday());
        Assert.assertNotNull((Object)traveller.getPassport());
        Passport passport = traveller.getPassport();
        Assert.assertEquals((Object)"\u041b\u043e\u0431\u0430\u0441\u0442\u043e\u0432", (Object)passport.getLastName());
        Assert.assertEquals((Object)"\u041a\u0438\u0440\u0438\u043b\u043b", (Object)passport.getFirstName());
        Assert.assertEquals((Object)"\u0412\u0438\u043a\u0442\u043e\u0440\u043e\u0432\u0438\u0447", (Object)passport.getMiddleName());
        Assert.assertEquals((Object)MiscUtil.createDate((int)1984, (int)6, (int)12), (Object)passport.getBirthday());
        Assert.assertEquals((Object)DictHelper.getRuRef(), (Object)passport.getCitizenship());
        Assert.assertEquals((Object)"4511481993", (Object)passport.getNumber());
        Assert.assertEquals((Object)PassportType.INTERNAL, (Object)passport.getType());
        Assert.assertEquals((long)1L, (long)product.getSegments().size());
        RailwaySegment segment = (RailwaySegment)product.getSegments().get(0);
        Assert.assertEquals((long)1L, (long)segment.getNumber());
        Assert.assertNotNull((Object)segment.getDepartureStation());
        Assert.assertEquals((Object)"2014130", (Object)segment.getDepartureStation().getCode());
        Assert.assertNotNull((Object)segment.getArriveStation());
        Assert.assertEquals((Object)"2000005", (Object)segment.getArriveStation().getCode());
        Assert.assertEquals((Object)"029", (Object)segment.getTrainNumber());
        Assert.assertEquals((Object)"\u0412\u0410", (Object)segment.getSlot());
        Assert.assertEquals((Object)CarriageType.K, (Object)segment.getCarriageType());
        Assert.assertEquals((Object)ServiceClass.EE2, (Object)segment.getServiceClass());
        Assert.assertEquals((Object)MiscUtil.addMinutesToDate((Date)MiscUtil.addHoursToDate((Date)MiscUtil.createDate((int)2018, (int)3, (int)14), (int)20), (int)35), (Object)segment.getDepartureDate());
        Assert.assertEquals((Object)MiscUtil.addMinutesToDate((Date)MiscUtil.addHoursToDate((Date)MiscUtil.createDate((int)2018, (int)3, (int)15), (int)6), (int)15), (Object)segment.getArriveDate());
        Assert.assertNotNull((Object)segment.getFare());
        Assert.assertEquals((long)1L, (long)product.getReservedSeats().size());
        ReservedSeat reservedSeat = (ReservedSeat)product.getReservedSeats().get(0);
        Assert.assertEquals((Object)segment, (Object)reservedSeat.getSegment());
        Assert.assertNotNull((Object)reservedSeat.getFare());
        Assert.assertNotNull((Object)reservedSeat.getFare());
        Assert.assertEquals((Object)"URAL", (Object)product.getCarrier().getCode());
    }
}

