/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class InmobRailwaySearchBookingProductReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileContainer;
        BookingFile bookingFile;
        Reservation reservation;
        ProductSearchContext productSearchContext = (ProductSearchContext)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_CONTEXT);
        ProductSearchResult productSearchResult = (ProductSearchResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        List bookingFileContainers = Collections.emptyList();
        BaseProduct product = productSearchResult.getProduct();
        if (!TextUtil.isBlank((String)productSearchContext.getPnr())) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)productSearchContext.getPnr()));
            SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING);
            if (productSearchContext.getIssueDate() != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(productSearchContext.getIssueDate());
                cal.add(1, -2);
                Date lowerBound = cal.getTime();
                query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.issueDate.name(), (Object)lowerBound));
                query.getCriteria().getCriterions().add(SearchCriterion.le((String)BookingFileIndex.Property.issueDate.name(), (Object)productSearchContext.getIssueDate()));
            }
            if (productSearchContext.getAgency() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), (Object)productSearchContext.getAgency()), SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), null)}));
            }
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            if (productSearchContext.getClient() != null) {
                criterions.add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), (Object)productSearchContext.getClient()));
                criterions.add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), null));
            }
            criterions.addAll(productSearchContext.getPayers().stream().map(item -> SearchCriterion.contains((String)BookingFileIndex.Property.client.name(), (Object)item)).collect(Collectors.toList()));
            if (criterions.size() > 0) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
            }
            bookingFileContainers = EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(bf -> {
                Reservation res = BookingHelper.findReservation((BookingFile)((BookingFile)bf.getEntity()), (String)productSearchContext.getPnr());
                return res != null && (res.getProducts().isEmpty() || res.getProducts().stream().anyMatch(p -> ProductHandler.of((BaseProduct)p).getTicketType(p) != TicketType.CORRECTION));
            }).collect(Collectors.toList());
        }
        if (!bookingFileContainers.isEmpty() && product != null && (reservation = BookingHelper.findReservation((BookingFile)(bookingFile = (BookingFile)(bookingFileContainer = (EntityContainer)bookingFileContainers.get(0)).getEntity()), (String)productSearchContext.getPnr())) != null) {
            for (BaseProduct resProduct : reservation.getProducts()) {
                if (!(resProduct instanceof RailwayProduct) || !(product instanceof RailwayProduct)) continue;
                RailwayProduct resRailProduct = (RailwayProduct)resProduct;
                RailwayProduct searchRailProduct = (RailwayProduct)product;
                if (!MiscUtil.equals((Object)searchRailProduct.getPassengers(), (Object)resRailProduct.getPassengers()) || searchRailProduct.getStatus() != ProductStatus.SELL && searchRailProduct.getStatus() != ProductStatus.REFUND || resRailProduct.getStatus() != ProductStatus.BOOKING) continue;
                ctx.putObject((Enum)IBusParsersContextKeys.OLD_PRODUCT, (Object)resProduct);
            }
        }
    }
}

