/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.TravellerHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.parsers2.inmob.InmobData;
import com.gridnine.xtrip.server.railway.ibus.parsers.common.CommonRailwayParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayProductData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InmobUpdateRailwayCommonProductProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        InmobRailwayProductData data = (InmobRailwayProductData)((Object)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA));
        ProductSearchResult productSearchResult = (ProductSearchResult)context.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        if (this.log.isDebugEnabled()) {
            this.log.debug("inmob parse data -> \n\n" + (Object)((Object)data));
        }
        if (product.getStatus() != ProductStatus.SELL && product.getStatus() != ProductStatus.REFUND || product.getSystemNumber() == null || !productSearchResult.isExists() || !product.getPassengers().stream().anyMatch(p -> TravellerHelper.equals((Traveller)p, (Traveller)((InmobData.TravellerData)data.getTravellers().get(0)).getTraveller()))) {
            this.update(context, product, data);
        }
        if (product.getStatus() == ProductStatus.SELL) {
            product.getSegments().forEach(rs -> {
                RailwaySegment segment = data.getSegments().stream().filter(s -> rs.getNumber() == s.getNumber()).findFirst().orElse(null);
                if (segment != null) {
                    if (segment.getDepartureStation() != null) {
                        rs.setDepartureStation(segment.getDepartureStation());
                    }
                    if (segment.getArriveStation() != null) {
                        rs.setArriveStation(segment.getArriveStation());
                    }
                }
            });
        }
    }

    private void update(MessageContext context, RailwayProduct product, InmobRailwayProductData data) throws Exception {
        DictionaryReference passengerType;
        BookingFile bookingFile;
        if (data.getBlankOwner() == null) {
            data.setBlankOwner((EntityReference<Organization>)product.getBlankOwnerRef());
        }
        if (data.getSupplier() == null) {
            data.setSupplier((EntityReference<Organization>)RailwayProductHelper.getSupplier((BaseProduct)product));
        }
        if (data.getAgency() == null) {
            data.setAgency((EntityReference<Organization>)RailwayProductHelper.getAgency((RailwayProduct)product));
        }
        if (data.getSubagency() == null) {
            data.setSubagency((EntityReference<Organization>)RailwayProductHelper.getSubagency((RailwayProduct)product));
        }
        if (data.getSalesPoint() == null) {
            data.setSalesPoint((EntityReference<SalesPoint>)product.getSalesPoint());
        }
        if (data.getAgent() == null) {
            data.setAgent((EntityReference<Person>)product.getCashier());
        }
        if ((bookingFile = product.getReservation().getBookingFile()).getCustomerProfile() == null) {
            bookingFile.setCustomerProfile(data.getClient());
        }
        if (bookingFile.getAgency() == null) {
            bookingFile.setAgency(data.getAgency());
        }
        if (bookingFile.getCreateDate() == null) {
            bookingFile.setCreateDate(data.getIssueDate());
        }
        HashMap<Traveller, DictionaryReference> productTravellers = new HashMap<Traveller, DictionaryReference>();
        for (Object travellerData : data.getTravellers()) {
            Traveller traveller = travellerData.getTraveller();
            DictionaryReference passengerType2 = travellerData.getPassengerType();
            Traveller bookingFileTraveller = (Traveller)CollectionUtil.find((Collection)bookingFile.getTravellers(), (Object)traveller, TravellerHelper::equals);
            if (bookingFileTraveller != null) {
                if (bookingFileTraveller.getName() == null) {
                    bookingFileTraveller.setName(traveller.getName());
                }
                if (bookingFileTraveller.getCyrillicName() == null) {
                    bookingFileTraveller.setCyrillicName(traveller.getCyrillicName());
                }
                if (bookingFileTraveller.getPassport() != null) {
                    if (traveller.getPassport() != null) {
                        if (bookingFileTraveller.getPassport().getLastName() == null) {
                            bookingFileTraveller.getPassport().setLastName(traveller.getPassport().getLastName());
                        }
                        if (bookingFileTraveller.getPassport().getFirstName() == null) {
                            bookingFileTraveller.getPassport().setFirstName(traveller.getPassport().getFirstName());
                        }
                        if (bookingFileTraveller.getPassport().getMiddleName() == null) {
                            bookingFileTraveller.getPassport().setMiddleName(traveller.getPassport().getMiddleName());
                        }
                        if (bookingFileTraveller.getPassport().getType() == null) {
                            bookingFileTraveller.getPassport().setType(traveller.getPassport().getType());
                        }
                        if (bookingFileTraveller.getPassport().getNumber() == null) {
                            bookingFileTraveller.getPassport().setNumber(traveller.getPassport().getNumber());
                        }
                    }
                } else {
                    bookingFileTraveller.setPassport(traveller.getPassport());
                }
                productTravellers.put(bookingFileTraveller, passengerType2);
                continue;
            }
            bookingFile.getTravellers().add(traveller);
            productTravellers.put(traveller, passengerType2);
        }
        Reservation reservation = product.getReservation();
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)data.getGds(), (RecordLocatorType)data.getRecordLocatorType(), (String)data.getPnr());
        if (reservation.getSubagency() == null) {
            reservation.setSubagency(data.getSubagency());
        }
        if (reservation.getSalesPoint() == null) {
            reservation.setSalesPoint(data.getSalesPoint());
        }
        if (reservation.getBookingAgent() == null) {
            reservation.setBookingAgent(data.getBookingAgent());
        }
        product.setTicketType(data.getTicketType());
        if (product.getStatus() != ProductStatus.VOID) {
            product.setStatus(data.getStatus());
        }
        product.setBlankOwnerRef(data.getBlankOwner());
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, data.getSupplier());
        RailwayProductHelper.setAgency((BaseTicketProduct)product, data.getAgency());
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, data.getSubagency());
        product.setSalesPoint(data.getSalesPoint());
        product.setCashier(data.getAgent());
        product.setValidatorCode(data.getValidatorCode());
        product.setValidatorRef(data.getValidator());
        product.setBlankType(data.getBlankType());
        product.setIssueDate(data.getIssueDate());
        product.setSystemNumber(data.getSystemNumber());
        product.setEticket(true);
        product.setPcc(data.getPcc());
        product.setProvider(data.getProvider());
        product.setCarrier(CommonRailwayParsersHelper.getCarrier(data.getCarrierTin(), context));
        if (data.getTravellersCount() != null && data.getTravellersCount() > 1) {
            for (Map.Entry entry : productTravellers.entrySet()) {
                Traveller newTraveller = (Traveller)entry.getKey();
                passengerType = (DictionaryReference)entry.getValue();
                if (product.getPassengers().contains(newTraveller)) continue;
                product.getPassengers().add(newTraveller);
                RailwayProductHelper.setPassengerType((RailwayProduct)product, (Traveller)newTraveller, (DictionaryReference)passengerType);
            }
            for (RailwaySegment railwaySegment : data.getSegments()) {
                if (!railwaySegment.getPlaces().isEmpty()) continue;
                railwaySegment.getPlaces().addAll(product.getSegments().stream().filter(oldSegment -> newSegment.getNumber() == oldSegment.getNumber()).map(RailwaySegment::getPlaces).findFirst().orElse(Collections.emptyList()));
            }
        } else {
            product.getPassengers().clear();
            product.getPassengerTypes().clear();
            for (Map.Entry entry : productTravellers.entrySet()) {
                Traveller traveller = (Traveller)entry.getKey();
                passengerType = (DictionaryReference)entry.getValue();
                product.getPassengers().add(traveller);
                RailwayProductHelper.setPassengerType((RailwayProduct)product, (Traveller)traveller, (DictionaryReference)passengerType);
            }
        }
        product.getSegments().clear();
        product.getSegments().addAll(data.getSegments());
        product.getReservedSeats().clear();
        product.getReservedSeats().addAll(data.getReservedSeats());
        product.setChecked(false);
        product.setContractRulesApplied(false);
        if (!ShipmentHelper.hasRelatedShipment((BaseProduct)product)) {
            RailwayProductContractRelationData vendorContractRelation = RailwayProductHelper.getVendorContractRelation((RailwayProduct)product);
            RailwayProductContractRelationData railwayProductContractRelationData = RailwayProductHelper.getSubagentContractRelation((RailwayProduct)product, (boolean)false);
            RailwayProductContractRelationData clientContractRelation = RailwayProductHelper.getClientContractRelation((RailwayProduct)product);
            if (vendorContractRelation != null) {
                vendorContractRelation.getFops().clear();
            }
            if (railwayProductContractRelationData != null) {
                railwayProductContractRelationData.getFops().clear();
            }
            if (clientContractRelation != null) {
                clientContractRelation.getFops().clear();
            }
            for (RailwayProductFop fop : data.getFops()) {
                if (vendorContractRelation != null) {
                    RailwayProductFop vendorFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    vendorContractRelation.getFops().add(vendorFop);
                }
                if (railwayProductContractRelationData != null) {
                    RailwayProductFop subagentFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    railwayProductContractRelationData.getFops().add(subagentFop);
                }
                if (clientContractRelation == null) continue;
                RailwayProductFop clientFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                clientContractRelation.getFops().add(clientFop);
            }
        } else {
            context.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.InmobExchangeProcessor_railwayProductHasRelatedShipment, (Object[])new Object[]{GeneralProductHelper.getSystemNumber((BaseProduct)product)}));
        }
    }
}

