/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayProductData;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class InmobUpdateRailwayRefundProductProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        InmobRailwayProductData data = (InmobRailwayProductData)((Object)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA));
        ProductSearchResult productSearchResult = (ProductSearchResult)context.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        this.update(context, product, data);
    }

    private void update(MessageContext context, RailwayProduct product, InmobRailwayProductData data) throws Exception {
        RailwayProduct oldProduct;
        RailwayProduct previousProduct;
        if (data.getOperationReason() == InmobRailwayProductData.OperationReason.ByCarrierFault || data.getOperationReason() == InmobRailwayProductData.OperationReason.Forced || data.getOperationReason() == InmobRailwayProductData.OperationReason.ForcedWithCarrierFault) {
            product.setForcedRefund(true);
        }
        if (product.getPreviousProduct() != null) {
            if (data.getBlankOwner() == null) {
                data.setBlankOwner((EntityReference<Organization>)product.getPreviousProduct().getBlankOwnerRef());
            }
            if (data.getSupplier() == null) {
                data.setSupplier((EntityReference<Organization>)RailwayProductHelper.getSupplier((BaseProduct)product.getPreviousProduct()));
            }
            if (data.getAgency() == null) {
                data.setAgency((EntityReference<Organization>)RailwayProductHelper.getAgency((RailwayProduct)product.getPreviousProduct()));
            }
            if (data.getSubagency() == null) {
                data.setSubagency((EntityReference<Organization>)RailwayProductHelper.getSubagency((RailwayProduct)product.getPreviousProduct()));
            }
            if (data.getSalesPoint() == null) {
                data.setSalesPoint((EntityReference<SalesPoint>)product.getPreviousProduct().getSalesPoint());
            }
            if (data.getAgent() == null) {
                data.setAgent((EntityReference<Person>)product.getPreviousProduct().getCashier());
            }
        }
        if (product.getPreviousProduct() != null && (previousProduct = product.getPreviousProduct()).getSystemNumber() == null) {
            previousProduct.setSystemNumber(data.getSystemNumber());
        }
        if (product.getPreviousProduct() != null) {
            BigDecimal penaltyVatAmount;
            BigDecimal penaltyAmount;
            previousProduct = product.getPreviousProduct();
            if (previousProduct.getSystemNumber() == null) {
                previousProduct.setSystemNumber(data.getSystemNumber());
            }
            if (product.getBlankOwnerRef() == null) {
                product.setBlankOwnerRef(previousProduct.getBlankOwnerRef());
            }
            if (RailwayProductHelper.getSupplier((BaseProduct)product) == null) {
                RailwayProductHelper.setSupplier((BaseTicketProduct)product, (EntityReference)RailwayProductHelper.getSupplier((BaseProduct)previousProduct));
            }
            if (RailwayProductHelper.getAgency((RailwayProduct)product) == null) {
                RailwayProductHelper.setAgency((BaseTicketProduct)product, (EntityReference)RailwayProductHelper.getAgency((RailwayProduct)previousProduct));
            }
            if (RailwayProductHelper.getSubagency((RailwayProduct)product) == null) {
                RailwayProductHelper.setSubagency((BaseTicketProduct)product, (EntityReference)RailwayProductHelper.getSubagency((RailwayProduct)previousProduct));
            }
            if (product.getSalesPoint() == null) {
                product.setSalesPoint(previousProduct.getSalesPoint());
            }
            if (product.getCashier() == null) {
                product.setCashier(previousProduct.getCashier());
            }
            if (product.getValidatorCode() == null) {
                product.setValidatorCode(previousProduct.getValidatorCode());
            }
            if (product.getValidatorRef() == null) {
                product.setValidatorRef(previousProduct.getValidatorRef());
            }
            if (previousProduct.getSegments().size() > 0) {
                product.getSegments().clear();
                for (RailwaySegment previousSegment : previousProduct.getSegments()) {
                    RailwaySegment segment = (RailwaySegment)XCloneHelper.clone((XCloneable)previousSegment);
                    product.getSegments().add(segment);
                }
            }
            if (previousProduct.getReservedSeats().size() > 0) {
                product.getReservedSeats().clear();
                for (ReservedSeat previousReservedSeat : previousProduct.getReservedSeats()) {
                    ReservedSeat reservedSeat = (ReservedSeat)XCloneHelper.clone((XCloneable)previousReservedSeat);
                    reservedSeat.setSegment(null);
                    if (previousReservedSeat.getSegment() != null) {
                        reservedSeat.setSegment((RailwaySegment)product.getSegments().stream().filter(item -> item.getNumber() == previousReservedSeat.getSegment().getNumber()).findFirst().orElse(null));
                    }
                    product.getReservedSeats().add(reservedSeat);
                }
            }
            if (previousProduct.getTaxes().size() > 0) {
                product.getTaxes().clear();
                for (RailwayTax previousRailwayTax : previousProduct.getTaxes()) {
                    RailwayTax tax = (RailwayTax)XCloneHelper.clone((XCloneable)previousRailwayTax);
                    tax.setSegment(null);
                    if (previousRailwayTax.getSegment() != null) {
                        tax.setSegment((RailwaySegment)product.getSegments().stream().filter(item -> item.getNumber() == previousRailwayTax.getSegment().getNumber()).findFirst().orElse(null));
                    }
                    product.getTaxes().add(tax);
                }
            }
            List<VatComponent> vatComponents = data.getVatComponents();
            BigDecimal serviceAmount = previousProduct.getServiceFare();
            BigDecimal totalAmount = data.getTotalAmount();
            BigDecimal tariffAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalAmount, MiscUtil.negate((BigDecimal)serviceAmount)});
            if (previousProduct.getTotalEquivalentFare() != null && tariffAmount != null) {
                penaltyAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{previousProduct.getTotalEquivalentFare(), MiscUtil.negate((BigDecimal)tariffAmount), MiscUtil.negate((BigDecimal)serviceAmount)});
                tariffAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tariffAmount, penaltyAmount});
            } else {
                penaltyAmount = null;
            }
            if (vatComponents.isEmpty()) {
                if (tariffAmount != null) {
                    double tariffVatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)data.getIssueDate());
                    VatAmount tariffVatAmount = VatAmount.of((BigDecimal)tariffAmount, (double)tariffVatRate);
                    InmobRailwayHelper.addVatComponent(vatComponents, tariffVatAmount, VatBasisType.FARE);
                }
                if (serviceAmount != null) {
                    VatAmount serviceVatAmount = VatAmount.of((BigDecimal)serviceAmount, (BigDecimal)previousProduct.getServiceVAT());
                    InmobRailwayHelper.addVatComponent(vatComponents, serviceVatAmount, VatBasisType.SERVICE);
                }
                if (penaltyAmount != null) {
                    double penaltyVatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.PENALTY, (Date)data.getIssueDate());
                    penaltyVatAmount = VatAmount.of(penaltyAmount, (double)penaltyVatRate);
                    InmobRailwayHelper.addVatComponent(vatComponents, (VatAmount)penaltyVatAmount, VatBasisType.PENALTY);
                }
            }
            BigDecimal tariffVatAmount = InmobRailwayHelper.calcTotalVat(vatComponents, VatBasisType.FARE);
            BigDecimal serviceVatAmount = InmobRailwayHelper.calcTotalVat(vatComponents, VatBasisType.SERVICE);
            penaltyVatAmount = InmobRailwayHelper.calcTotalVat(vatComponents, VatBasisType.PENALTY);
            BigDecimal totalVatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{serviceVatAmount, tariffVatAmount, MiscUtil.negate((BigDecimal)penaltyVatAmount)});
            product.setEquivalentFare(tariffAmount != null ? tariffAmount.setScale(1, 4) : null);
            product.setEquivalentVAT(tariffVatAmount);
            product.setServiceFare(serviceAmount != null ? serviceAmount.setScale(1, 4) : null);
            product.setServiceVAT(serviceVatAmount);
            product.setPenalty(penaltyAmount != null ? penaltyAmount.setScale(1, 4) : null);
            product.setPenaltyVAT(penaltyVatAmount);
            product.setTotalEquivalentFare(totalAmount != null ? totalAmount.setScale(1, 4) : null);
            product.setTotalEquivalentVAT(totalVatAmount);
            if (!vatComponents.isEmpty()) {
                VatDetalization vatDetalization = new VatDetalization();
                vatDetalization.setDetalized(true);
                vatDetalization.getComponents().addAll(vatComponents);
                product.setVendorVatDetalization(vatDetalization);
                product.setDontRecalculateVAT(true);
            } else {
                product.setVendorVatDetalization(null);
                product.setDontRecalculateVAT(false);
            }
        }
        if ((oldProduct = (RailwayProduct)context.getObject((Enum)IBusParsersContextKeys.OLD_PRODUCT)) != null) {
            product.getPreviousProduct().setUid(oldProduct.getUid());
            List passengers = product.getPreviousProduct().getPassengers();
            if (!passengers.isEmpty()) {
                for (Traveller passenger : passengers) {
                    oldProduct.getPassengers().stream().filter(arg_0 -> ((Traveller)passenger).equals(arg_0)).map(BaseIdentity::getUid).findFirst().ifPresent(arg_0 -> ((Traveller)passenger).setUid(arg_0));
                }
            } else {
                passengers.addAll(oldProduct.getPassengers());
            }
            if (!oldProduct.getPrepaymentDocuments().isEmpty()) {
                product.getPrepaymentDocuments().clear();
                product.getPrepaymentDocuments().addAll(oldProduct.getPrepaymentDocuments());
            }
            product.getReservation().getProducts().remove(oldProduct);
        }
    }
}

