/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayProductData;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class InmobUpdateRailwaySellProductProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        InmobRailwayProductData data = (InmobRailwayProductData)((Object)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA));
        ProductSearchResult productSearchResult = (ProductSearchResult)context.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        this.update(context, product, data);
    }

    private void update(MessageContext context, RailwayProduct product, InmobRailwayProductData data) throws Exception {
        BigDecimal serviceFare = data.getServiceAmount();
        BigDecimal equivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{data.getTotalAmount(), MiscUtil.negate((BigDecimal)serviceFare)});
        List<VatComponent> vatComponents = data.getVatComponents();
        if (vatComponents.isEmpty()) {
            double tariffVatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)data.getIssueDate());
            VatAmount tariffVatAmount = VatAmount.of((BigDecimal)equivalentFare, (double)tariffVatRate);
            InmobRailwayHelper.addVatComponent(vatComponents, tariffVatAmount, VatBasisType.FARE);
            if (serviceFare != null) {
                VatAmount serviceVatAmount = VatAmount.of((BigDecimal)serviceFare, (BigDecimal)data.getServiceVatAmount());
                InmobRailwayHelper.addVatComponent(vatComponents, serviceVatAmount, VatBasisType.SERVICE);
            }
        }
        BigDecimal tariffVatAmount = InmobRailwayHelper.calcTotalVat(vatComponents, VatBasisType.FARE);
        BigDecimal serviceVatAmount = InmobRailwayHelper.calcTotalVat(vatComponents, VatBasisType.SERVICE);
        BigDecimal totalVatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{serviceVatAmount, tariffVatAmount});
        product.setServiceFare(serviceFare != null ? serviceFare.setScale(1, 4) : null);
        product.setServiceVAT(serviceVatAmount);
        product.setEquivalentFare(equivalentFare.setScale(1, 4));
        product.setEquivalentVAT(tariffVatAmount);
        product.setTotalEquivalentFare(data.getTotalAmount() != null ? data.getTotalAmount().setScale(1, 4) : null);
        product.setTotalEquivalentVAT(totalVatAmount);
        if (!vatComponents.isEmpty()) {
            VatDetalization vatDetalization = new VatDetalization();
            vatDetalization.setDetalized(true);
            vatDetalization.getComponents().addAll(vatComponents);
            product.setVendorVatDetalization(vatDetalization);
            product.setDontRecalculateVAT(true);
        } else {
            product.setVendorVatDetalization(null);
            product.setDontRecalculateVAT(false);
        }
        RailwayProduct oldProduct = (RailwayProduct)context.getObject((Enum)IBusParsersContextKeys.OLD_PRODUCT);
        if (oldProduct != null) {
            product.setUid(oldProduct.getUid());
            product.getPassengers().forEach(passenger -> oldProduct.getPassengers().stream().filter(arg_0 -> ((Traveller)passenger).equals(arg_0)).map(BaseIdentity::getUid).findFirst().ifPresent(arg_0 -> ((Traveller)passenger).setUid(arg_0)));
            if (!oldProduct.getPrepaymentDocuments().isEmpty()) {
                product.getPrepaymentDocuments().clear();
                product.getPrepaymentDocuments().addAll(oldProduct.getPrepaymentDocuments());
            }
            product.getReservation().getProducts().remove(oldProduct);
        }
    }
}

