/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayTestBase;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class XTR10329Test
extends InmobRailwayTestBase {
    @Test
    public void testSell() throws Exception {
        this.importBookingFile("testdata/xtr10329/SellBookingProduct.xml");
        Collection reservations = BookingDao.getReservationsByPnr((String)"62856089", (GdsName)GdsName.INMOB);
        RailwayProduct bookingProduct = (RailwayProduct)((Reservation)reservations.iterator().next()).getProducts().get(0);
        Assert.assertEquals((Object)ProductStatus.BOOKING, (Object)bookingProduct.getStatus());
        String uid = bookingProduct.getUid();
        Set passengersUids = bookingProduct.getPassengers().stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
        this.parseFile("testdata/xtr10329/SellExchangeDoc.xml");
        reservations = BookingDao.getReservationsByPnr((String)"62856089", (GdsName)GdsName.INMOB);
        Assert.assertEquals((long)1L, (long)reservations.size());
        Reservation reservation = (Reservation)reservations.iterator().next();
        Assert.assertEquals((long)1L, (long)reservation.getProducts().size());
        RailwayProduct sellProduct = (RailwayProduct)reservation.getProducts().get(0);
        Assert.assertEquals((Object)ProductStatus.SELL, (Object)sellProduct.getStatus());
        Assert.assertEquals((Object)uid, (Object)sellProduct.getUid());
        Assert.assertEquals(passengersUids, sellProduct.getPassengers().stream().map(BaseIdentity::getUid).collect(Collectors.toSet()));
    }

    @Test
    public void testRefund() throws Exception {
        this.importBookingFile("testdata/xtr10329/RefundBookingProduct.xml");
        Collection reservations = BookingDao.getReservationsByPnr((String)"63228644", (GdsName)GdsName.INMOB);
        RailwayProduct bookingProduct = (RailwayProduct)((Reservation)reservations.iterator().next()).getProducts().get(0);
        Assert.assertEquals((Object)ProductStatus.BOOKING, (Object)bookingProduct.getStatus());
        String uid = bookingProduct.getUid();
        Set passengersUids = bookingProduct.getPassengers().stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
        this.parseFile("testdata/xtr10329/RefundExchangeDoc.xml");
        reservations = BookingDao.getReservationsByPnr((String)"63228644", (GdsName)GdsName.INMOB);
        Assert.assertEquals((long)1L, (long)reservations.size());
        Reservation reservation = (Reservation)reservations.iterator().next();
        Assert.assertEquals((long)2L, (long)reservation.getProducts().size());
        RailwayProduct fakeSellProduct = (RailwayProduct)reservation.getProducts().get(0);
        Assert.assertEquals((Object)ProductStatus.SELL, (Object)fakeSellProduct.getStatus());
        Assert.assertEquals((Object)TicketType.FAKE, (Object)fakeSellProduct.getTicketType());
        Assert.assertEquals((Object)uid, (Object)fakeSellProduct.getUid());
        Assert.assertEquals(passengersUids, fakeSellProduct.getPassengers().stream().map(BaseIdentity::getUid).collect(Collectors.toSet()));
        RailwayProduct refundProduct = (RailwayProduct)reservation.getProducts().get(1);
        Assert.assertEquals((Object)ProductStatus.REFUND, (Object)refundProduct.getStatus());
        Assert.assertEquals((Object)fakeSellProduct, (Object)refundProduct.getPreviousProduct());
        Assert.assertEquals((Object)refundProduct, (Object)fakeSellProduct.getNextProduct());
    }

    private void importBookingFile(String fileName) throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource(fileName);
        File file = IoUtil.url2file((URL)url);
        byte[] content = IoUtil.readFileToByteArray((File)file);
        EntityContainer bfContainer = (EntityContainer)XUtil.deserialize((byte[])content);
        EntityStorage.get().save(bfContainer, true);
    }
}

