/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayTestBase;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class XTR7617Test
extends InmobRailwayTestBase {
    @Test
    public void testPnr() throws Exception {
        this.parseFile("testdata/xtr7617/70840802213031.xml");
        this.parseFile("testdata/xtr7617/70890802213042.xml");
        Collection reservations = BookingDao.getReservationsByPnr((String)"23197043", (GdsName)GdsName.INMOB);
        Assert.assertEquals((long)1L, (long)reservations.size());
        Reservation reservation = (Reservation)reservations.iterator().next();
        BookingFile bookingFile = reservation.getBookingFile();
        Assert.assertNotNull((Object)bookingFile);
        Assert.assertEquals((long)1L, (long)bookingFile.getReservations().size());
        this.assertHaveProduct(reservation, "70840802213031");
        this.assertHaveProduct(reservation, "70890802213042");
    }

    private void assertHaveProduct(Reservation reservation, String productNumber) {
        RailwayProduct product = RailwayProductHelper.getRailwayProductStream((Reservation)reservation).filter(p -> productNumber.equals(p.getSystemNumber())).findFirst().orElse(null);
        Assert.assertNotNull((String)("Product not found with number: " + productNumber), (Object)product);
    }
}

