/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayTestBase;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class XTR8093Test
extends InmobRailwayTestBase {
    @Test
    public void testAllFilesPnr() throws Exception {
        this.parseFile("testdata/xtr8093/inmob_online_20190422150131385-sell.xml");
        this.parseFile("testdata/xtr8093/inmob_online_20190422171733943-refund.xml");
        this.parseFile("testdata/xtr8093/inmob_online_20190422171733943-mco.xml");
        Collection reservations = BookingDao.getReservationsByPnr((String)"27831495", (GdsName)GdsName.INMOB);
        Assert.assertEquals((long)1L, (long)reservations.size());
        Reservation reservation = (Reservation)reservations.iterator().next();
        BookingFile bookingFile = reservation.getBookingFile();
        Assert.assertNotNull((Object)bookingFile);
        Assert.assertEquals((long)1L, (long)bookingFile.getReservations().size());
        this.assertHaveRailwayProduct(reservation, "72896798003811", ProductStatus.SELL);
        this.assertHaveRailwayProduct(reservation, "72896798003811", ProductStatus.REFUND);
        this.assertHaveRailwayReferenceMCO(reservation, "42890784250880");
    }

    @Test
    public void testSingleMcoPnr() throws Exception {
        this.parseFile("testdata/xtr8093/inmob_online_20190422171733943-mco.xml");
        Collection reservations = BookingDao.getReservationsByPnr((String)"27831495", (GdsName)GdsName.INMOB);
        Assert.assertEquals((long)1L, (long)reservations.size());
        Reservation reservation = (Reservation)reservations.iterator().next();
        BookingFile bookingFile = reservation.getBookingFile();
        Assert.assertNotNull((Object)bookingFile);
        Assert.assertEquals((long)1L, (long)bookingFile.getReservations().size());
        this.assertHaveRailwayReferenceMCO(reservation, "42890784250880");
    }

    private void assertHaveRailwayProduct(Reservation reservation, String productNumber, ProductStatus status) {
        RailwayProduct product = RailwayProductHelper.getRailwayProductStream((Reservation)reservation).filter(p -> productNumber.equals(p.getSystemNumber())).filter(p -> status == p.getStatus()).findFirst().orElse(null);
        Assert.assertNotNull((String)("Product not found with number: " + productNumber), (Object)product);
    }

    private void assertHaveRailwayReferenceMCO(Reservation reservation, String productNumber) {
        RailwayReferenceMCO product = reservation.getProducts().stream().filter(p -> p instanceof RailwayReferenceMCO).map(p -> (RailwayReferenceMCO)p).filter(p -> productNumber.equals(p.getSystemNumber())).findFirst().orElse(null);
        Assert.assertNotNull((String)("MCO not found with number: " + productNumber), (Object)product);
    }
}

