/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayTestBase;
import java.math.BigDecimal;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class XTR8395Test
extends InmobRailwayTestBase {
    @Test
    public void testSell() throws Exception {
        this.parseFile("testdata/xtr8395/74596859749816-sell.xml");
        this.testProduct("33502473", "74596859749816", ProductStatus.SELL, new BigDecimal("2960.10"), BigDecimal.ZERO, new BigDecimal("1566"), BigDecimal.ZERO, new BigDecimal("4526.10"), BigDecimal.ZERO, new BigDecimal("145.90"), new BigDecimal("24.32"), null, null, new BigDecimal("4672"), new BigDecimal("24.32"));
    }

    @Test
    public void testSellAndRefund() throws Exception {
        this.parseFile("testdata/xtr8395/74496856296392-sell.xml");
        this.parseFile("testdata/xtr8395/74496856296392-refund.xml");
        this.testProduct("33222381", "74496856296392", ProductStatus.SELL, new BigDecimal("1422.30"), BigDecimal.ZERO, new BigDecimal("1476.90"), BigDecimal.ZERO, new BigDecimal("2899.20"), BigDecimal.ZERO, new BigDecimal("220.00"), new BigDecimal("36.67"), null, null, new BigDecimal("3119.20"), new BigDecimal("36.67"));
        this.testProduct("33222381", "74496856296392", ProductStatus.REFUND, new BigDecimal("1422.30"), BigDecimal.ZERO, new BigDecimal("1476.90"), BigDecimal.ZERO, new BigDecimal("2899.20"), BigDecimal.ZERO, new BigDecimal("220.00"), new BigDecimal("36.67"), new BigDecimal("203.50"), new BigDecimal("33.92"), new BigDecimal("2915.70"), new BigDecimal("2.75"));
    }

    private void testProduct(String pnr, String number, ProductStatus status, BigDecimal segmentFare, BigDecimal segmentVat, BigDecimal reservedSeatFare, BigDecimal reservedSeatVat, BigDecimal equivalentFare, BigDecimal equivalentVat, BigDecimal serviceFare, BigDecimal serviceVat, BigDecimal penaltyFare, BigDecimal penaltyVat, BigDecimal totalEquivalentFare, BigDecimal totalEquivalentVat) throws Exception {
        Collection reservationsByPnr = BookingDao.getReservationsByPnr((String)pnr, (GdsName)GdsName.INMOB);
        Assert.assertEquals((long)1L, (long)reservationsByPnr.size());
        Reservation reservation = (Reservation)reservationsByPnr.iterator().next();
        RailwayProduct product = RailwayProductHelper.getRailwayProductStream((Reservation)reservation).filter(p -> number.equals(p.getSystemNumber())).filter(p -> status == p.getStatus()).findFirst().orElse(null);
        Assert.assertNotNull((Object)product);
        Assert.assertEquals((long)1L, (long)product.getSegments().size());
        RailwaySegment railwaySegment = (RailwaySegment)product.getSegments().get(0);
        Assert.assertNotNull((Object)railwaySegment.getFare());
        this.assertBigDecimals(segmentFare, railwaySegment.getFare().getValue());
        Assert.assertEquals((Object)"RUB", (Object)railwaySegment.getFare().getCurrency());
        this.assertBigDecimals(segmentFare, railwaySegment.getEquivalentFare());
        this.assertBigDecimals(segmentVat, railwaySegment.getEquivalentVAT());
        Assert.assertEquals((long)1L, (long)product.getReservedSeats().size());
        ReservedSeat reservedSeat = (ReservedSeat)product.getReservedSeats().get(0);
        Assert.assertNotNull((Object)reservedSeat.getFare());
        this.assertBigDecimals(reservedSeatFare, reservedSeat.getFare().getValue());
        Assert.assertEquals((Object)"RUB", (Object)reservedSeat.getFare().getCurrency());
        this.assertBigDecimals(reservedSeatFare, reservedSeat.getEquivalentFare());
        this.assertBigDecimals(reservedSeatVat, reservedSeat.getEquivalentVAT());
        this.assertBigDecimals(equivalentFare, product.getEquivalentFare());
        this.assertBigDecimals(equivalentVat, product.getEquivalentVAT());
        this.assertBigDecimals(serviceFare, product.getServiceFare());
        this.assertBigDecimals(serviceVat, product.getServiceVAT());
        this.assertBigDecimals(penaltyFare, product.getPenalty());
        this.assertBigDecimals(penaltyVat, product.getPenaltyVAT());
        this.assertBigDecimals(totalEquivalentFare, product.getTotalEquivalentFare());
        this.assertBigDecimals(totalEquivalentVat, product.getTotalEquivalentVAT());
    }

    private void assertBigDecimals(BigDecimal expected, BigDecimal actual) {
        Assert.assertTrue((String)("Expected: " + expected + ", actual: " + actual), (boolean)MiscUtil.equals((Object)expected, (Object)actual));
    }
}

