/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.railway.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayTestBase;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class XTR8466Test
extends InmobRailwayTestBase {
    @Test
    public void testAdultChild() throws Exception {
        this.parseFile("testdata/xtr8466/20190712181907719-adult.xml");
        this.parseFile("testdata/xtr8466/20190712181907719-child.xml");
        this.testProduct();
    }

    @Test
    public void testChildAdult() throws Exception {
        this.parseFile("testdata/xtr8466/20190712181907719-child.xml");
        this.parseFile("testdata/xtr8466/20190712181907719-adult.xml");
        this.testProduct();
    }

    private void testProduct() throws Exception {
        Collection reservationsByPnr = BookingDao.getReservationsByPnr((String)"34730761", (GdsName)GdsName.INMOB);
        Assert.assertEquals((long)1L, (long)reservationsByPnr.size());
        Reservation reservation = (Reservation)reservationsByPnr.iterator().next();
        RailwayProduct product = RailwayProductHelper.getRailwayProductStream((Reservation)reservation).filter(p -> "75546875061583".equals(p.getSystemNumber())).findFirst().orElse(null);
        Assert.assertNotNull((Object)product);
        this.assertBigDecimals(new BigDecimal("5520"), product.getEquivalentFare());
        this.assertBigDecimals(new BigDecimal("109.3"), product.getServiceFare());
        this.assertBigDecimals(new BigDecimal("5629.30"), product.getTotalEquivalentFare());
        Assert.assertNotNull((Object)product.getVendorVatDetalization());
        Assert.assertTrue((boolean)product.getVendorVatDetalization().isDetalized());
        Assert.assertEquals((long)2L, (long)product.getVendorVatDetalization().getComponents().size());
        VatComponent fareComponent = this.getComponent(product.getVendorVatDetalization().getComponents(), VatBasisType.FARE);
        Assert.assertEquals((double)0.0, (double)fareComponent.getRate(), (double)1.0E-4);
        this.assertBigDecimals(new BigDecimal("5520"), fareComponent.getBasis());
        this.assertBigDecimals(BigDecimal.ZERO, fareComponent.getSum());
        VatComponent serviceComponent = this.getComponent(product.getVendorVatDetalization().getComponents(), VatBasisType.SERVICE);
        Assert.assertEquals((double)0.0, (double)serviceComponent.getRate(), (double)1.0E-4);
        this.assertBigDecimals(new BigDecimal("109.30"), serviceComponent.getBasis());
        this.assertBigDecimals(BigDecimal.ZERO, serviceComponent.getSum());
        Assert.assertEquals((long)1L, (long)product.getSegments().size());
        RailwaySegment segment = (RailwaySegment)product.getSegments().get(0);
        Assert.assertNotNull((Object)segment.getFare());
        Assert.assertEquals((long)1L, (long)segment.getPlaces().size());
        Assert.assertEquals((Object)"025", segment.getPlaces().get(0));
        this.assertBigDecimals(new BigDecimal("5000.5"), segment.getFare().getValue());
        this.assertBigDecimals(new BigDecimal("5000.5"), segment.getEquivalentFare());
        Assert.assertEquals((long)2L, (long)product.getPassengers().size());
        this.assertHaveTraveller(product, "\u0411\u0440\u0438\u0446\u043a\u0430\u044f \u041e\u043b\u044c\u0433\u0430 \u042e\u0440\u044c\u0435\u0432\u043d\u0430", (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType());
        this.assertHaveTraveller(product, "\u0411\u0440\u0438\u0446\u044c\u043a\u0430 \u041ai\u0440\u0430 \u041f\u0430\u0432\u043bi\u0432\u043d\u0430", (DictionaryReference<PassengerType>)DictHelper.getInfantPassengerType());
    }

    private void assertBigDecimals(BigDecimal expected, BigDecimal actual) {
        Assert.assertTrue((String)("Expected: " + expected + ", actual: " + actual), (boolean)MiscUtil.equals((Object)expected, (Object)actual));
    }

    private VatComponent getComponent(List<VatComponent> vatComponents, VatBasisType vatBasisType) {
        return vatComponents.stream().filter(c -> c.getBasisTypes().contains(vatBasisType)).findFirst().orElseThrow(() -> new RuntimeException("VAT component not found for type " + vatBasisType));
    }

    private void assertHaveTraveller(RailwayProduct product, String name, DictionaryReference<PassengerType> passengerType) {
        Traveller traveller = product.getPassengers().stream().filter(t -> name.equals(t.getName())).findFirst().orElseThrow(() -> new RuntimeException("Traveller not found with name " + name));
        DictionaryReference foundPassengerType = product.getPassengerTypes().stream().filter(type -> traveller.equals((Object)type.getTraveller())).map(PassengerTypeReference::getPassengerType).findFirst().orElseThrow(() -> new RuntimeException("Passenger type not found for traveller " + name));
        Assert.assertEquals(passengerType, (Object)foundPassengerType);
    }
}

