/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.inmob;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.ibus.parsers.inmob.InmobRailwayTestBase;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class XTR8849Test
extends InmobRailwayTestBase {
    @Test
    public void testSellVat() throws Exception {
        this.parseFile("testdata/xtr8849/77996966120070.xml");
        this.testProductVat("42037535", "77996966120070", ProductStatus.SELL, "0", "0", null, "0");
    }

    @Test
    public void testRefundVat() throws Exception {
        this.parseFile("testdata/xtr8093/inmob_online_20190422150131385-sell.xml");
        this.testProductVat("27831495", "72896798003811", ProductStatus.SELL, "0", "94.83", null, "94.83");
        this.parseFile("testdata/xtr8093/inmob_online_20190422171733943-refund.xml");
        this.testProductVat("27831495", "72896798003811", ProductStatus.REFUND, "0", "94.83", "33.92", "60.91");
    }

    private void testProductVat(String pnr, String productNumber, ProductStatus status, String fareVat, String serviceVat, String penaltyVat, String totalVat) throws Exception {
        Collection reservationsByPnr = BookingDao.getReservationsByPnr((String)pnr, (GdsName)GdsName.INMOB);
        Assert.assertEquals((long)1L, (long)reservationsByPnr.size());
        Reservation reservation = (Reservation)reservationsByPnr.iterator().next();
        RailwayProduct product = RailwayProductHelper.getRailwayProductStream((Reservation)reservation).filter(p -> productNumber.equals(p.getSystemNumber())).filter(p -> status == p.getStatus()).findFirst().orElse(null);
        Assert.assertNotNull((Object)product);
        this.assertBigDecimals(fareVat, product.getEquivalentVAT());
        this.assertBigDecimals(serviceVat, product.getServiceVAT());
        this.assertBigDecimals(penaltyVat, product.getPenaltyVAT());
        this.assertBigDecimals(totalVat, product.getTotalEquivalentVAT());
        if (status == ProductStatus.REFUND) {
            Assert.assertEquals((long)3L, (long)product.getVendorVatDetalization().getComponents().size());
            this.assertBigDecimals(penaltyVat, this.getComponent(product.getVendorVatDetalization().getComponents(), VatBasisType.PENALTY).getSum());
        } else {
            Assert.assertEquals((long)2L, (long)product.getVendorVatDetalization().getComponents().size());
        }
        this.assertBigDecimals(fareVat, this.getComponent(product.getVendorVatDetalization().getComponents(), VatBasisType.FARE).getSum());
        this.assertBigDecimals(serviceVat, this.getComponent(product.getVendorVatDetalization().getComponents(), VatBasisType.SERVICE).getSum());
        Assert.assertTrue((boolean)product.isDontRecalculateVAT());
        Assert.assertTrue((boolean)product.getVendorVatDetalization().isDetalized());
        for (VatComponent component : product.getVendorVatDetalization().getComponents()) {
            if (component.getSum() != null) {
                Assert.assertNotNull((Object)component.getRate());
                if (MiscUtil.equals((Object)BigDecimal.ZERO, (Object)component.getSum())) {
                    Assert.assertEquals((Object)0.0, (Object)component.getRate());
                    continue;
                }
                Assert.assertNotEquals((Object)0.0, (Object)component.getRate());
                continue;
            }
            Assert.assertNull((Object)component.getRate());
        }
    }

    private void assertBigDecimals(String expected, BigDecimal actual) {
        BigDecimal expectedBigDecimal = expected != null ? new BigDecimal(expected) : null;
        Assert.assertTrue((String)("Expected: " + expectedBigDecimal + ", actual: " + actual), (boolean)MiscUtil.equals((Object)expectedBigDecimal, (Object)actual));
    }

    private VatComponent getComponent(List<VatComponent> vatComponents, VatBasisType vatBasisType) {
        return vatComponents.stream().filter(c -> c.getBasisTypes().contains(vatBasisType)).findFirst().orElseThrow(() -> new RuntimeException("VAT component not found for type " + vatBasisType));
    }
}

