/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.teletrain;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDictionaryHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.teletrain.TeletrainHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.common.CommonRailwayParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.teletrain.TeletrainRailwayData;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSHelper;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TeletrainParseRailwayProductCommonExchangeDataProcessor
extends BaseProcessor {
    public static final String BLANK_TYPE_CODE = "\u0420\u0416\u0414 \u042d\u0411";

    public void process(MessageContext context) throws Exception {
        Document document = (Document)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_ENTRY);
        TeletrainRailwayData data = (TeletrainRailwayData)((Object)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA));
        Boolean registrationPhase = (Boolean)context.getObject((Enum)IBusParsersContextKeys.REGISTRATION_PHASE);
        boolean registration = registrationPhase != null && registrationPhase != false;
        this.parse(document.getDocumentElement(), data);
    }

    private void parse(Element element, TeletrainRailwayData teletrainData) throws Exception {
        Iterator arriveStationsIterator;
        RailwayStation arriveLocation;
        Iterator departureStationsIterator;
        RailwayStation departureLocation;
        HashSet<Message> messages = new HashSet<Message>();
        TransactionType transactionType = null;
        teletrainData.setContent(XUtil.toString((Element)element, (String)"utf-8"));
        String transactionTypeCode = XHelper.readString((Element)element, (String)"Type");
        if (!TextUtil.isBlank((String)transactionTypeCode) && (transactionType = this.getTransactionType(transactionTypeCode)) == null) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_transactionTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_transactionTypeWithCodeNotSupported, (Object[])new Object[]{transactionTypeCode}), (Object[])new Object[0]));
        }
        String pnr = null;
        if (transactionType == TransactionType.SELL) {
            pnr = XHelper.readString((Element)element, (String)"TransID");
        } else if (transactionType == TransactionType.REFUND) {
            pnr = XHelper.readString((Element)element, (String)"PrevTransID");
        }
        RailwayStationReference departureStation = null;
        String departureStationCode = XHelper.readString((Element)element, (String)"StationFrom@Code");
        Collection departureLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)departureStationCode);
        if (departureLocations.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_departureStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_stationWithCodeMultipleFound, (Object[])new Object[]{departureStationCode}), (Object[])new Object[0]));
        }
        RailwayStation railwayStation = departureLocation = (departureStationsIterator = departureLocations.iterator()).hasNext() ? (RailwayStation)departureStationsIterator.next() : null;
        if (departureLocation != null) {
            departureStation = departureLocation.toReference();
        } else {
            messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_departureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_stationWithCodeNotFound, (Object[])new Object[]{departureStationCode}), (Object[])new Object[0]));
        }
        if (departureStation == null) {
            String departureStationName = XHelper.readString((Element)element, (String)"StationFrom");
            departureLocations = RailwayProductDictionaryHelper.findStationsByTranslationOrSpellVariant((String)departureStationName);
            if (departureLocations.size() > 1) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_departureStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_stationWithNameMultipleFound, (Object[])new Object[]{departureStationName}), (Object[])new Object[0]));
            }
            RailwayStation railwayStation2 = departureLocation = (departureStationsIterator = departureLocations.iterator()).hasNext() ? (RailwayStation)departureStationsIterator.next() : null;
            if (departureLocation != null) {
                departureStation = departureLocation.toReference();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_departureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_stationWithNameNotFound, (Object[])new Object[]{departureStationName}), (Object[])new Object[0]));
            }
        }
        String carrierInn = XHelper.readString((Element)element, (String)"CarrierInn");
        RailwayStationReference arriveStation = null;
        String arriveStationCode = XHelper.readString((Element)element, (String)"StationTo@Code");
        Collection arriveLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)arriveStationCode);
        if (arriveLocations.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_arriveStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_stationWithCodeMultipleFound, (Object[])new Object[]{arriveStationCode}), (Object[])new Object[0]));
        }
        RailwayStation railwayStation3 = arriveLocation = (arriveStationsIterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)arriveStationsIterator.next() : null;
        if (arriveLocation != null) {
            arriveStation = arriveLocation.toReference();
        } else {
            messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_arriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_stationWithCodeNotFound, (Object[])new Object[]{arriveStationCode}), (Object[])new Object[0]));
        }
        if (arriveLocation == null) {
            String arriveStationName = XHelper.readString((Element)element, (String)"StationTo");
            arriveLocations = RailwayProductDictionaryHelper.findStationsByTranslationOrSpellVariant((String)arriveStationName);
            if (arriveLocations.size() > 1) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_arriveStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_stationWithNameMultipleFound, (Object[])new Object[]{arriveStationName}), (Object[])new Object[0]));
            }
            RailwayStation railwayStation4 = arriveLocation = (arriveStationsIterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)arriveStationsIterator.next() : null;
            if (arriveLocation != null) {
                arriveStation = arriveLocation.toReference();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_arriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_stationWithNameNotFound, (Object[])new Object[]{arriveStationName}), (Object[])new Object[0]));
            }
        }
        Date issueDate = null;
        String issueDateString = XHelper.readString((Element)element, (String)"ConfirmTime");
        if (!TextUtil.isBlank((String)issueDateString)) {
            try {
                issueDate = TeletrainHelper.getDateTimeFormat().parse(issueDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_issueDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        Date departureDate = null;
        String departureDateString = XHelper.readString((Element)element, (String)"DepartTime");
        if (!TextUtil.isBlank((String)departureDateString)) {
            try {
                departureDate = TeletrainHelper.getDateTimeFormat().parse(departureDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_departureDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        Date arriveDate = null;
        String arriveDateString = XHelper.readString((Element)element, (String)"ArrivalTime");
        if (!TextUtil.isBlank((String)arriveDateString)) {
            try {
                arriveDate = TeletrainHelper.getDateTimeFormat().parse(arriveDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_arriveDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        String trainData = XHelper.readString((Element)element, (String)"TrainNum");
        String pattern = "^([\\d]+)([\\D]*)$";
        Matcher matcher = Pattern.compile(pattern).matcher(trainData);
        String trainNumber = null;
        String slot = null;
        if (matcher.matches()) {
            trainNumber = matcher.group(1);
            slot = matcher.group(2);
        } else {
            messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_trainDataDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_dataHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
        }
        String carriageNumber = XHelper.readString((Element)element, (String)"CarNum");
        CarriageType carriageType = null;
        String carriageTypeCode = XHelper.readString((Element)element, (String)"CarType");
        if (!TextUtil.isBlank((String)carriageTypeCode) && (carriageType = this.getCarriageType(carriageTypeCode)) == null) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_carriageTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_carriageTypeWithCodeNotSupported, (Object[])new Object[]{carriageTypeCode}), (Object[])new Object[0]));
        }
        String agentCode = XHelper.readString((Element)element, (String)"Agent");
        String pccCode = XHelper.readString((Element)element, (String)"Agent");
        CompartmentType compartmentType = null;
        String compartmentTypeCode = XHelper.readString((Element)element, (String)"GenderClass");
        if (!TextUtil.isBlank((String)compartmentTypeCode)) {
            compartmentType = this.getCompartmentType(compartmentTypeCode);
            if (compartmentType == null) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_compartmentTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_compartmentTypeWithCodeNotSupported, (Object[])new Object[]{compartmentTypeCode}), (Object[])new Object[0]));
            }
        } else {
            compartmentType = CompartmentType.COMMON;
        }
        ServiceClass serviceClass = null;
        String serviceClassCode = XHelper.readString((Element)element, (String)"ServiceClass");
        if (!TextUtil.isBlank((String)serviceClassCode) && (serviceClass = this.getServiceClass(serviceClassCode = serviceClassCode.split(" ")[0])) == null) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_serviceClassDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_serviceClassWithCodeNotSupported, (Object[])new Object[]{serviceClassCode}), (Object[])new Object[0]));
        }
        String systemNumber = null;
        BigDecimal totalAmount = null;
        BigDecimal tariffAmount = null;
        BigDecimal serviceAmount = null;
        BigDecimal totalVatAmount = null;
        BigDecimal tariffVatAmount = null;
        BigDecimal serviceVatAmount = null;
        BigDecimal segmentAmount = null;
        BigDecimal reservedSeatAmount = null;
        Element blankElement = XmlUtil.getElement((Element)element, (String)"Blank");
        if (blankElement != null) {
            String reservedSeatAmountString;
            String segmentAmountAmountString;
            String string;
            String totalVatAmountString;
            systemNumber = XHelper.readString((Element)blankElement, (String)"TicketNum");
            String totalAmountString = XHelper.readString((Element)blankElement, (String)"Amount");
            if (!TextUtil.isBlank((String)totalAmountString)) {
                try {
                    totalAmount = new BigDecimal(totalAmountString);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_blankTotalAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (!TextUtil.isBlank((String)(totalVatAmountString = XHelper.readString((Element)blankElement, (String)"AmountNDS")))) {
                try {
                    totalVatAmount = new BigDecimal(totalVatAmountString);
                }
                catch (NumberFormatException numberFormatException) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_blankTotalVatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (!TextUtil.isBlank((String)(string = XHelper.readString((Element)blankElement, (String)"ServiceNDS")))) {
                try {
                    serviceVatAmount = new BigDecimal(string);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_blankServiceVatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (totalVatAmount != null && serviceVatAmount != null) {
                tariffVatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalVatAmount, MiscUtil.negate((BigDecimal)serviceVatAmount)});
            }
            double vatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)issueDate);
            if (totalAmount != null && serviceVatAmount != null && vatRate != 0.0) {
                serviceAmount = MiscUtil.scale((BigDecimal)MiscUtil.round((BigDecimal)BigDecimal.valueOf(serviceVatAmount.doubleValue() / vatRate * (100.0 + vatRate)), (RoundingMode)RoundingMode.HALF_UP, (BigDecimal)BigDecimal.valueOf(0.1)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                tariffAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalAmount, MiscUtil.negate((BigDecimal)serviceAmount)});
            }
            if (!TextUtil.isBlank((String)(segmentAmountAmountString = XHelper.readString((Element)blankElement, (String)"TicketAmount")))) {
                try {
                    segmentAmount = new BigDecimal(segmentAmountAmountString);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_blankSegmentAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if ((reservedSeatAmountString = XHelper.readString((Element)blankElement, (String)"ReservedSeatAmount")) == null) {
                reservedSeatAmountString = XHelper.readString((Element)blankElement, (String)"ResevedSeatAmount");
            }
            if (!TextUtil.isBlank((String)reservedSeatAmountString)) {
                try {
                    reservedSeatAmount = new BigDecimal(reservedSeatAmountString);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_blankReservedSeatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
        }
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        ArrayList<String> places = new ArrayList<String>();
        for (Element passengerElement : XmlUtil.getElements((Element)element, (String)"Passenger")) {
            String placesData;
            Traveller traveller = new Traveller();
            Passport passport = new Passport();
            PassportType passportType = null;
            String passportTypeCode = XHelper.readString((Element)passengerElement, (String)"DocType");
            if (!TextUtil.isBlank((String)passportTypeCode) && (passportType = this.getPassportType(passportTypeCode)) == null) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_travellerPassportTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_passportTypeWithCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
            }
            String passportNumber = XHelper.readString((Element)passengerElement, (String)"DocNum");
            String name = XHelper.readString((Element)passengerElement, (String)"Name");
            if (!TextUtil.isBlank((String)name)) {
                name = name.replaceAll("[\\d-]", "");
            }
            Date birthday = null;
            String birthdayString = XHelper.readString((Element)passengerElement, (String)"BirthDay");
            if (!TextUtil.isBlank((String)birthdayString)) {
                try {
                    birthday = UFSHelper.getBirthdayDateFormat().parse(birthdayString);
                }
                catch (ParseException e) {
                    messages.add(MessageHelper.createWarningMessage((String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_birthdayDateDefineFailed, (Object[])new Object[]{name}), (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_dateHasWrongFormat, (Object[])new Object[]{birthdayString}), (Object[])new Object[0]));
                }
            }
            if (!TextUtil.isBlank((String)(placesData = XHelper.readString((Element)passengerElement, (String)"Place")))) {
                for (String place : placesData.trim().split(",")) {
                    if (place.contains("-")) {
                        String[] values = place.split("-");
                        if (values.length != 2) continue;
                        Integer startPlace = null;
                        Integer endPlace = null;
                        try {
                            startPlace = Integer.valueOf(values[0].trim());
                            endPlace = Integer.valueOf(values[1].trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.TeletrainExchangeProcessor_railwayProductPlaceDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.TeletrainExchangeProcessor_amountNotNumber, (Object[])new Object[]{passportTypeCode.trim()}), (Object[])new Object[0]));
                        }
                        if (startPlace == null || endPlace == null || startPlace > endPlace) continue;
                        for (int i = startPlace.intValue(); i <= endPlace; ++i) {
                            places.add(String.valueOf(i));
                        }
                        continue;
                    }
                    places.add(place);
                }
            }
            passport.setType(passportType);
            passport.setNumber(passportNumber);
            passport.setBirthday(birthday);
            TextUtil.splitFullName((String)name, (PersonalName)passport);
            traveller.setName(name);
            traveller.setCyrillicName(TextUtil.translit((String)name, (boolean)false));
            traveller.setBirthday(birthday);
            traveller.setPassport(passport);
            travellers.add(traveller);
        }
        String string = BLANK_TYPE_CODE;
        String blankOwnerCode = CommonRailwayParsersHelper.getBlankOwnerCode(GdsName.TELETRAIN);
        TicketType ticketType = TicketType.OWN;
        teletrainData.setContent(XUtil.toString((Element)element, (String)"utf-8"));
        teletrainData.setTransactionType(transactionType);
        teletrainData.setPnr(pnr);
        teletrainData.setDepartureStation((DictionaryReference<RailwayStation>)departureStation);
        teletrainData.setArriveStation((DictionaryReference<RailwayStation>)arriveStation);
        teletrainData.setSystemNumber(systemNumber);
        teletrainData.setIssueDate(issueDate);
        teletrainData.setDepartureDate(departureDate);
        teletrainData.setArriveDate(arriveDate);
        teletrainData.setTrainNumber(trainNumber);
        teletrainData.setSlot(slot);
        teletrainData.setCarriageNumber(carriageNumber);
        teletrainData.setCarriageType(carriageType);
        teletrainData.setAgentCode(agentCode);
        teletrainData.setPccCode(pccCode);
        teletrainData.setTotalAmount(totalAmount);
        teletrainData.setTariffAmount(tariffAmount);
        teletrainData.setServiceAmount(serviceAmount);
        teletrainData.setTotalVatAmount(totalVatAmount);
        teletrainData.setTariffVatAmount(tariffVatAmount);
        teletrainData.setServiceVatAmount(serviceVatAmount);
        teletrainData.setSegmentAmount(segmentAmount);
        teletrainData.setReservedSeatAmount(reservedSeatAmount);
        teletrainData.setCompartmentType(compartmentType);
        teletrainData.setServiceClass(serviceClass);
        teletrainData.setBlankTypeCode(string);
        teletrainData.setBlankOwnerCode(blankOwnerCode);
        teletrainData.setTicketType(ticketType);
        teletrainData.setCarrierInn(carrierInn);
        teletrainData.getTravellers().clear();
        teletrainData.getTravellers().addAll(travellers);
        teletrainData.getPlaces().clear();
        teletrainData.getPlaces().addAll(places);
        teletrainData.getMessages().clear();
        teletrainData.getMessages().addAll(messages);
    }

    private TransactionType getTransactionType(String transactionTypeCode) {
        if (!TextUtil.isBlank((String)transactionTypeCode)) {
            if (transactionTypeCode.equals("1")) {
                return TransactionType.SELL;
            }
            if (transactionTypeCode.equals("14")) {
                return TransactionType.REFUND;
            }
            if (transactionTypeCode.equals("13")) {
                return TransactionType.CANCEL;
            }
        }
        return null;
    }

    private CompartmentType getCompartmentType(String compartmentTypeCode) {
        if (!TextUtil.isBlank((String)compartmentTypeCode)) {
            if (compartmentTypeCode.equals("0")) {
                return CompartmentType.COMMON;
            }
            if (compartmentTypeCode.equals("1")) {
                return CompartmentType.MEN;
            }
            if (compartmentTypeCode.equals("2")) {
                return CompartmentType.WOMEN;
            }
        }
        return null;
    }

    private ServiceClass getServiceClass(String serviceClassCode) {
        if (!TextUtil.isBlank((String)serviceClassCode)) {
            return RzdServiceConverter.getServiceClassByName(serviceClassCode);
        }
        return null;
    }

    private PassportType getPassportType(String passportTypeCode) {
        if (!TextUtil.isBlank((String)passportTypeCode)) {
            if (passportTypeCode.equals("\u041f\u041d")) {
                return PassportType.INTERNAL;
            }
            if (passportTypeCode.equals("\u0421\u0420")) {
                return PassportType.BIRTHDAY_NOTIFICATION;
            }
            if (passportTypeCode.equals("\u0417\u041f")) {
                return PassportType.FOREIGN;
            }
            if (passportTypeCode.equals("\u0417\u0417")) {
                return PassportType.PASSPORT;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStackTrace(Exception e) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            e.printStackTrace(new PrintStream((OutputStream)baos, true, "utf-8"));
            String string = baos.toString("utf-8");
            return string;
        }
    }

    private CarriageType getCarriageType(String carriageTypeCode) {
        if (!TextUtil.isBlank((String)carriageTypeCode)) {
            if (carriageTypeCode.equals("\u041b")) {
                return CarriageType.L;
            }
            if (carriageTypeCode.equals("\u041c")) {
                return CarriageType.M;
            }
            if (carriageTypeCode.equals("\u041a")) {
                return CarriageType.K;
            }
            if (carriageTypeCode.equals("\u041f")) {
                return CarriageType.P;
            }
            if (carriageTypeCode.equals("\u0421")) {
                return CarriageType.S;
            }
            if (carriageTypeCode.equals("\u041e")) {
                return CarriageType.O;
            }
        }
        return null;
    }
}

