/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.teletrain;

import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.server.parsers2.teletrain.TeletrainData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TeletrainRailwayData
extends TeletrainData {
    private String pnr;
    private TransactionType transactionType;
    private DictionaryReference<RailwayStation> departureStation;
    private DictionaryReference<RailwayStation> arriveStation;
    private Date departureDate;
    private Date arriveDate;
    private String trainNumber;
    private String slot;
    private String carriageNumber;
    private CarriageType carriageType;
    private String agentCode;
    private String pccCode;
    private BigDecimal totalAmount;
    private BigDecimal tariffAmount;
    private BigDecimal serviceAmount;
    private BigDecimal totalVatAmount;
    private BigDecimal tariffVatAmount;
    private BigDecimal serviceVatAmount;
    private BigDecimal segmentAmount;
    private BigDecimal reservedSeatAmount;
    private CompartmentType compartmentType;
    private ServiceClass serviceClass;
    private String blankTypeCode;
    private String blankOwnerCode;
    private TicketType ticketType;
    private final List<Traveller> travellers = new ArrayList<Traveller>();
    private final List<String> places = new ArrayList<String>();
    private String carrierInn;
    private final Set<Message> messages = new HashSet<Message>();

    public String getPnr() {
        return this.pnr;
    }

    public void setPnr(String pnr) {
        this.pnr = pnr;
    }

    public DictionaryReference<RailwayStation> getDepartureStation() {
        return this.departureStation;
    }

    public void setDepartureStation(DictionaryReference<RailwayStation> departureStation) {
        this.departureStation = departureStation;
    }

    public DictionaryReference<RailwayStation> getArriveStation() {
        return this.arriveStation;
    }

    public void setArriveStation(DictionaryReference<RailwayStation> arriveStation) {
        this.arriveStation = arriveStation;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    public Date getArriveDate() {
        return this.arriveDate;
    }

    public void setArriveDate(Date arriveDate) {
        this.arriveDate = arriveDate;
    }

    public String getTrainNumber() {
        return this.trainNumber;
    }

    public void setTrainNumber(String trainNumber) {
        this.trainNumber = trainNumber;
    }

    public String getSlot() {
        return this.slot;
    }

    public void setSlot(String slot) {
        this.slot = slot;
    }

    public String getCarriageNumber() {
        return this.carriageNumber;
    }

    public void setCarriageNumber(String carriageNumber) {
        this.carriageNumber = carriageNumber;
    }

    public CarriageType getCarriageType() {
        return this.carriageType;
    }

    public void setCarriageType(CarriageType carriageType) {
        this.carriageType = carriageType;
    }

    public String getAgentCode() {
        return this.agentCode;
    }

    public void setAgentCode(String agentCode) {
        this.agentCode = agentCode;
    }

    public String getPccCode() {
        return this.pccCode;
    }

    public void setPccCode(String pccCode) {
        this.pccCode = pccCode;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getTariffAmount() {
        return this.tariffAmount;
    }

    public void setTariffAmount(BigDecimal tariffAmount) {
        this.tariffAmount = tariffAmount;
    }

    public BigDecimal getServiceAmount() {
        return this.serviceAmount;
    }

    public void setServiceAmount(BigDecimal serviceAmount) {
        this.serviceAmount = serviceAmount;
    }

    public BigDecimal getTotalVatAmount() {
        return this.totalVatAmount;
    }

    public void setTotalVatAmount(BigDecimal totalVatAmount) {
        this.totalVatAmount = totalVatAmount;
    }

    public BigDecimal getTariffVatAmount() {
        return this.tariffVatAmount;
    }

    public void setTariffVatAmount(BigDecimal tariffVatAmount) {
        this.tariffVatAmount = tariffVatAmount;
    }

    public BigDecimal getServiceVatAmount() {
        return this.serviceVatAmount;
    }

    public void setServiceVatAmount(BigDecimal serviceVatAmount) {
        this.serviceVatAmount = serviceVatAmount;
    }

    public BigDecimal getSegmentAmount() {
        return this.segmentAmount;
    }

    public void setSegmentAmount(BigDecimal segmentAmount) {
        this.segmentAmount = segmentAmount;
    }

    public BigDecimal getReservedSeatAmount() {
        return this.reservedSeatAmount;
    }

    public void setReservedSeatAmount(BigDecimal reservedSeatAmount) {
        this.reservedSeatAmount = reservedSeatAmount;
    }

    public CompartmentType getCompartmentType() {
        return this.compartmentType;
    }

    public void setCompartmentType(CompartmentType compartmentType) {
        this.compartmentType = compartmentType;
    }

    public ServiceClass getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(ServiceClass serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getBlankTypeCode() {
        return this.blankTypeCode;
    }

    public void setBlankTypeCode(String blankTypeCode) {
        this.blankTypeCode = blankTypeCode;
    }

    public String getBlankOwnerCode() {
        return this.blankOwnerCode;
    }

    public void setBlankOwnerCode(String blankOwnerCode) {
        this.blankOwnerCode = blankOwnerCode;
    }

    public TicketType getTicketType() {
        return this.ticketType;
    }

    public void setTicketType(TicketType ticketType) {
        this.ticketType = ticketType;
    }

    public List<Traveller> getTravellers() {
        return this.travellers;
    }

    public List<String> getPlaces() {
        return this.places;
    }

    public Set<Message> getMessages() {
        return this.messages;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public String getCarrierInn() {
        return this.carrierInn;
    }

    public void setCarrierInn(String carrierInn) {
        this.carrierInn = carrierInn;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("pcc code -> " + this.pccCode);
        stringBuilder.append("\n");
        stringBuilder.append("pnr -> " + this.pnr);
        stringBuilder.append("\n");
        stringBuilder.append("segment -> ");
        stringBuilder.append("\n");
        stringBuilder.append("\n\t");
        stringBuilder.append("departure station -> " + (this.departureStation != null ? this.departureStation.getCaption() : null));
        stringBuilder.append("\n\t");
        stringBuilder.append("arrive station -> " + (this.arriveStation != null ? this.arriveStation.getCaption() : null));
        stringBuilder.append("\n\t");
        stringBuilder.append("train number -> " + this.trainNumber);
        stringBuilder.append("\n\t");
        stringBuilder.append("slot -> " + this.slot);
        stringBuilder.append("\n\t");
        stringBuilder.append("carriage number -> " + this.carriageNumber);
        stringBuilder.append("\n\t");
        stringBuilder.append("carriage type -> " + (this.carriageType != null ? this.carriageType.name() : null));
        stringBuilder.append("\n\t");
        stringBuilder.append("departure date -> " + this.departureDate);
        stringBuilder.append("\n\t");
        if (this.places != null && !this.places.isEmpty()) {
            stringBuilder.append("places -> ");
            StringBuilder placesAsString = new StringBuilder();
            for (String string : this.places) {
                placesAsString.append(" ").append(string);
            }
            stringBuilder.append((CharSequence)placesAsString);
            stringBuilder.append("\n\t");
        }
        stringBuilder.append("service class -> " + this.serviceClass);
        stringBuilder.append("\n\t");
        stringBuilder.append("segment amount -> " + (this.segmentAmount != null ? this.segmentAmount : "?"));
        stringBuilder.append("\n\t");
        stringBuilder.append("\n");
        if (this.travellers != null && !this.travellers.isEmpty()) {
            stringBuilder.append("travellers -> ");
            stringBuilder.append("\n");
            for (Traveller traveller : this.travellers) {
                stringBuilder.append("\n\t");
                stringBuilder.append("name -> " + traveller.getName());
                stringBuilder.append("\n\t");
                stringBuilder.append("gender -> " + traveller.getGender());
                stringBuilder.append("\n\t");
                stringBuilder.append("birthday -> " + traveller.getBirthday());
                stringBuilder.append("\n\n");
            }
        }
        stringBuilder.append("tariffAmount -> " + (this.tariffAmount != null ? this.tariffAmount.toString() : "?") + " RUB");
        stringBuilder.append("\n");
        stringBuilder.append("serviceAmount -> " + (this.serviceAmount != null ? this.serviceAmount.toString() : "?") + " RUB");
        stringBuilder.append("\n");
        stringBuilder.append("totalAmount -> " + (this.totalAmount != null ? this.totalAmount.toString() : "?") + " RUB");
        stringBuilder.append("\n");
        stringBuilder.append("\n\n");
        return stringBuilder.toString();
    }
}

