/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.teletrain;

import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TeletrainRailwayProductDataTargetProvider
extends BaseTargetsProvider<Document> {
    public Collection<Document> getTargets(MessageContext ctx) throws Exception {
        ExchangeFile file = (ExchangeFile)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
        return this.createDocumentList(file);
    }

    public List<Document> createDocumentList(ExchangeFile file) throws Exception {
        ArrayList<Document> documents = new ArrayList<Document>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(XUtil.createSource((InputStream)new ByteArrayInputStream(file.getContent()), (String)"utf-8"));
        Element root = document.getDocumentElement();
        ArrayList<BlankInfo> blankInfos = new ArrayList<BlankInfo>();
        for (Element blankElement : XmlUtil.getElements((Element)root, (String)"Blank")) {
            String id = XHelper.readString((Element)blankElement, (String)"@ID");
            if (id == null) continue;
            BlankInfo blankInfo = new BlankInfo();
            blankInfo.setBlankElement(blankElement);
            for (Element passengerElement : XmlUtil.getElements((Element)root, (String)"Passenger")) {
                String blankId = XHelper.readString((Element)passengerElement, (String)"@BlankID");
                if (!TextUtil.isSame((String)id, (String)blankId, (boolean)true, (boolean)true)) continue;
                blankInfo.getPassengerElements().add(passengerElement);
            }
            blankInfos.add(blankInfo);
        }
        for (BlankInfo blankInfo : blankInfos) {
            for (Element blankElement : XmlUtil.getElements((Element)root, (String)"Blank")) {
                root.removeChild(blankElement);
            }
            for (Element passengerElement : XmlUtil.getElements((Element)root, (String)"Passenger")) {
                root.removeChild(passengerElement);
            }
            root.appendChild(blankInfo.getBlankElement());
            for (Element passengerElement : blankInfo.getPassengerElements()) {
                root.appendChild(passengerElement);
            }
            Document newDocument = documentBuilder.newDocument();
            newDocument.appendChild(newDocument.importNode(root, true));
            documents.add(newDocument);
        }
        return documents;
    }

    private static class BlankInfo {
        private Element blankElement;
        private final List<Element> passengerElements = new ArrayList<Element>();

        private BlankInfo() {
        }

        public Element getBlankElement() {
            return this.blankElement;
        }

        public void setBlankElement(Element blankElement) {
            this.blankElement = blankElement;
        }

        public List<Element> getPassengerElements() {
            return this.passengerElements;
        }
    }
}

