/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.teletrain;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.common.CommonRailwayParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.teletrain.TeletrainRailwayData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TeletrainUpdateRailwayProductCommonProcessor
extends BaseProcessor {
    public static final String SUPPLIER_CODE = "\u0422\u0422";

    public void process(MessageContext ctx) throws Exception {
        TeletrainRailwayData data = (TeletrainRailwayData)((Object)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA));
        ProductSearchResult productSearchResult = (ProductSearchResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        EntityContainer bookingFileContainer = productSearchResult.getBookingFile();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        if (this.log.isDebugEnabled()) {
            this.log.debug("teletrain parse data -> \n\n" + (Object)((Object)data));
        }
        this.update(ctx, product, bookingFile, data);
    }

    private void update(MessageContext context, RailwayProduct product, BookingFile bookingFile, TeletrainRailwayData teletrainData) throws Exception {
        ProductStatus status = this.getProductStatus(teletrainData.getTransactionType());
        String systemNumber = teletrainData.getSystemNumber();
        Date issueDate = teletrainData.getIssueDate();
        String blankTypeCode = teletrainData.getBlankTypeCode();
        TicketType ticketType = teletrainData.getTicketType();
        List<Traveller> travellers = teletrainData.getTravellers();
        DictionaryReference<BlankType> blankType = this.findBlankType(blankTypeCode);
        ArrayList messages = new ArrayList();
        ParsersHelper.SalesContextData salesContextData = ParsersHelper.getSalesContextData((String)teletrainData.getBlankOwnerCode(), null, null, (String)teletrainData.getAgentCode(), null, (String)teletrainData.getPccCode(), (GdsName)GdsName.TELETRAIN, (Date)teletrainData.getIssueDate(), messages);
        EntityReference blankOwner = salesContextData.getBlankOwner();
        EntityReference provider = salesContextData.getProvider();
        EntityReference<Organization> supplier = TeletrainUpdateRailwayProductCommonProcessor.getOrganizationByCode(SUPPLIER_CODE);
        EntityReference agency = salesContextData.getAgency();
        EntityReference subagency = salesContextData.getSubagency();
        EntityReference salesPoint = salesContextData.getSalesPoint();
        EntityReference agent = salesContextData.getAgent();
        String validatorCode = salesContextData.getValidatorCode();
        String pccCode = salesContextData.getPccCode();
        context.addMessages(teletrainData.getMessages());
        context.addMessages(messages);
        int number = 1;
        DictionaryReference<RailwayStation> departureStation = teletrainData.getDepartureStation();
        DictionaryReference<RailwayStation> arriveStation = teletrainData.getArriveStation();
        String trainNumber = teletrainData.getTrainNumber();
        String slot = teletrainData.getSlot();
        String carriageNumber = teletrainData.getCarriageNumber();
        CarriageType carriageType = teletrainData.getCarriageType();
        CompartmentType compartmentType = teletrainData.getCompartmentType();
        ServiceClass serviceClass = teletrainData.getServiceClass();
        List<String> places = teletrainData.getPlaces();
        Date departureDate = teletrainData.getDepartureDate();
        Date arriveDate = teletrainData.getArriveDate();
        product.setCarrier(CommonRailwayParsersHelper.getCarrier(teletrainData.getCarrierInn(), context));
        BigDecimal equivalentSegmentFare = teletrainData.getSegmentAmount();
        Money segmentFare = null;
        if (equivalentSegmentFare != null) {
            segmentFare = new Money();
            segmentFare.setValue(equivalentSegmentFare);
            segmentFare.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
        }
        RailwaySegment segment = new RailwaySegment();
        segment.setNumber(number);
        segment.setDepartureStation(departureStation);
        segment.setArriveStation(arriveStation);
        segment.setTrainNumber(trainNumber);
        segment.setSlot(slot);
        segment.setCarriageNumber(carriageNumber);
        segment.setCarriageType(carriageType);
        segment.setCompartmentType(compartmentType);
        segment.setServiceClass(serviceClass);
        segment.getPlaces().clear();
        segment.getPlaces().addAll(places);
        segment.setDepartureDate(departureDate);
        segment.setArriveDate(arriveDate);
        segment.setFare(segmentFare);
        segment.setEquivalentFare(equivalentSegmentFare);
        BigDecimal equivalentReservedSeatAmount = teletrainData.getReservedSeatAmount();
        Money reservedSeatAmount = null;
        if (equivalentReservedSeatAmount != null) {
            reservedSeatAmount = new Money();
            reservedSeatAmount.setValue(equivalentReservedSeatAmount);
            reservedSeatAmount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
        }
        ReservedSeat reservedSeat = new ReservedSeat();
        reservedSeat.setSegment(segment);
        reservedSeat.setFare(reservedSeatAmount);
        reservedSeat.setEquivalentFare(equivalentReservedSeatAmount);
        BigDecimal tariffAmount = teletrainData.getTariffAmount();
        BigDecimal serviceAmount = teletrainData.getServiceAmount();
        BigDecimal tariffVatAmount = teletrainData.getTariffVatAmount();
        BigDecimal serviceVatAmount = teletrainData.getServiceVatAmount();
        BigDecimal totalEquivalentFare = teletrainData.getTotalAmount();
        BigDecimal totalEquivalentVAT = teletrainData.getTotalVatAmount();
        VatDetalization vendorVatDetalization = new VatDetalization();
        if (tariffVatAmount != null || serviceVatAmount != null) {
            VatComponent vatComponent;
            double vatRate;
            vendorVatDetalization.setDetalized(true);
            vendorVatDetalization.getComponents().clear();
            if (tariffVatAmount != null) {
                vatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)issueDate);
                vatComponent = new VatComponent();
                vatComponent.setBasis(tariffAmount);
                vatComponent.setSum(tariffVatAmount);
                vatComponent.setRate(Double.valueOf(vatRate));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.FARE);
                vendorVatDetalization.getComponents().add(vatComponent);
            }
            if (serviceVatAmount != null) {
                vatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)issueDate);
                vatComponent = new VatComponent();
                vatComponent.setBasis(serviceAmount);
                vatComponent.setSum(serviceVatAmount);
                vatComponent.setRate(Double.valueOf(vatRate));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.SERVICE);
                vendorVatDetalization.getComponents().add(vatComponent);
            }
        }
        ArrayList<RailwayProductFop> vendorFOPs = new ArrayList<RailwayProductFop>();
        if (totalEquivalentFare != null) {
            Money amount = new Money();
            amount.setValue(totalEquivalentFare);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            fop.setAmount(amount);
            fop.setOperationDate(null);
            fop.setAgent(null);
            vendorFOPs.add(fop);
        }
        ArrayList<RailwayProductFop> subagentFOPs = new ArrayList<RailwayProductFop>();
        if (agency != null && subagency != null && !agency.equals((Object)subagency) && totalEquivalentFare != null) {
            Money amount = new Money();
            amount.setValue(totalEquivalentFare);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            fop.setAmount(amount);
            fop.setOperationDate(null);
            fop.setAgent(null);
            subagentFOPs.add(fop);
        }
        ArrayList<RailwayProductFop> clientFOPs = new ArrayList<RailwayProductFop>();
        if (totalEquivalentFare != null) {
            Money amount = new Money();
            amount.setValue(totalEquivalentFare);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            fop.setAmount(amount);
            fop.setOperationDate(null);
            fop.setAgent(null);
            clientFOPs.add(fop);
        }
        product.setStatus(status);
        product.setSystemNumber(systemNumber);
        product.setIssueDate(issueDate);
        product.setValidatorCode(validatorCode);
        product.setPcc(pccCode);
        product.setEquivalentFare(tariffAmount);
        product.setEquivalentVAT(tariffVatAmount);
        product.setServiceFare(serviceAmount);
        product.setServiceVAT(serviceVatAmount);
        product.setTotalEquivalentFare(totalEquivalentFare);
        product.setTotalEquivalentVAT(totalEquivalentVAT);
        product.setVendorVatDetalization(vendorVatDetalization);
        product.getPassengers().clear();
        product.getPassengers().addAll(travellers);
        product.getPassengerTypes().clear();
        product.setBlankType(blankType);
        product.setBlankOwnerRef(blankOwner);
        product.setProvider(provider);
        product.getSegments().clear();
        product.getSegments().add(segment);
        product.getReservedSeats().clear();
        product.getReservedSeats().add(reservedSeat);
        product.setContractRulesApplied(false);
        for (Object item : RailwayProductHelper.getContractRelations((RailwayProduct)product)) {
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case VENDOR: {
                    item.getFops().clear();
                    item.getFops().addAll(vendorFOPs);
                    break;
                }
                case SUBAGENCY: {
                    item.getFops().clear();
                    item.getFops().addAll(subagentFOPs);
                    break;
                }
                case CLIENT: {
                    item.getFops().clear();
                    item.getFops().addAll(clientFOPs);
                }
            }
        }
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, supplier);
        RailwayProductHelper.setAgency((BaseTicketProduct)product, (EntityReference)agency);
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, (EntityReference)subagency);
        product.setSalesPoint(salesPoint);
        product.setCashier(agent);
        product.setTicketType(ticketType);
        boolean updatedProduct = false;
        block6: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!basePoduct.getUid().equals(product.getUid())) continue;
                updatedProduct = true;
                continue block6;
            }
        }
        boolean bookingFileContainsNonFakeSell = false;
        boolean bookingFileContainsNonFakeRefund = false;
        block8: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!(basePoduct instanceof BaseTicketProduct)) continue;
                BaseTicketProduct baseTicketProduct = (BaseTicketProduct)basePoduct;
                if (!(baseTicketProduct.getTicketType() == TicketType.FAKE || updatedProduct && baseTicketProduct.getUid().equals(product.getUid()))) {
                    if (baseTicketProduct.getStatus() == ProductStatus.SELL) {
                        bookingFileContainsNonFakeSell = true;
                    } else if (baseTicketProduct.getStatus() == ProductStatus.REFUND) {
                        bookingFileContainsNonFakeRefund = true;
                    }
                }
                if (!bookingFileContainsNonFakeSell || !bookingFileContainsNonFakeRefund) continue;
                continue block8;
            }
        }
        if (!bookingFileContainsNonFakeSell && product.getTicketType() != TicketType.FAKE && (product.getStatus() == ProductStatus.SELL || !bookingFileContainsNonFakeRefund && product.getStatus() == ProductStatus.REFUND)) {
            bookingFile.setAgency(RailwayProductHelper.getAgency((RailwayProduct)product));
            bookingFile.setCreateDate(product.getIssueDate());
        }
        for (Reservation reservation : bookingFile.getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)teletrainData.getPnr(), (GdsName)GdsName.TELETRAIN)) continue;
            boolean reservationContainsNonFakeSell = false;
            boolean reservationContainsNonFakeRefund = false;
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof BaseTicketProduct)) continue;
                BaseTicketProduct baseTicketProduct = (BaseTicketProduct)baseProduct;
                if (!(baseTicketProduct.getTicketType() == TicketType.FAKE || updatedProduct && baseTicketProduct.getUid().equals(product.getUid()))) {
                    if (baseTicketProduct.getStatus() == ProductStatus.SELL) {
                        reservationContainsNonFakeSell = true;
                    } else if (baseTicketProduct.getStatus() == ProductStatus.REFUND) {
                        reservationContainsNonFakeRefund = true;
                    }
                }
                if (!reservationContainsNonFakeSell || !reservationContainsNonFakeRefund) continue;
                break;
            }
            if (!reservationContainsNonFakeSell && product.getTicketType() != TicketType.FAKE && (product.getStatus() == ProductStatus.SELL || !reservationContainsNonFakeRefund && product.getStatus() == ProductStatus.REFUND)) {
                reservation.setBookingAgent(product.getCashier());
                reservation.setSalesPoint(product.getSalesPoint());
                reservation.setSubagency(RailwayProductHelper.getSubagency((RailwayProduct)product));
                reservation.setResDate(product.getIssueDate());
            }
            if (updatedProduct) break;
            product.setReservation(reservation);
            reservation.getProducts().add(product);
            break;
        }
        List productTravellers = product.getPassengers();
        List bookingTravellers = bookingFile.getTravellers();
        ArrayList<Traveller> updatedProductTravellers = new ArrayList<Traveller>();
        for (Traveller productTraveller : productTravellers) {
            boolean contains = false;
            for (Traveller bookingTraveller : bookingTravellers) {
                if (!this.compareTravellers(productTraveller, bookingTraveller)) continue;
                contains = true;
                updatedProductTravellers.add(bookingTraveller);
                break;
            }
            if (contains) continue;
            updatedProductTravellers.add(productTraveller);
            bookingTravellers.add(productTraveller);
        }
        productTravellers.clear();
        productTravellers.addAll(updatedProductTravellers);
    }

    private boolean compareTravellers(Traveller traveller01, Traveller traveller02) {
        String fullName02;
        String fullName01;
        if (traveller01 == null && traveller02 == null) {
            return true;
        }
        if (traveller01 == null || traveller02 == null) {
            return false;
        }
        if (traveller01.getPassport() != null && traveller02.getPassport() != null) {
            fullName01 = TextUtil.buildFullName((PersonalName)traveller01.getPassport());
            fullName02 = TextUtil.buildFullName((PersonalName)traveller02.getPassport());
            if (!TextUtil.isBlank((String)fullName01) && !TextUtil.isBlank((String)fullName02)) {
                return TextUtil.isSame((String)fullName01, (String)fullName02, (boolean)true);
            }
        }
        if (traveller01.getName() != null && traveller02.getName() != null) {
            fullName01 = traveller01.getName();
            fullName02 = traveller02.getName();
            if (!TextUtil.isBlank((String)fullName01) && !TextUtil.isBlank((String)fullName02)) {
                return TextUtil.isSame((String)fullName01, (String)fullName02, (boolean)true);
            }
        }
        return false;
    }

    private DictionaryReference<BlankType> findBlankType(String blankTypeCode) {
        BlankType blankType;
        if (Environment.isPublished(DictionaryCache.class) && (blankType = (BlankType)DictionaryCache.get().findByCode(BlankType.class, blankTypeCode)) != null) {
            return blankType.toReference();
        }
        return null;
    }

    private ProductStatus getProductStatus(TransactionType transactionType) {
        if (transactionType == null) {
            return null;
        }
        switch (transactionType) {
            case SELL: {
                return ProductStatus.SELL;
            }
            case REFUND: {
                return ProductStatus.REFUND;
            }
            case CANCEL: {
                return ProductStatus.VOID;
            }
        }
        return null;
    }

    private static EntityReference<Organization> getOrganizationByCode(String code) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)code));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()), SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT.name()), SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY.name())}));
        List indexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        if (indexes.size() > 0) {
            return ((OrganizationIndex)indexes.get(0)).getSource();
        }
        return null;
    }
}

