/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.teletrain;

import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Date;

public class TeletrainUpdateRailwayProductRefundProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ProductSearchResult searchResult = (ProductSearchResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        RailwayProduct refundProduct = (RailwayProduct)searchResult.getProduct();
        RailwayProduct sellProduct = refundProduct.getPreviousProduct();
        if (sellProduct.getTicketType() != TicketType.FAKE) {
            this.synchronizeSellAndRefundData(sellProduct, refundProduct);
        }
    }

    private void synchronizeSellAndRefundData(RailwayProduct sellProduct, RailwayProduct refundProduct) throws Exception {
        int refundProductSegmentNumber;
        for (RailwaySegment sellProductSegment : sellProduct.getSegments()) {
            int sellProductSegmentNumber = sellProductSegment.getNumber();
            for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                int refundProductSegmentNumber2 = refundProductSegment.getNumber();
                if (refundProductSegmentNumber2 != sellProductSegmentNumber) continue;
                refundProductSegment.setFare(sellProductSegment.getFare());
                refundProductSegment.setEquivalentFare(sellProductSegment.getEquivalentFare());
                refundProductSegment.setEquivalentVAT(sellProductSegment.getEquivalentVAT());
            }
        }
        refundProduct.getReservedSeats().clear();
        for (ReservedSeat sellProductReservedSeat : sellProduct.getReservedSeats()) {
            ReservedSeat refundProductReservedSeat = (ReservedSeat)XCloneHelper.clone((XCloneable)sellProductReservedSeat);
            refundProductReservedSeat.setSegment(null);
            RailwaySegment sellProductReservedSeatSegment = sellProductReservedSeat.getSegment();
            if (sellProductReservedSeatSegment != null) {
                int sellProductReservedSeatSegmentNumber = sellProductReservedSeatSegment.getNumber();
                for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                    refundProductSegmentNumber = refundProductSegment.getNumber();
                    if (refundProductSegmentNumber != sellProductReservedSeatSegmentNumber) continue;
                    refundProductReservedSeat.setSegment(refundProductSegment);
                }
            }
            refundProduct.getReservedSeats().add(refundProductReservedSeat);
        }
        refundProduct.getTaxes().clear();
        for (RailwayTax sellProductTax : sellProduct.getTaxes()) {
            RailwayTax refundProductTax = (RailwayTax)XCloneHelper.clone((XCloneable)sellProductTax);
            refundProductTax.setSegment(null);
            RailwaySegment sellProductTaxSegment = sellProductTax.getSegment();
            if (sellProductTaxSegment != null) {
                int sellProductTaxSegmentNumber = sellProductTaxSegment.getNumber();
                for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                    refundProductSegmentNumber = refundProductSegment.getNumber();
                    if (refundProductSegmentNumber != sellProductTaxSegmentNumber) continue;
                    refundProductTax.setSegment(refundProductSegment);
                }
            }
            refundProduct.getTaxes().add(refundProductTax);
        }
        refundProduct.setEquivalentFare(sellProduct.getEquivalentFare());
        refundProduct.setEquivalentVAT(sellProduct.getEquivalentVAT());
        refundProduct.setServiceFare(sellProduct.getServiceFare());
        refundProduct.setServiceVAT(sellProduct.getServiceVAT());
        refundProduct.setVendorVatDetalization(null);
        BigDecimal sellTotalEquivalentFare = sellProduct.getTotalEquivalentFare();
        BigDecimal refundTotalEquivalentFare = refundProduct.getTotalEquivalentFare();
        BigDecimal penaltyFare = null;
        if (sellTotalEquivalentFare != null && refundTotalEquivalentFare != null) {
            penaltyFare = sellTotalEquivalentFare.subtract(refundTotalEquivalentFare);
        }
        BigDecimal penaltyVat = null;
        if (penaltyFare != null && penaltyFare.compareTo(BigDecimal.ZERO) != 0) {
            double vatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.PENALTY, (Date)refundProduct.getIssueDate());
            VatAmount vatAmount = new VatAmount();
            vatAmount.setTotalVat(penaltyFare, vatRate);
            penaltyVat = vatAmount.getVatAmount();
            refundProduct.setPenalty(penaltyFare);
            refundProduct.setPenaltyVAT(penaltyVat);
        }
        BigDecimal sellTotalEquivalentVat = sellProduct.getTotalEquivalentVAT();
        BigDecimal refundTotalEquivalentVat = null;
        if (sellTotalEquivalentVat != null) {
            refundTotalEquivalentVat = sellTotalEquivalentVat;
        }
        if (penaltyVat != null) {
            refundTotalEquivalentVat = refundTotalEquivalentVat == null ? penaltyVat.negate() : refundTotalEquivalentVat.subtract(penaltyVat);
        }
        refundProduct.setTotalEquivalentVAT(refundTotalEquivalentVat);
    }
}

